/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.api.energy.containers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.networking.SyncType;

public class DynamicStatisticEnergyStorage
extends DynamicEnergyStorage {
    private final List<Long> inserted = new ArrayList<Long>();
    private final List<Long> extracted = new ArrayList<Long>();
    private final Long[] historicInsert = new Long[20];
    private final Long[] historicExtract = new Long[20];
    private int currentInsertSources = 0;

    public DynamicStatisticEnergyStorage(long capacity, long maxInsert, long maxExtract, Runnable onUpdate) {
        super(capacity, maxInsert, maxExtract, onUpdate);
        Arrays.fill((Object[])this.historicInsert, (Object)0L);
        Arrays.fill((Object[])this.historicExtract, (Object)0L);
    }

    @Override
    public long insert(long amount, boolean simulate) {
        long inserted = super.insert(amount, simulate);
        if (!simulate && inserted > 0L) {
            this.inserted.add(inserted);
        }
        return inserted;
    }

    @Override
    public long extract(long amount, boolean simulate) {
        long extracted = super.extract(amount, simulate);
        if (!simulate && extracted > 0L) {
            this.extracted.add(extracted);
        }
        return extracted;
    }

    public void tick(long worldTicks) {
        int index = (int)(worldTicks % 20L);
        this.historicInsert[index] = this.inserted.stream().mapToLong(Long::longValue).sum();
        this.historicExtract[index] = this.extracted.stream().mapToLong(Long::longValue).sum();
        this.currentInsertSources = this.inserted.size();
        this.inserted.clear();
        this.extracted.clear();
    }

    public EnergyStatistics getCurrentStatistics(long worldTicks) {
        int index = (int)(worldTicks % 20L);
        return new EnergyStatistics((float)Arrays.stream(this.historicInsert).mapToLong(Long::longValue).average().orElse(0.0), (float)Arrays.stream(this.historicExtract).mapToLong(Long::longValue).average().orElse(0.0), this.historicInsert[index], this.historicExtract[index], this.currentInsertSources, Arrays.stream(this.historicInsert).mapToLong(Long::longValue).max().orElse(0L), Arrays.stream(this.historicExtract).mapToLong(Long::longValue).max().orElse(0L));
    }

    @Override
    public boolean useDeltaOnly(SyncType type) {
        return false;
    }

    public record EnergyStatistics(float avgInsertSecond, float avgExtractSecond, long insertedLastTickTotal, long extractedLastTickTotal, int insertionCountLastTick, long maxInsertSecond, long maxExtractSecond) {
        public static final EnergyStatistics EMPTY = new EnergyStatistics(0.0f, 0.0f, 0L, 0L, 0, 0L, 0L);

        @Override
        @NotNull
        public String toString() {
            return "EnergyStatistics{avgInsertSecond=" + this.avgInsertSecond + ", avgExtractSecond=" + this.avgExtractSecond + ", insertedLastTickTotal=" + this.insertedLastTickTotal + ", extractedLastTickTotal=" + this.extractedLastTickTotal + ", insertionCountLastTick=" + this.insertionCountLastTick + ", maxInsertSecond=" + this.maxInsertSecond + ", maxExtractSecond=" + this.maxExtractSecond + "}";
        }
    }
}

