package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.*;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.energy.containers.DynamicStatisticEnergyStorage.EnergyStatistics;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.block.entity.storage.UnstableContainerBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.ItemContent;
import rearth.oritech.util.TooltipHelper;

import java.util.Collection;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2586;

public class EnergyStorageScreen extends UpgradableMachineScreen<UpgradableMachineScreenHandler> {
    
    private LabelComponent inAvgSecond;
    private LabelComponent inLastTick;
    private LabelComponent inSources;
    private LabelComponent inPeak;
    private LabelComponent outAvgSecond;
    private LabelComponent outLastTick;
    private LabelComponent outPeak;
    private boolean showingOutput;
    
    public EnergyStorageScreen(UpgradableMachineScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }
    
    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        
        var panelXPos = 74;
        
        var insertionContainer = Containers.verticalFlow(Sizing.fixed(94), Sizing.content());
        insertionContainer.surface(Surface.PANEL_INSET);
        insertionContainer.padding(Insets.of(2, 2, 4, 8));
        insertionContainer.positioning(Positioning.absolute(panelXPos, 23));
        
        inAvgSecond = Components.label(class_2561.method_43470("X RF/t"));
        inAvgSecond.tooltip(class_2561.method_43471("title.oritech.energy.inAvgSecond.tooltip"));
        inLastTick = Components.label(class_2561.method_43470("X RF/t"));
        inLastTick.tooltip(class_2561.method_43471("title.oritech.energy.inLastTick.tooltip"));
        inSources = Components.label(class_2561.method_43470("X"));
        inSources.tooltip(class_2561.method_43471("title.oritech.energy.inSources.tooltip"));
        inPeak = Components.label(class_2561.method_43470("X RF/t"));
        inPeak.tooltip(class_2561.method_43471("title.oritech.energy.inPeak.tooltip"));
        
        insertionContainer.child(inLastTick.margins(Insets.of(2)));
        insertionContainer.child(inAvgSecond.margins(Insets.of(2)));
        insertionContainer.child(inPeak.margins(Insets.of(2)));
        insertionContainer.child(inSources.margins(Insets.of(2)));
        
        var extractionContainer = Containers.verticalFlow(Sizing.fixed(94), Sizing.content());
        extractionContainer.surface(Surface.PANEL_INSET);
        extractionContainer.padding(Insets.of(2, 2, 4, 8));
        extractionContainer.positioning(Positioning.absolute(panelXPos, 23));
        
        outAvgSecond = Components.label(class_2561.method_43470("X RF/t"));
        outAvgSecond.tooltip(class_2561.method_43471("title.oritech.energy.outAvgSecond.tooltip"));
        outLastTick = Components.label(class_2561.method_43470("X RF/t"));
        outLastTick.tooltip(class_2561.method_43471("title.oritech.energy.outLastTick.tooltip"));
        outPeak = Components.label(class_2561.method_43470("X RF/t"));
        outPeak.tooltip(class_2561.method_43471("title.oritech.energy.outPeak.tooltip"));
        
        extractionContainer.child(outLastTick.margins(Insets.of(2)));
        extractionContainer.child(outAvgSecond.margins(Insets.of(2)));
        extractionContainer.child(outPeak.margins(Insets.of(2)));
        
        overlay.child(insertionContainer);
        
        var toggleButton = Components.button(class_2561.method_43470("                  ").method_10852(class_2561.method_43471("title.oritech.item_filter.toggle_energy_statistics").method_54663(BasicMachineScreen.GRAY_TEXT_COLOR)), buttonComponent -> {
            showingOutput = !showingOutput;
            if (showingOutput) {
                overlay.removeChild(insertionContainer);
                overlay.child(extractionContainer);
            } else {
                overlay.removeChild(extractionContainer);
                overlay.child(insertionContainer);
            }
        });
        toggleButton.horizontalSizing(Sizing.fixed(60));
        toggleButton.renderer(ItemFilterScreen.createToggleRenderer(ignored -> showingOutput));
        toggleButton.textShadow(false);
        overlay.child(toggleButton.positioning(Positioning.absolute(panelXPos, 5)));
        
        if (this.field_2797.blockEntity instanceof UnstableContainerBlockEntity unstableContainer) {
            var container = (DynamicEnergyStorage) unstableContainer.getEnergyStorageForMultiblock(null);
            var capacity = container.maxInsert;
            var capacityMultiplier = capacity / (UnstableContainerBlockEntity.BASE_CAPACITY * unstableContainer.qualityMultiplier);   // in percent, exponential
            var laserIcon = Components.item(new class_1799(BlockContent.LASER_ARM_BLOCK.method_8389()));
            var laserLabel = Components.label(class_2561.method_43470("x" + String.format("%.1f", capacityMultiplier)));
            
            Collection<class_2561> tooltipText = List.of(class_2561.method_43471("tooltip.oritech.unstable_laser_tooltip"), class_2561.method_43471("tooltip.oritech.unstable_laser_tooltip.2"));
            
            laserIcon.tooltip(tooltipText);
            laserLabel.tooltip(tooltipText);
            
            var laserContainer = Containers.verticalFlow(Sizing.fixed(44), Sizing.fixed(37));
            laserContainer.surface(Surface.PANEL_INSET);
            laserContainer.child(laserIcon.margins(Insets.of(2, 0, 0, 0)));
            laserContainer.child(laserLabel.margins(Insets.of(4, 2, 4, 4)));
            laserContainer.horizontalAlignment(HorizontalAlignment.CENTER);
            
            overlay.child(laserContainer.positioning(Positioning.absolute(27, 5)));
            
            var containedIcon = Components.item(new class_1799(unstableContainer.capturedBlock.method_26204().method_8389()));
            var containedLabel = Components.label(class_2561.method_43470("x" + unstableContainer.qualityMultiplier));
            var containedTooltipText = class_2561.method_43471("tooltip.oritech.unstable_contained_tooltip");
            containedIcon.tooltip(containedTooltipText);
            containedLabel.tooltip(containedTooltipText);
            
            var containedContainer = Containers.verticalFlow(Sizing.fixed(44), Sizing.content());
            containedContainer.surface(Surface.PANEL_INSET);
            containedContainer.child(containedIcon.margins(Insets.of(2, 0, 0, 0)));
            containedContainer.child(containedLabel.margins(Insets.of(4, 2, 4, 4)));
            containedContainer.horizontalAlignment(HorizontalAlignment.CENTER);
            
            overlay.child(containedContainer.positioning(Positioning.absolute(27, 11 + 33 + 2)));
        }
        
    }
    
    @Override
    protected void method_37432() {
        super.method_37432();
        
        var entity = this.field_2797.blockEntity;
        var statistics = getStatistics(entity);
        if (statistics == null) return;
        
        var updateAll = this.field_2797.worldAccess.method_8510() % 4 == 0;
        
        if (updateAll) {
            inAvgSecond.text(class_2561.method_43469("title.oritech.energy.inAvgSecond", TooltipHelper.getEnergyText((long) statistics.avgInsertSecond())));
            inSources.text(class_2561.method_43469("title.oritech.energy.inSources", statistics.insertionCountLastTick()));
            inPeak.text(class_2561.method_43469("title.oritech.energy.inPeak", TooltipHelper.getEnergyText(statistics.maxInsertSecond())));
            outAvgSecond.text(class_2561.method_43469("title.oritech.energy.outAvgSecond", TooltipHelper.getEnergyText((long) statistics.avgExtractSecond())));
            outPeak.text(class_2561.method_43469("title.oritech.energy.outPeak", TooltipHelper.getEnergyText(statistics.maxExtractSecond())));
        }
        
        inLastTick.text(class_2561.method_43469("title.oritech.energy.inLastTick", TooltipHelper.getEnergyText(statistics.insertedLastTickTotal())));
        outLastTick.text(class_2561.method_43469("title.oritech.energy.outLastTick", TooltipHelper.getEnergyText(statistics.extractedLastTickTotal())));
        
        
    }
    
    public EnergyStatistics getStatistics(class_2586 entity) {
        return (entity instanceof ExpandableEnergyStorageBlockEntity) ? ((ExpandableEnergyStorageBlockEntity) entity).currentStats : ((UnstableContainerBlockEntity) entity).currentStats;
    }
    
    @Override
    public boolean useHighTitle() {
        return true;
    }
    
    @Override
    public class_1799 getTitleIcon() {
        if (this.field_2797.blockEntity instanceof UnstableContainerBlockEntity) {
            return new class_1799(ItemContent.UNSTABLE_CONTAINER);
        }
        return super.getTitleIcon();
    }
}
