package rearth.oritech.client.renderers.util;

import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_7833;

public class BeamRenderer {
    
    public static int color(int r, int g, int b, int a) {
        return (a * 255) << 24
                 | (r * 255) << 16
                 | (g * 255) << 8
                 | (b * 255);
    }
    
    /**
     * Renders a solid, straight beam between two points using a rectangular prism geometry.
     * The beam is rotated to align with the vector provided.
     * <p>
     * The beam gradient is interpolated along the Y-axis of the model (length).
     *
     * @param poseStack   The matrix stack used for rendering.
     * @param consumer    The vertex consumer (buffer) to draw vertices into.
     * @param startPos    The starting position of the beam relative to the current PoseStack origin.
     * @param delta       The vector defining the direction and length of the beam (EndPos - StartPos).
     * @param thickness   The radius (half-width) of the beam.
     * @param packedLight The light value to render with (usually {@code LightTexture.FULL_BRIGHT} for glowing).
     * @param startColor  The ARGB color integer for the start of the beam (e.g. 0xB4FF0000).
     * @param endColor    The ARGB color integer for the end of the beam.
     */
    public static void renderStraightBeam(class_4587 poseStack, class_4588 consumer, class_243 startPos, class_243 delta, float thickness, int packedLight, int startColor, int endColor) {
        poseStack.method_22903();
        
        // Translate to the start of the beam
        poseStack.method_22904(startPos.field_1352, startPos.field_1351, startPos.field_1350);
        
        // Calculate Yaw (Y-Axis rotation) and Pitch (X-Axis rotation) to align the beam
        // The beam model is defined along the Y-axis (Up), so we rotate it to match 'delta'
        double xzDist = Math.sqrt(delta.field_1352 * delta.field_1352 + delta.field_1350 * delta.field_1350);
        float yRot = (float) (-class_3532.method_15349(-delta.field_1352, delta.field_1350));
        float xRot = (float) (-class_3532.method_15349(delta.field_1351, xzDist));
        
        poseStack.method_22907(class_7833.field_40716.rotation(yRot));
        poseStack.method_22907(class_7833.field_40714.rotation(xRot + (float) (Math.PI / 2)));
        
        // Beam dimensions
        float length = (float) delta.method_1033();
        float r = thickness; // Radius
        
        // Extract ARGB components
        int a1 = (startColor >> 24) & 0xFF;
        int r1 = (startColor >> 16) & 0xFF;
        int g1 = (startColor >> 8) & 0xFF;
        int b1 = (startColor) & 0xFF;
        
        int a2 = (endColor >> 24) & 0xFF;
        int r2 = (endColor >> 16) & 0xFF;
        int g2 = (endColor >> 8) & 0xFF;
        int b2 = (endColor) & 0xFF;
        
        class_4587.class_4665 pose = poseStack.method_23760();
        
        // Draw the 4 sides of the rectangular prism
        
        // Front
        addVertex(consumer, pose, -r, 0, r, r1, g1, b1, a1, 0, 1, packedLight);
        addVertex(consumer, pose, r, 0, r, r1, g1, b1, a1, 1, 1, packedLight);
        addVertex(consumer, pose, r, length, r, r2, g2, b2, a2, 1, 0, packedLight);
        addVertex(consumer, pose, -r, length, r, r2, g2, b2, a2, 0, 0, packedLight);
        
        // Back
        addVertex(consumer, pose, r, 0, -r, r1, g1, b1, a1, 0, 1, packedLight);
        addVertex(consumer, pose, -r, 0, -r, r1, g1, b1, a1, 1, 1, packedLight);
        addVertex(consumer, pose, -r, length, -r, r2, g2, b2, a2, 1, 0, packedLight);
        addVertex(consumer, pose, r, length, -r, r2, g2, b2, a2, 0, 0, packedLight);
        
        // Left
        addVertex(consumer, pose, -r, 0, -r, r1, g1, b1, a1, 0, 1, packedLight);
        addVertex(consumer, pose, -r, 0, r, r1, g1, b1, a1, 1, 1, packedLight);
        addVertex(consumer, pose, -r, length, r, r2, g2, b2, a2, 1, 0, packedLight);
        addVertex(consumer, pose, -r, length, -r, r2, g2, b2, a2, 0, 0, packedLight);
        
        // Right
        addVertex(consumer, pose, r, 0, r, r1, g1, b1, a1, 0, 1, packedLight);
        addVertex(consumer, pose, r, 0, -r, r1, g1, b1, a1, 1, 1, packedLight);
        addVertex(consumer, pose, r, length, -r, r2, g2, b2, a2, 1, 0, packedLight);
        addVertex(consumer, pose, r, length, r, r2, g2, b2, a2, 0, 0, packedLight);
        
        poseStack.method_22909();
    }
    
    private static void addVertex(class_4588 consumer, class_4587.class_4665 pose, float x, float y, float z, int r, int g, int b, int a, float u, float v, int packedLight) {
        consumer.method_22918(pose.method_23761(), x, y, z)
          .method_1336(r, g, b, a)
          .method_22913(u, v)
          .method_22922(class_4608.field_21444)
          .method_60803(packedLight)
          .method_60831(pose, 0, 1, 0);
    }
}