package rearth.oritech.client.renderers;

import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import rearth.oritech.block.base.block.FrameInteractionBlock;
import rearth.oritech.block.base.entity.FrameInteractionBlockEntity;
import rearth.oritech.block.entity.interaction.DestroyerBlockEntity;
import rearth.oritech.init.BlockContent;

public class MachineGantryRenderer implements class_827<FrameInteractionBlockEntity> {
    
    private static final class_2680 renderedBeam = BlockContent.FRAME_GANTRY_ARM.method_9564();
    private static final float BEAM_DEPTH = 3 / 16f;
    private static final class_5819 renderRandom = class_5819.method_43049(100);
    
    @Override
    public int method_33893() {
        return 128;
    }
    
    @Override
    public boolean shouldRenderOffScreen(FrameInteractionBlockEntity blockEntity) {
        return true;
    }
    
    @Override
    public void render(FrameInteractionBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        
        var state = entity.method_11010();
        if (!state.method_11654(FrameInteractionBlock.HAS_FRAME) || entity.getAreaMin() == null || entity.getLastTarget() == null)
            return;
        
        var currentTarget = entity.getCurrentTarget();
        var renderedPosition = class_243.method_24954(currentTarget);
        
        var movingOffset = new class_243(0, 0, 0);
        
        if (entity.isMoving()) {
            var lastPosition = class_243.method_24954(entity.getLastTarget());
            var progress = (entity.getCurrentProgress()) / entity.getMoveTime();
            progress = Math.min(progress, 1);
            var offset = renderedPosition.method_1020(lastPosition);
            renderedPosition = lastPosition.method_1019(offset.method_1021(progress));
        } else {
            // apply slight shaking while working
            var offsetY = renderRandom.method_43057() * 0.012 - 0.004;
            movingOffset = new class_243(0, offsetY, 0);
        }
        
        
        renderedPosition = LaserArmRenderer.lerp(entity.lastRenderedPosition, renderedPosition, 0.04f);
        entity.lastRenderedPosition = renderedPosition;
        var targetOffset = renderedPosition.method_1020(class_243.method_24954(entity.method_11016())).method_1019(movingOffset);
        
        matrices.method_22903();
        matrices.method_22904(targetOffset.method_10216(), targetOffset.method_10214(), targetOffset.method_10215());
        
        var pos = entity.getCurrentTarget(); // relevant for correct lighting, actual rendered position is determined by matrix
        int lightAtHead = class_761.method_23794(entity.method_10997(), currentTarget);
        var renderer = class_310.method_1551().method_1541();
        
        renderer.method_3353(
          entity.getMachineHead(),
          matrices,
          vertexConsumers,
          lightAtHead,
          overlay);
        
        matrices.method_22909();
        
        var length = entity.getAreaMax().method_10263() - entity.getAreaMin().method_10263() + 2 - BEAM_DEPTH * 2f;
        var target = new class_243(entity.getAreaMin().method_10263() - 0.5 + BEAM_DEPTH, renderedPosition.field_1351, renderedPosition.field_1350).method_1020(class_243.method_24954(entity.method_11016()));
        
        
        matrices.method_22903();
        
        matrices.method_22904(target.method_10216(), target.method_10214(), target.method_10215());
        matrices.method_22905(length, 1, 1);
        
        renderer.method_3353(
          renderedBeam,
          matrices,
          vertexConsumers,
          lightAtHead,
          overlay);
        
        matrices.method_22909();
        
        var renderedItem = entity.getToolheadAdditionalRender();
        if (renderedItem != null) {
            matrices.method_22903();
            matrices.method_22904(targetOffset.method_10216() + 0.4, targetOffset.method_10214(), targetOffset.method_10215() + 0.4);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(30));
            // matrices.scale(0.3f, 0.3f, 0.3f);
            
            class_310.method_1551().method_1480().method_23178(
              renderedItem,
              class_811.field_4322,
              light,
              class_4608.field_21444,
              matrices,
              vertexConsumers,
              entity.method_10997(),
              0
            );
            
            matrices.method_22909();
        }
        
        if (entity instanceof DestroyerBlockEntity destroyerBlock && destroyerBlock.range > 1) {
            
            var beamHeight = pos.method_10264() - destroyerBlock.quarryTarget.method_10264() - 1.3f;
            
            var beamInner = BlockContent.QUARRY_BEAM_INNER.method_9564();
            var beamFrame = BlockContent.QUARRY_BEAM_TARGET.method_9564();
            var beamRing = BlockContent.QUARRY_BEAM_RING.method_9564();
            
            var offset = targetOffset.method_1031(0, -1, 0);
            
            matrices.method_22903();
            matrices.method_22904(offset.method_10216(), offset.method_10214() - beamHeight + 1, offset.method_10215());
            matrices.method_22905(1, beamHeight, 1);
            
            // outer beam
//            MinecraftClient.getInstance().getBlockRenderManager().renderBlock(
//              beamFrame,
//              pos,
//              entity.getWorld(),
//              matrices,
//              vertexConsumers.getBuffer(RenderLayers.getBlockLayer(beamFrame)),
//              true,
//              random);
            
            matrices.method_22904(0.5, 0, 0.5);
            var rotation = new Quaternionf(new AxisAngle4f((entity.method_10997().method_8510() / 3f) % 360, 0, 1, 0));
            matrices.method_22907(rotation);
            matrices.method_22904(-0.5, 0, -0.5);
            
            // inner beam
            renderer.method_3353(
              beamInner,
              matrices,
              vertexConsumers,
              lightAtHead,
              overlay);
            
            matrices.method_22909();
            
            // beam ring
            matrices.method_22903();
            var ringHeight = Math.sin((entity.method_10997().method_8510() + tickDelta) / 4f);
            var heightOffset = beamHeight * 0.5 * ringHeight + beamHeight * 0.5;
            matrices.method_22904(offset.method_10216(), offset.method_10214() - heightOffset + 1, offset.method_10215());
            
            // outer beam
            renderer.method_3353(
              beamRing,
              matrices,
              vertexConsumers,
              lightAtHead,
              overlay);
            matrices.method_22909();
        }
    }
}
