package rearth.oritech.block.entity.storage;

import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.ExpandableMultiblockEnergyStorageBlockEntity;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.init.BlockEntitiesContent;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

public class LargeStorageBlockEntity extends ExpandableMultiblockEnergyStorageBlockEntity implements RedstoneAddonBlockEntity.RedstoneControllable {
    
    public LargeStorageBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.LARGE_STORAGE_ENTITY, pos, state);
    }
    
    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(
          new class_2382(0, 0,-1),
          new class_2382(0, 0,1),
          new class_2382(0, 1,-1),
          new class_2382(0, 1,1),
          new class_2382(1, 0,-1),
          new class_2382(1, 0,1),
          new class_2382(1, 1,-1),
          new class_2382(1, 1,1)
        );
    }
    
    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.largeEnergyStorage.energyCapacity();
    }
    
    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.largeEnergyStorage.maxEnergyInsertion();
    }
    
    @Override
    public long getDefaultExtractionRate() {
        return Oritech.CONFIG.largeEnergyStorage.maxEnergyExtraction();
    }
    
    @Override
    public List<class_2382> getCorePositions() {
        return List.of(
          new class_2382(0, 1,0),
          new class_2382(1, 0,0),
          new class_2382(1, 1,0)
        );
    }
    
    @Override
    public int getComparatorEnergyAmount() {
        if (energyStorage.amount == 0) return 0;
        return (int) (1 + ((energyStorage.amount / (float) energyStorage.capacity) * 14));
    }
    
    @Override
    public int getComparatorSlotAmount(int slot) {
        if (inventory.heldStacks.size() <= slot) return 0;
        
        var stack = inventory.method_5438(slot);
        if (stack.method_7960()) return 0;
        
        return (int) (1 + (stack.method_7947() / (float) stack.method_7914()) * 15);
    }
    
    @Override
    public int getComparatorProgress() {
        return 0;
    }
    
    @Override
    public int getComparatorActiveState() {
        return 15;
    }
    
    @Override
    public void onRedstoneEvent(boolean isPowered) {
        this.setRedstonePowered(isPowered);
    }
    
}
