package rearth.oritech.block.entity.interaction;

import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.*;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_7225;

import static rearth.oritech.block.base.block.MultiblockMachine.ASSEMBLED;
import static rearth.oritech.block.base.entity.MachineBlockEntity.*;


public class DeepDrillEntity extends NetworkedBlockEntity implements EnergyApi.BlockProvider, GeoBlockEntity, ItemApi.BlockProvider, MultiblockMachineController, ColorableMachine {
    
    // work data
    private boolean initialized;
    public final List<class_2248> targetedOre = new ArrayList<>();
    public int progress;
    @SyncField
    private long lastWorkTime;
    
    // config
    
    // storage
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(Oritech.CONFIG.deepDrillConfig.energyCapacity(), getMaxRfInput(), 0, this::method_5431);
    
    public final SimpleInventoryStorage inventory = createInventoryStorage();
    
    private @NotNull SimpleInventoryStorage createInventoryStorage() {
        return new SimpleInventoryStorage(1, this::method_5431);
    }
    
    // multiblock
    private final ArrayList<class_2338> coreBlocksConnected = new ArrayList<>();
    private float coreQuality = 1f;
    
    // animation
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache(this);
    private final AnimationController<DeepDrillEntity> animationController = getAnimationController();
    
    @SyncField({SyncType.SPARSE_TICK, SyncType.INITIAL})
    public ColorableMachine.ColorVariant currentColor = getDefaultColor();
    
    public DeepDrillEntity(class_2338 pos, class_2680 state) {
        this(BlockEntitiesContent.DEEP_DRILL_ENTITY, pos, state);
    }
    
    // this second option is here to allow addons to create custom deep drill entities with special logic
    public DeepDrillEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }
    
    public boolean init(boolean manual) {
        
        initialized = true;
        targetedOre.clear();
        loadOreBlocks(manual);

        return !targetedOre.isEmpty();
    }
    
    
    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        
        if (isActive(state) && !initialized && (world.method_8510() + pos.method_10063()) % 60 == 0) {
            init(false);
        }
        
        if (world.method_8608() || !initialized || targetedOre.isEmpty()) return;
        if (!inventory.method_5442() && inventory.heldStacks.get(0).method_7947() >= inventory.heldStacks.get(0).method_7914())
            return;    // inv full
        
        var energyPerStep = getRfPerStep();
        
        if (energyStorage.amount >= energyPerStep) {
            progress++;
            energyStorage.amount -= energyPerStep;
            lastWorkTime = world.method_8510();
            method_5431();
            
            var particlePos = getCenter(0);
            ParticleContent.FURNACE_BURNING.spawn(world, class_243.method_24954(particlePos), 1);
        }
        
        // try increasing faster if too much energy is provided
        for (int i = 0; i < Oritech.CONFIG.deepDrillConfig.stepsPerOre(); i++) {
            if (energyStorage.amount >= energyPerStep) {
                progress++;
                energyStorage.amount -= energyPerStep;
            } else {
                break;
            }
        }
        
        if (progress >= Oritech.CONFIG.deepDrillConfig.stepsPerOre()) {
            craftResult(world, pos);
            progress -= Oritech.CONFIG.deepDrillConfig.stepsPerOre();
            this.method_5431();
        }
        
    }
    
    private class_2338 getCenter(int y) {
        var state = method_11010();
        var facing = state.method_11654(class_2741.field_12481);
        return field_11867.method_10081(Geometry.rotatePosition(new class_2382(1, y, 0), facing));
    }
    
    public void loadOreBlocks(boolean manual) {
        var center = getCenter(-1);
        
        for (int x = -1; x <= 1; x++) {
            for (int z = -1; z <= 1; z++) {
                // Only target the top-most uncovered resource node
                for (int y = 0; y >= -2; y--) {
                    var target = center.method_10069(x, y, z);
                    var targetState = field_11863.method_8320(target);
                    if (targetState.method_26164(TagContent.RESOURCE_NODES)) {
                        if (manual) ParticleContent.DEBUG_BLOCK.spawn(field_11863, class_243.method_24954(target));
                        targetedOre.add(targetState.method_26204());
                        break;
                    } else if (!targetState.method_26215()) break;
                }
            }
        }  
    }
    
    private void craftResult(class_1937 world, class_2338 pos) {
        var usedOre = targetedOre.get(world.field_9229.method_43051(0, targetedOre.size()));
        var nodeOreBlockItem = usedOre.method_8389();
        var sampleInv = new SimpleCraftingInventory(new class_1799(nodeOreBlockItem, 1));
        
        var recipeCandidate = world.method_8433().method_8132(RecipeContent.DEEP_DRILL, sampleInv, world);
        if (recipeCandidate.isEmpty())
            return;
        
        var output = recipeCandidate.get().comp_1933().getResults().get(0);
        inventory.insert(output, false);
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427(nbt, inventory.heldStacks, false, registryLookup);
        addMultiblockToNbt(nbt);
        addColorToNbt(nbt);
        nbt.method_10544("energy_stored", energyStorage.amount);
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429(nbt, inventory.heldStacks, registryLookup);
        loadMultiblockNbtData(nbt);
        loadColorFromNbt(nbt);
        energyStorage.amount = nbt.method_10537("energy_stored");
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return energyStorage;
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return inventory;
    }
    
    @Override
    public List<class_2382> getCorePositions() {
        return List.of(
          new class_2382(0, 0, 1),
          new class_2382(0, 0, -1),
          new class_2382(-1, 0, 1),
          new class_2382(-1, 0, 0),
          new class_2382(-1, 0, -1),
          new class_2382(-2, 0, 1),
          new class_2382(-2, 0, 0),
          new class_2382(-2, 0, -1),
          new class_2382(0, 1, 1),
          new class_2382(0, 1, 0),
          new class_2382(0, 1, -1),
          new class_2382(-1, 1, 1),
          new class_2382(-1, 1, 0),
          new class_2382(-1, 1, -1),
          new class_2382(-2, 1, 1),
          new class_2382(-2, 1, 0),
          new class_2382(-2, 1, -1),
          new class_2382(0, 2, 1),
          new class_2382(0, 2, 0),
          new class_2382(0, 2, -1),
          new class_2382(-1, 2, 1),
          new class_2382(-1, 2, 0),
          new class_2382(-1, 2, -1),
          new class_2382(-2, 2, 1),
          new class_2382(-2, 2, 0),
          new class_2382(-2, 2, -1)
        );
    }
    
    @Override
    public class_2350 getFacingForMultiblock() {
        var state = method_11010();
        return state.method_11654(class_2741.field_12481).method_10153();
    }
    
    @Override
    public class_2338 getPosForMultiblock() {
        return field_11867;
    }
    
    @Override
    public class_1937 getWorldForMultiblock() {
        return field_11863;
    }
    
    @Override
    public ArrayList<class_2338> getConnectedCores() {
        return coreBlocksConnected;
    }
    
    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }
    
    @Override
    public float getCoreQuality() {
        return coreQuality;
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return inventory;
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return null;
    }
    
    @Override
    public void triggerSetupAnimation() {
        triggerAnim("base_controller", "setup");
    }
    
    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(animationController);
    }
    
    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return animatableInstanceCache;
    }
    
    public int getMaxRfInput() {
        return 0;
    }
    
    public int getRfPerStep() {
        return Oritech.CONFIG.deepDrillConfig.energyPerStep();
    }
    
    @Override
    public ColorVariant getCurrentColor() {
        return currentColor;
    }
    
    @Override
    public void assignColor(ColorVariant color) {
        this.currentColor = color;
        
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.setChanged(false);
            this.sendUpdate(SyncType.SPARSE_TICK);
        }
    }
    
    private AnimationController<DeepDrillEntity> getAnimationController() {
        return new AnimationController<>(this, state -> {
            
            if (state.isCurrentAnimation(SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    state.setAndContinue(IDLE);
                } else {
                    return state.setAndContinue(SETUP);
                }
            }
            
            if (isActive(method_11010())) {
                
                var idleTime = field_11863.method_8510() - lastWorkTime;
                
                if (idleTime < 60) {
                    return state.setAndContinue(WORKING);
                } else {
                    return state.setAndContinue(IDLE);
                }
            } else {
                return state.setAndContinue(PACKAGED);
            }
        }).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler<>()).triggerableAnim("setup", SETUP);
    }
    
    public void setLastWorkTime(long lastWorkTime) {
        this.lastWorkTime = lastWorkTime;
    }
    
    private boolean isActive(class_2680 state) {
        return state.method_11654(ASSEMBLED);
    }
}
