package rearth.oritech.block.base.entity;

import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3545;
import net.minecraft.class_5558;
import net.minecraft.class_7225;

public abstract class PassiveGeneratorBlockEntity extends class_2586 implements EnergyApi.BlockProvider, class_5558<PassiveGeneratorBlockEntity> {
    
    protected final SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(0, 5_000, 200_000, this::method_5431);
    
    public PassiveGeneratorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }
    
    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, PassiveGeneratorBlockEntity blockEntity) {
        if (world.field_9236) return;
        
        if (isProducing()) {
            var producedAmount = getProductionRate();
            if (energyStorage.insertIgnoringLimit(producedAmount, false) > 0) {
                energyStorage.update();
            }
        }
        
        outputEnergy();
        
    }
    
    private void outputEnergy() {
        if (energyStorage.getAmount() <= 0) return;
        
        for (var target : getOutputTargets(field_11867, field_11863)) {
            var candidate = EnergyApi.BLOCK.find(field_11863, target.method_15442(), target.method_15441());
            if (candidate != null)
                EnergyApi.transfer(energyStorage, candidate, Long.MAX_VALUE, false);
        }
    }
    
    public abstract int getProductionRate();
    
    public abstract boolean isProducing();
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        energyStorage.setAmount(nbt.method_10537("energy"));
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10544("energy", energyStorage.getAmount());
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return energyStorage;
    }
    
    protected abstract Set<class_3545<class_2338, class_2350>> getOutputTargets(class_2338 pos, class_1937 world);
}
