/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;
import rearth.oritech.client.ui.AcceleratorScreenHandler;
import rearth.oritech.client.ui.BasicMachineScreen;

public class AcceleratorScreen
extends BasicMachineScreen<AcceleratorScreenHandler> {
    public static final class_2960 PARTICLE_OVERLAY = Oritech.id("textures/gui/modular/particle_background_arrow.png");
    private LabelComponent titleLabel;
    private LabelComponent speedLabel;
    private LabelComponent statusLabel;
    private ItemComponent activeParticleRenderer;

    public AcceleratorScreen(AcceleratorScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Override
    public boolean showExtensionPanel() {
        return false;
    }

    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        class_1799 shownItem = class_1799.field_8037;
        if (((AcceleratorScreenHandler)this.field_2797).accelerator.lastEvent.activeParticle() != class_1799.field_8037) {
            shownItem = ((AcceleratorScreenHandler)this.field_2797).accelerator.lastEvent.activeParticle();
        }
        this.activeParticleRenderer = Components.item((class_1799)shownItem);
        overlay.child((Component)this.activeParticleRenderer.positioning(Positioning.absolute((int)7, (int)34)));
        Component particleOverlay = Components.texture((class_2960)PARTICLE_OVERLAY, (int)0, (int)0, (int)24, (int)30, (int)24, (int)30).sizing(Sizing.fixed((int)24), Sizing.fixed((int)30));
        particleOverlay.zIndex(-1);
        overlay.child(particleOverlay.positioning(Positioning.absolute((int)3, (int)27)));
        this.titleLabel = Components.label((class_2561)class_2561.method_43470((String)"Waiting...").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067}));
        this.titleLabel.horizontalTextAlignment(HorizontalAlignment.CENTER).horizontalSizing(Sizing.fill()).verticalSizing(Sizing.fixed((int)10)).margins(Insets.of((int)1));
        this.speedLabel = Components.label((class_2561)class_2561.method_43470((String)"Speed: 0 blocks/s").method_27692(class_124.field_1074));
        this.speedLabel.margins(Insets.of((int)2));
        this.statusLabel = Components.label((class_2561)class_2561.method_43470((String)"Insert item to accelerate\nAnd some more details").method_27692(class_124.field_1074));
        this.statusLabel.horizontalTextAlignment(HorizontalAlignment.RIGHT).margins(Insets.of((int)2));
        FlowLayout labelContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)130), (Sizing)Sizing.fixed((int)100));
        labelContainer.child((Component)this.titleLabel).child((Component)this.speedLabel).child((Component)this.statusLabel);
        labelContainer.horizontalAlignment(HorizontalAlignment.RIGHT);
        labelContainer.positioning(Positioning.relative((int)82, (int)30));
        overlay.child((Component)labelContainer);
    }

    private void updateItemParticle() {
        class_1799 shownItem = class_1799.field_8037;
        if (((AcceleratorScreenHandler)this.field_2797).accelerator.lastEvent.lastEvent().equals((Object)AcceleratorControllerBlockEntity.ParticleEvent.ACCELERATING) && ((AcceleratorScreenHandler)this.field_2797).accelerator.lastEvent.activeParticle() != class_1799.field_8037) {
            shownItem = ((AcceleratorScreenHandler)this.field_2797).accelerator.lastEvent.activeParticle();
        }
        this.activeParticleRenderer.stack(shownItem);
    }

    @Override
    protected void method_37432() {
        AcceleratorControllerBlockEntity.LastEventPacket event = ((AcceleratorScreenHandler)this.field_2797).accelerator.lastEvent;
        this.titleLabel.horizontalTextAlignment(HorizontalAlignment.RIGHT);
        switch (event.lastEvent()) {
            case IDLE: {
                class_5250 text = class_2561.method_43471((String)"text.oritech.accelerator.ui.waiting.0");
                long time = ((AcceleratorScreenHandler)this.field_2797).blockEntity.method_10997().method_8510();
                if (time / 20L % 3L == 1L) {
                    text = class_2561.method_43471((String)"text.oritech.accelerator.ui.waiting.1");
                }
                if (time / 20L % 3L == 2L) {
                    text = class_2561.method_43471((String)"text.oritech.accelerator.ui.waiting.2");
                }
                text = text.method_27695(new class_124[]{class_124.field_1067, class_124.field_1074});
                this.titleLabel.horizontalTextAlignment(HorizontalAlignment.LEFT).text((class_2561)text);
                this.speedLabel.text((class_2561)class_2561.method_43471((String)"text.oritech.accelerator.ui.waiting").method_27692(class_124.field_1074));
                this.statusLabel.text((class_2561)class_2561.method_43470((String)" "));
                break;
            }
            case ERROR: {
                this.titleLabel.text((class_2561)class_2561.method_43471((String)"text.oritech.accelerator.ui.error").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067}));
                this.speedLabel.text((class_2561)class_2561.method_43471((String)"text.oritech.accelerator.ui.nogate").method_27692(class_124.field_1074));
                this.statusLabel.text((class_2561)class_2561.method_43471((String)"text.oritech.accelerator.ui.nogate.more").method_27692(class_124.field_1063));
                break;
            }
            case ACCELERATING: {
                float speed = event.lastEventSpeed();
                String gateDist = AcceleratorScreen.format(AcceleratorParticleLogic.getMaxGateDist(speed), 1);
                String curveDist = AcceleratorScreen.format(AcceleratorParticleLogic.getRequiredBendDist(speed), 1);
                this.titleLabel.text((class_2561)class_2561.method_43471((String)"text.oritech.accelerator.ui.accelerating").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067}));
                this.speedLabel.text((class_2561)class_2561.method_43469((String)"text.oritech.accelerator.ui.accelerating.speed", (Object[])new Object[]{AcceleratorScreen.format(event.lastEventSpeed(), 0)}).method_27692(class_124.field_1074));
                this.statusLabel.text((class_2561)class_2561.method_43469((String)"text.oritech.accelerator.ui.accelerating.stats", (Object[])new Object[]{gateDist, curveDist}).method_27692(class_124.field_1063));
                break;
            }
            case COLLIDED: {
                this.titleLabel.text((class_2561)class_2561.method_43471((String)"text.oritech.accelerator.ui.collision").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067}));
                this.speedLabel.text((class_2561)class_2561.method_43469((String)"text.oritech.accelerator.ui.collision.stats", (Object[])new Object[]{AcceleratorScreen.format(event.lastEventSpeed(), 0)}).method_27692(class_124.field_1074));
                this.statusLabel.text((class_2561)class_2561.method_43469((String)"text.oritech.accelerator.ui.collision.position", (Object[])new Object[]{event.lastEventPosition().method_23854()}).method_27692(class_124.field_1063));
                break;
            }
            case EXITED_FAST: {
                float speed = event.lastEventSpeed();
                String curveDist = AcceleratorScreen.format(AcceleratorParticleLogic.getRequiredBendDist(speed), 1);
                this.titleLabel.text((class_2561)class_2561.method_43471((String)"text.oritech.accelerator.ui.exited").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067}));
                this.speedLabel.text((class_2561)class_2561.method_43469((String)"text.oritech.accelerator.ui.accelerating.speed", (Object[])new Object[]{AcceleratorScreen.format(event.lastEventSpeed(), 0)}).method_27692(class_124.field_1074));
                this.statusLabel.text((class_2561)class_2561.method_43469((String)"text.oritech.accelerator.ui.exited.stats", (Object[])new Object[]{event.lastEventPosition().method_23854(), curveDist, AcceleratorScreen.format(event.minBendDist(), 1)}).method_27692(class_124.field_1063));
                break;
            }
            case EXITED_NO_GATE: {
                float speed = event.lastEventSpeed();
                String gateDist = AcceleratorScreen.format(AcceleratorParticleLogic.getMaxGateDist(speed), 1);
                this.titleLabel.text((class_2561)class_2561.method_43471((String)"text.oritech.accelerator.ui.exited").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067}));
                this.speedLabel.text((class_2561)class_2561.method_43469((String)"text.oritech.accelerator.ui.accelerating.speed", (Object[])new Object[]{AcceleratorScreen.format(event.lastEventSpeed(), 0)}).method_27692(class_124.field_1074));
                this.statusLabel.text((class_2561)class_2561.method_43469((String)"text.oritech.accelerator.ui.exited.nogate", (Object[])new Object[]{event.lastEventPosition().method_23854(), gateDist}).method_27692(class_124.field_1063));
            }
        }
        this.updateItemParticle();
        super.method_37432();
    }

    private static String format(float number, int decimal) {
        if (decimal <= 0) {
            return String.valueOf((int)number);
        }
        String format = "%." + decimal + "f";
        return String.format(format, Float.valueOf(number));
    }
}

