/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.LaserArmModel;
import rearth.oritech.util.Geometry;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class LaserArmRenderer<T extends LaserArmBlockEntity>
extends GeoBlockRenderer<T> {
    public static final class_1921.class_4687 CUSTOM_LINES = class_1921.method_24048((String)"lines", (class_293)class_290.field_29337, (class_293.class_5596)class_293.class_5596.field_27377, (int)1536, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_4668.field_29433).method_23607(class_4668.field_22241).method_23615(class_4668.field_21370).method_23610(class_4668.field_25643).method_23616(class_4668.field_21349).method_23603(class_4668.field_21345).method_23617(false));
    private static final HashMap<Long, class_243> cachedOffsets = new HashMap();

    public LaserArmRenderer(String modelPath) {
        super(new LaserArmModel(modelPath));
    }

    public int method_33893() {
        return 128;
    }

    public boolean shouldRenderOffScreen(T blockEntity) {
        return true;
    }

    public void postRender(class_4587 matrices, T laserEntity, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.postRender(matrices, (GeoAnimatable)((LaserArmBlockEntity)this.animatable), model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        if (((LaserArmBlockEntity)laserEntity).getCurrentTarget() == null || !((LaserArmBlockEntity)laserEntity).isFiring()) {
            return;
        }
        class_2350 facing = (class_2350)laserEntity.method_11010().method_11654((class_2769)class_2741.field_12525);
        class_243 startPos = ((LaserArmBlockEntity)laserEntity).laserHead;
        class_243 startOffset = new class_243(0.0, (double)1.65f, 0.0);
        class_243 targetPos = ((LaserArmBlockEntity)laserEntity).getVisualTarget();
        class_2248 targetBlock = laserEntity.method_10997().method_8320(((LaserArmBlockEntity)laserEntity).getCurrentTarget()).method_26204();
        if (((LaserArmBlockEntity)laserEntity).isTargetingAtomicForge(targetBlock)) {
            double moveX = 0.5;
            double moveZ = 0.5;
            if (startPos.field_1352 < targetPos.field_1352) {
                moveX = -0.5;
            }
            if (startPos.field_1350 < targetPos.field_1350) {
                moveZ = -0.5;
            }
            targetPos = targetPos.method_1031(moveX, 0.5, moveZ);
        } else if (((LaserArmBlockEntity)laserEntity).isTargetingDeepdrill(targetBlock)) {
            class_243 offset = cachedOffsets.computeIfAbsent(laserEntity.method_11016().method_10063(), id -> LaserArmRenderer.idToOffset(class_2338.method_10092((long)id), 0.5f, laserEntity.method_10997(), laserEntity.getCurrentTarget()));
            targetPos = targetPos.method_1019(offset);
        }
        if (((LaserArmBlockEntity)laserEntity).lastRenderPosition == null) {
            ((LaserArmBlockEntity)laserEntity).lastRenderPosition = targetPos;
        }
        ((LaserArmBlockEntity)laserEntity).lastRenderPosition = targetPos = LaserArmRenderer.lerp(((LaserArmBlockEntity)laserEntity).lastRenderPosition, targetPos, 0.06f);
        class_243 targetPosOffset = LaserArmRenderer.worldToOffsetPosition(facing, targetPos, startPos).method_1019(startOffset);
        class_243 forward = targetPos.method_1020(startPos).method_1029();
        if (!((LaserArmBlockEntity)laserEntity).isTargetingEnergyContainer() && !((LaserArmBlockEntity)laserEntity).isTargetingBuddingAmethyst() && (double)laserEntity.method_10997().field_9229.method_43057() > 0.7) {
            ParticleContent.LASER_BEAM_EFFECT.spawn(laserEntity.method_10997(), targetPos.method_1031(0.5, 0.0, 0.5).method_1020(forward.method_1021(0.6)));
        }
        class_243 cross = forward.method_1036(new class_243(0.0, 1.0, 0.0));
        matrices.method_22903();
        class_4588 lineConsumer = bufferSource.getBuffer((class_1921)CUSTOM_LINES);
        class_243 camPos = class_310.method_1551().field_1719.method_19538();
        double camDist = camPos.method_1020(startPos).method_1033();
        float widthMultiplier = 1.0f;
        if (camDist > 20.0) {
            widthMultiplier = (float)(camDist / 20.0);
        }
        RenderSystem.lineWidth((float)((float)(Math.sin((double)((float)laserEntity.method_10997().method_8510() + partialTick) * 0.3) * 2.0 + 7.0) / widthMultiplier));
        lineConsumer.method_22918(matrices.method_23760().method_23761(), (float)startOffset.field_1352, (float)startOffset.field_1351, (float)startOffset.field_1350).method_1336(138, 242, 223, 255).method_60803(packedLight).method_22922(packedOverlay).method_22914(0.0f, 1.0f, 0.0f);
        lineConsumer.method_22918(matrices.method_23760().method_23761(), (float)targetPosOffset.field_1352, (float)targetPosOffset.field_1351, (float)targetPosOffset.field_1350).method_1336(19, 91, 80, 255).method_60803(packedLight).method_22922(packedOverlay).method_22914(1.0f, 0.0f, 0.0f);
        lineConsumer.method_22918(matrices.method_23760().method_23761(), (float)startOffset.field_1352, (float)startOffset.field_1351, (float)startOffset.field_1350).method_1336(138, 242, 223, 255).method_60803(packedLight).method_22922(packedOverlay).method_22914((float)cross.field_1352, (float)cross.field_1351, (float)cross.field_1350);
        lineConsumer.method_22918(matrices.method_23760().method_23761(), (float)targetPosOffset.field_1352, (float)targetPosOffset.field_1351, (float)targetPosOffset.field_1350).method_1336(19, 91, 80, 255).method_60803(packedLight).method_22922(packedOverlay).method_22914((float)cross.field_1352, (float)cross.field_1351, (float)cross.field_1350);
        matrices.method_22909();
    }

    public static class_243 idToOffset(class_2338 source, float range, class_1937 world, class_2338 targetPos) {
        class_2350 drillFacing = (class_2350)world.method_8320(targetPos).method_11654((class_2769)class_2741.field_12481);
        class_243 drillCenter = Geometry.rotatePosition(new class_243(1.0, 1.4, 0.0), drillFacing);
        class_5819 random = class_5819.method_43049((long)source.method_10063());
        return new class_243((double)((random.method_43057() * 2.0f - 1.0f) * range), (double)((random.method_43057() * 2.0f - 1.0f) * range), (double)((random.method_43057() * 2.0f - 1.0f) * range)).method_1019(drillCenter);
    }

    protected void rotateBlock(class_2350 facing, class_4587 poseStack) {
        if (Objects.requireNonNull(facing) == class_2350.field_11033) {
            poseStack.method_46416(0.0f, 1.0f, 0.0f);
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        } else if (facing == class_2350.field_11039) {
            poseStack.method_22904(0.5, 0.5, 0.0);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
        } else if (facing == class_2350.field_11034) {
            poseStack.method_22904(-0.5, 0.5, 0.0);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(270.0f));
        } else if (facing == class_2350.field_11035) {
            poseStack.method_22904(0.0, 0.5, -0.5);
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        } else if (facing == class_2350.field_11043) {
            poseStack.method_22904(0.0, 0.5, 0.5);
            poseStack.method_22907(class_7833.field_40713.rotationDegrees(90.0f));
        }
    }

    public static class_243 lerp(class_243 a, class_243 b, float f) {
        return new class_243(LaserArmRenderer.lerp(a.field_1352, b.field_1352, (double)f), LaserArmRenderer.lerp(a.field_1351, b.field_1351, (double)f), LaserArmRenderer.lerp(a.field_1350, b.field_1350, (double)f));
    }

    public static double lerp(double a, double b, double f) {
        return a + f * (b - a);
    }

    private static class_243 worldToOffsetPosition(class_2350 facing, class_243 worldTarget, class_243 ownPos) {
        class_243 relativeWorld = worldTarget.method_1020(ownPos);
        double relX = relativeWorld.method_10216();
        double relY = relativeWorld.method_10214();
        double relZ = relativeWorld.method_10215();
        if (Objects.requireNonNull(facing) == class_2350.field_11043) {
            return new class_243(relX, -relZ, relY);
        }
        if (facing == class_2350.field_11035) {
            return new class_243(relX, relZ, -relY);
        }
        if (facing == class_2350.field_11039) {
            return new class_243(relY, -relX, relZ);
        }
        if (facing == class_2350.field_11034) {
            return new class_243(-relY, relX, relZ);
        }
        if (facing == class_2350.field_11036) {
            return new class_243(relX, relY, relZ);
        }
        if (facing == class_2350.field_11033) {
            return new class_243(relX, -relY, -relZ);
        }
        throw new IllegalArgumentException();
    }
}

