package rearth.oritech.util;

import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2738;

import static net.minecraft.class_2350.*;


public class Geometry {
    
    public static final float DEG_TO_RAD = 0.017453292519943295769236907684886f;
    
    public static class_2382 offsetToWorldPosition(class_2350 facing, class_2382 offset, class_2382 ownPos) {
        var rotated = rotatePosition(offset, facing);
        return ownPos.method_35853(rotated);
    }
    
    public static class_243 worldToOffsetPosition(class_2350 facing, class_243 worldTarget, class_243 ownPos) {
        class_243 relativeWorld = worldTarget.method_1020(ownPos);
        
        double relX = relativeWorld.method_10216();
        double relY = relativeWorld.method_10214();
        double relZ = relativeWorld.method_10215();
        
        if (Objects.requireNonNull(facing) == field_11043) {
            return new class_243(-relX, relY, -relZ);
        } else if (facing == field_11035) {
            return new class_243(relX, relY, relZ);
        } else if (facing == field_11039) {
            return new class_243(relZ, relY, -relX);
        } else if (facing == field_11034) {
            return new class_243(-relZ, relY, relX);
        } else if (facing == field_11036) {
            return new class_243(relX, -relZ, relY);
        } else if (facing == field_11033) {
            return new class_243(relX, relZ, -relY);
        }
        throw new IllegalArgumentException();
        
    }
    
    public static class_2382 rotatePosition(class_2382 relativePos, class_2350 facing) {
        return switch (facing) {
            case field_11043 -> new class_2338(relativePos.method_10260(), relativePos.method_10264(), relativePos.method_10263());
            case field_11039 -> new class_2338(relativePos.method_10263(), relativePos.method_10264(), -relativePos.method_10260());
            case field_11035 -> new class_2338(-relativePos.method_10260(), relativePos.method_10264(), -relativePos.method_10263());
            case field_11034 -> new class_2338(-relativePos.method_10263(), relativePos.method_10264(), relativePos.method_10260());
            case field_11036 -> new class_2338(-relativePos.method_10260(), -relativePos.method_10263(), -relativePos.method_10264());
            case field_11033 -> new class_2338(relativePos.method_10260(), relativePos.method_10263(), relativePos.method_10264());
        };
    }
    public static class_243 rotatePosition(class_243 relativePos, class_2350 facing) {
        return switch (facing) {
            case field_11043 -> new class_243(relativePos.method_10215(), relativePos.method_10214(), relativePos.method_10216());
            case field_11039 -> new class_243(relativePos.method_10216(), relativePos.method_10214(), -relativePos.method_10215());
            case field_11035 -> new class_243(-relativePos.method_10215(), relativePos.method_10214(), -relativePos.method_10216());
            case field_11034 -> new class_243(-relativePos.method_10216(), relativePos.method_10214(), relativePos.method_10215());
            case field_11036 -> new class_243(-relativePos.method_10215(), -relativePos.method_10216(), -relativePos.method_10214());
            case field_11033 -> new class_243(relativePos.method_10215(), relativePos.method_10216(), relativePos.method_10214());
        };
    }
    
    public static class_2382 getForward(class_2350 facing) {
        return rotatePosition(BlockDirection.FORWARD.pos, facing);
    }
    
    public static class_2382 getBackward(class_2350 facing) {
        return rotatePosition(BlockDirection.BACKWARD.pos, facing);
    }
    
    public static class_2382 getRight(class_2350 facing) {
        return rotatePosition(BlockDirection.RIGHT.pos, facing);
    }
    
    public static class_2382 getUp(class_2350 facing) {
        return rotatePosition(new class_2382(0, 1, 0), facing);
    }
    
    public static class_2382 getLeft(class_2350 facing) {
        return rotatePosition(BlockDirection.LEFT.pos, facing);
    }
    
    public static class_2350 fromVector(class_2382 vector) {
        
        var x = vector.method_10263();
        var y = vector.method_10264();
        var z = vector.method_10260();
        
        if (x == 0) {
            if (y == 0) {
                if (z > 0) {
                    return field_11035;
                }
                
                if (z < 0) {
                    return field_11043;
                }
            } else if (z == 0) {
                if (y > 0) {
                    return field_11036;
                }
                
                return field_11033;
            }
        } else if (y == 0 && z == 0) {
            if (x > 0) {
                return field_11034;
            }
            
            return field_11039;
        }
        
        return null;
    }
    
    public enum BlockDirection {
        FORWARD(new class_2338(-1, 0, 0)),
        BACKWARD(new class_2338(1, 0, 0)),
        LEFT(new class_2338(0, 0, 1)),
        RIGHT(new class_2338(0, 0, -1));
        
        public final class_2338 pos;
        
        BlockDirection(class_2338 blockPos) {
            pos = blockPos;
        }
    }

    public static class_265 rotateVoxelShape(class_265 shape, class_2350 facing, class_2738 face) {

        var minX = shape.method_1091(class_2351.field_11048);
        var maxX = shape.method_1105(class_2351.field_11048);
        var minY = shape.method_1091(class_2351.field_11052);
        var maxY = shape.method_1105(class_2351.field_11052);
        var minZ = shape.method_1091(class_2351.field_11051);
        var maxZ = shape.method_1105(class_2351.field_11051);

        if (facing == field_11043) {
            if (face == class_2738.field_12475) return shape;
            if (face == class_2738.field_12471) 
                return class_259.method_1081(1 - maxX, 1 - maxZ, 1 - maxY, 1 - minX, 1 - minZ, 1 - minY);
            if (face == class_2738.field_12473)
                return class_259.method_1081(minX, 1 - maxY, 1 - maxZ, maxX, 1 - minY, 1 - minZ);
        }

        if (facing == field_11035) {
            if (face == class_2738.field_12475)
                return class_259.method_1081(1 - maxX, minY, 1 - maxZ, 1 - minX, maxY, 1 - minZ);
            if (face == class_2738.field_12471)
                return class_259.method_1081(minX, 1 - maxZ, minY, maxX, 1 - minZ, maxY);
            if (face == class_2738.field_12473)
                return class_259.method_1081(1 - maxX, 1 - maxY, minZ, 1 - minX, 1 - minY, maxZ);

        }

        if (facing == class_2350.field_11034) {
            if (face == class_2738.field_12475)
                return class_259.method_1081(1 - maxZ, minY, minX, 1 - minZ, maxY, maxX);
            if (face == class_2738.field_12471)
                return class_259.method_1081(minY, 1 - maxZ, 1 - maxX, maxY, 1 - minZ, 1 - minX);
            if (face == class_2738.field_12473)
                return class_259.method_1081(minZ, 1 - maxY, minX, maxZ, 1 - minY, maxX);
        }

        if (facing == class_2350.field_11039) {
            if (face == class_2738.field_12475)
                return class_259.method_1081(minZ, minY, 1 - maxX, maxZ, maxY, 1 - minX);
            if (face == class_2738.field_12471)
                return class_259.method_1081(1 - maxY, 1 - maxZ, minX, 1 - minY, 1 - minZ, maxX);
            if (face == class_2738.field_12473)
                return class_259.method_1081(1 - maxZ, 1 - maxY, 1 - maxX, 1 - minZ, 1 - minY, 1 - minX);
        }

        if (facing == class_2350.field_11036) {
            return class_259.method_1081(minX, 1 - maxZ, minY, maxX, 1 - minZ, maxY);
        }

        if (facing == class_2350.field_11033) {
            return class_259.method_1081(minX, minZ, minY, maxX, maxZ, maxY);
        }
                
        return shape;
    }
}
