package rearth.oritech.util;

import rearth.oritech.Oritech;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.keyframe.event.SoundKeyframeEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

// basically of fabric version of this: https://github.com/bernie-g/geckolib/blob/main/common/src/main/java/software/bernie/geckolib/animation/keyframe/event/builtin/AutoPlayingSoundKeyframeHandler.java
public class AutoPlayingSoundKeyframeHandler<A extends GeoAnimatable> implements AnimationController.SoundKeyframeHandler<A> {
    
    private final Supplier<Float> speedSupplier;
    private final Map<class_2960, Long> lastPlayedAt = new HashMap<>();
    
    public AutoPlayingSoundKeyframeHandler(Supplier<Float> speedSupplier) {
        this.speedSupplier = speedSupplier;
    }
    
    public AutoPlayingSoundKeyframeHandler() {
        this.speedSupplier = AutoPlayingSoundKeyframeHandler::getDefaultSpeed;
    }
    
    private static float getDefaultSpeed() {
        return 1f;
    }
    
    @Override
    public void handle(SoundKeyframeEvent<A> event) {
        var segments = event.getKeyframeData().getSound().split("\\|");
        var sound = class_7923.field_41172.method_10223(class_2960.method_60654(segments[0]));
        
        if (sound != null) {
            
            var time = class_310.method_1551().field_1724.field_17892.method_8510();
            var age = time - lastPlayedAt.getOrDefault(sound.method_14833(), 0L);
            if (age < 30) return;  // don't play sounds if we just played it
            
            var pos = class_310.method_1551().field_1724.method_33571();
            if (event.getAnimatable() instanceof class_2586 blockEntity) {
                pos = blockEntity.method_11016().method_46558();
            }
            
            var distance = Math.sqrt(class_310.method_1551().field_1773.method_19418().method_19326().method_1025(pos));
            var volumeFalloff = Math.min(1f, 1f / (distance / 4f));
            if (distance > 25) return;
            var speed = speedSupplier.get();
            speed = Math.min(Math.max(speed, 0.125f), 8f);
            
            var random = class_310.method_1551().field_1687.field_9229;
            
            var volume = segments.length > 1 ? Float.parseFloat(segments[1]) : 1f;
            volume *= (float) (Oritech.CONFIG.machineVolumeMultiplier() * getPitchRandomMultiplier(random) * volumeFalloff * 0.5f);
            var pitch = segments.length > 2 ? Float.parseFloat(segments[2]) : 1f;
            pitch *= speed * getPitchRandomMultiplier(random);
            var source = class_3419.field_15245;
            
            class_310.method_1551().field_1724.field_17892.method_45446(class_2338.method_49638(pos), sound, source, volume, pitch, true);
            
            lastPlayedAt.put(sound.method_14833(), time);
        }
    }
    
    private float getPitchRandomMultiplier(class_5819 random) {
        return random.method_43057() * 0.15f + 1;
    }
    
}
