package rearth.oritech.item.other;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleItemFluidStorage;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_3612;

public class SmallFluidTankBlockItem extends class_1747 implements FluidApi.ItemProvider {
    
    public SmallFluidTankBlockItem(class_2248 block, class_1793 settings) {
        super(block, settings);
    }
    
    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        var data = stack.method_57825(FluidApi.ITEM.getFluidComponent(), FluidStack.empty());
        
        if (data.isEmpty()) {
            tooltip.add(class_2561.method_43471("tooltip.oritech.fluid_empty"));
        } else {
            var amount = data.getAmount() / (float) FluidStackHooks.bucketAmount();
            tooltip.add(class_2561.method_43469("tooltip.oritech.fluid_content_tank_tooltip", amount, FluidStackHooks.getName(data).getString()).method_27692(class_124.field_1080));
        }
        
        super.method_7851(stack, context, tooltip, type);
        
    }
    
    @Override
    public class_2561 method_7864(class_1799 stack) {
        var content = stack.method_57825(FluidApi.ITEM.getFluidComponent(), FluidStack.empty());
        if (content.isEmpty()) {
            return super.method_7864(stack);
        } else {
            return FluidStackHooks.getName(content).method_27661().method_10852(class_2561.method_43470(" ")).method_10852(super.method_7864(stack));
        }
    }
    
    @Override
    public FluidApi.SingleSlotStorage getFluidStorage(class_1799 stack) {
        return new SimpleItemFluidStorage(Oritech.CONFIG.portableTankCapacityBuckets() * FluidStackHooks.bucketAmount(), stack);
    }
    
    @Override
    public boolean method_31567(class_1799 stack) {
        var contentEmpty = stack.method_57825(FluidApi.ITEM.getFluidComponent(), FluidStack.empty()).isEmpty();
        return !contentEmpty;
    }
    
    @Override
    public int method_31571(class_1799 stack) {
        var content = stack.method_57825(FluidApi.ITEM.getFluidComponent(), FluidStack.empty());
        if (content.isEmpty())
            return 0x07bdff;
        
        if (content.getFluid().equals(class_3612.field_15908))
            return 0xff8000;
        
        return FluidStackHooks.getColor(content);
    }
    
    @Override
    public int method_31569(class_1799 stack) {
        
        var capacity = Oritech.CONFIG.portableTankCapacityBuckets() * FluidStackHooks.bucketAmount();
        var fillAmount = stack.method_57825(FluidApi.ITEM.getFluidComponent(), FluidStack.empty()).getAmount();
        
        return Math.round((fillAmount * 100f / capacity) * field_30889) / 100;
    }
}
