package rearth.oritech.init.compat.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import io.wispforest.owo.ui.container.FlowLayout;
import net.minecraft.class_332;
import rearth.oritech.client.ui.ItemFilterScreen;

import static rearth.oritech.client.ui.ItemFilterScreen.FILTER_SIZE;

public class EmiItemFilterDragDropHandler implements EmiDragDropHandler<ItemFilterScreen> {
    @Override
    public void render(ItemFilterScreen screen, EmiIngredient dragged, class_332 draw, int mouseX, int mouseY, float delta) {
        for (int i = 0; i < FILTER_SIZE; i++) {
            var container = screen.getItemContainer(i);
            draw.method_25294(container.x(), container.y(), container.x() + container.width(), container.y() + container.height(), 0x8822BB33);
        }
    }

    @Override
    public boolean dropStack(ItemFilterScreen screen, EmiIngredient stack, int x, int y) {
        if (stack.isEmpty()) {
            return false;
        }

        for (int i = 0; i < FILTER_SIZE; i++) {
            var container = screen.getItemContainer(i);
            if (container.isInBoundingBox(x, y)) {
                return screen.acceptItemStack(stack.getEmiStacks().getFirst().getItemStack().method_46651(1), i);
            }
        }
        return false;
    }
}
