package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Positioning;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.blocks.addons.CombiAddonBlock;
import rearth.oritech.block.entity.interaction.ShrinkerBlockEntity;

public class ShrinkerScreen extends UpgradableMachineScreen<UpgradableMachineScreenHandler> {
    
    public ShrinkerScreen(UpgradableMachineScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }
    
    public LabelComponent statusLabel;
    
    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        
        var shrinkButton = Components.button(class_2561.method_43471("text.oritech.shrink"), event -> {
            onShrinkPressed();
        });
        shrinkButton.renderer(ORITECH_BUTTON_DARK);
        shrinkButton.textShadow(false);
        
        if (this.field_2797.addonController.getConnectedAddons().isEmpty()) {
            shrinkButton.active(false);
        }
        
        statusLabel = Components.label(class_2561.method_43471("text.oritech.shrink_ready"));
        
        if (this.field_2797.addonController instanceof ShrinkerBlockEntity shrinkerBlockEntity && shrinkerBlockEntity.currentCandidate != null) {
            var previewText = CombiAddonBlock.getShrinkTooltip(shrinkerBlockEntity.currentCandidate);
            previewText.add(0, class_2561.method_43471("tooltip.oritech.shrinker_action"));
            shrinkButton.tooltip(previewText);
        }
        
        overlay.child(shrinkButton.positioning(Positioning.absolute(74, 38)));
        overlay.child(statusLabel.positioning(Positioning.absolute(40, 22)));
        
    }
    
    @Override
    protected void method_37432() {
        super.method_37432();
        
        if (this.field_2797.addonController.getConnectedAddons().isEmpty()) {
            statusLabel.text(class_2561.method_43471("text.oritech.shrink_no_addon").method_27692(class_124.field_1061));
        } else if (this.field_2797.addonController instanceof ShrinkerBlockEntity shrinker && shrinker.getEnergyStorage(null).getAmount() < shrinker.getDefaultCapacity()) {
            statusLabel.text(class_2561.method_43471("text.oritech.shrink_no_energy").method_27692(class_124.field_1061));
        } else {
            statusLabel.text(class_2561.method_43471("text.oritech.shrink_ready"));
        }
        
    }
    
    private void onShrinkPressed() {
        NetworkManager.sendToServer(new ShrinkerBlockEntity.ShrinkerPlayerUsePacket(this.field_2797.getBlockPos()));
    }
}
