package rearth.oritech.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import rearth.oritech.Oritech;
import rearth.oritech.OritechClient;
import rearth.oritech.init.ToolsContent;
import rearth.oritech.item.tools.PortableLaserItem;
import rearth.oritech.item.tools.harvesting.PromethiumPickaxeItem;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;

public class PortableLaserRenderer extends GeoItemRenderer<PortableLaserItem> {
    
    public PortableLaserRenderer(String modelName) {
        super(new PortableLaserModel(Oritech.id("models/" + modelName)));
        addRenderLayer(new AutoGlowingGeoLayer<>(this));
    }
    
    @Override
    public void postRender(class_4587 matrices, PortableLaserItem animatable, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.postRender(matrices, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        
        
        var client = class_310.method_1551();
        var player = client.field_1724;
        
        if (player == null) return;
        
        var heldStack = client.field_1724.method_6047();
        var world = client.field_1687;
        
        if (isReRender || !this.renderPerspective.method_29998()) return;
        
        var singleShotAge = world.method_8510() - PortableLaserItem.lastSingleShot;
        
        if (!OritechClient.laserActive && singleShotAge > 10) return;
        
        if (!heldStack.method_7909().equals(ToolsContent.PORTABLE_LASER)) return;
        if (animatable.getStoredEnergy(heldStack) < Oritech.CONFIG.portableLaserConfig.energyPerTick()) return;
        
        // at this point we know a laser is held and fired
        
        var startPos = player.method_33571();
        var lookVec = player.method_5828(0F);
        var endPos = startPos.method_1019(lookVec.method_1021(128));
        
        var hit = PortableLaserItem.getPlayerTargetRay(player);
        if (hit != null && hit.method_17783().equals(class_239.class_240.field_1333))
            endPos = hit.method_17784();
        
        var dist = (float) endPos.method_1022(startPos);
        
        matrices.method_22903();
        
        var lineConsumer = bufferSource.getBuffer(LaserArmRenderer.CUSTOM_LINES);
        RenderSystem.lineWidth((float) (3 + Math.sin((world.method_8510() + partialTick) * 1.1f) * 1));
        
        var startOffset = new Vector3f(0, 0.05f, 0);
        var endOffset = new Vector3f(0, 0, -dist);
        var cross = endPos.method_1020(startPos).method_1029().method_1036(new class_243(0, 1, 0));
        
        
        lineConsumer.method_22918(matrices.method_23760().method_23761(), startOffset.x, startOffset.y, startOffset.z)
          .method_1336(138, 242, 223, 255)
          .method_60803(packedLight)
          .method_22922(packedOverlay)
          .method_22914(0, 1, 0);
        lineConsumer.method_22918(matrices.method_23760().method_23761(), endOffset.x, endOffset.y, endOffset.z)
          .method_1336(19, 91, 80, 255)
          .method_60803(packedLight)
          .method_22922(packedOverlay)
          .method_22914(1, 0, 0);
        
        // render a second one at right angle to first one
        lineConsumer.method_22918(matrices.method_23760().method_23761(), startOffset.x, startOffset.y, startOffset.z)
          .method_1336(138, 242, 223, 255)
          .method_60803(packedLight)
          .method_22922(packedOverlay)
          .method_22914((float) cross.field_1352, (float) cross.field_1351, (float) cross.field_1350);
        lineConsumer.method_22918(matrices.method_23760().method_23761(), endOffset.x, endOffset.y, endOffset.z)
          .method_1336(19, 91, 80, 255)
          .method_60803(packedLight)
          .method_22922(packedOverlay)
          .method_22914((float) cross.field_1352, (float) cross.field_1351, (float) cross.field_1350);
        
        matrices.method_22909();
        
    }
}
