package rearth.oritech.client.renderers;

import org.joml.Vector2f;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.util.Geometry;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;
import java.util.HashMap;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2741;
import net.minecraft.class_310;

public class LaserArmModel<T extends LaserArmBlockEntity & GeoAnimatable> extends MachineModel<T> {
    
    private static final HashMap<Long, ModelRenderData> additionalData = new HashMap<>();
    private static final HashMap<Long, class_243> drillOffsets = new HashMap<>();
    
    private class_243 lastActivePlayerPos = class_243.field_1353;
    
    public LaserArmModel(String subpath) {
        super(subpath);
    }
    
    private ModelRenderData getById(long id) {
        return additionalData.computeIfAbsent(id, s -> new ModelRenderData(0, 0, getAnimationProcessor().getBone("pivotX"), getAnimationProcessor().getBone("pivotY")));
    }
    
    private class_243 getOffsetByDrillId(long id, T laserEntity) {
        return drillOffsets.computeIfAbsent(id, s -> {
            var drillFacing = laserEntity.method_10997().method_8320(laserEntity.getCurrentTarget()).method_11654(class_2741.field_12481);
            return Geometry.rotatePosition(new class_243(1, 1.4, 0), drillFacing);
        });
    }
    
    @Override
    public void setCustomAnimations(T laserEntity, long instanceId, AnimationState<T> animationState) {
        
        class_243 target;
        var isIdle = false;
        if (laserEntity.getCurrentTarget() == null || laserEntity.getCurrentTarget().method_19771(class_2338.field_10980, 0.1f))  {
            target = getIdleTarget(laserEntity);
            isIdle = true;
        } else {
            target = laserEntity.getVisualTarget();
        }
        
        if (target == null || target == class_243.field_1353) return;
        
        if (!isIdle && laserEntity.isTargetingDeepdrill(laserEntity.method_10997().method_8320(laserEntity.getCurrentTarget()).method_26204())) {
            var drillId = laserEntity.getCurrentTarget().method_10063();
            var offset = getOffsetByDrillId(drillId, laserEntity);
            target = target.method_1019(offset);
        }
        
        var ownPos = laserEntity.laserHead;
        var facing = laserEntity.method_11010().method_11654(class_2741.field_12525);
        var offset = Geometry.worldToOffsetPosition(facing, target, ownPos);
        
        // thanks to: https://math.stackexchange.com/questions/878785/how-to-find-an-angle-in-range0-360-between-2-vectors
        var offsetY = new Vector2f((float) offset.method_10216(), (float) offset.method_10214());
        var forwardY = new Vector2f(0, -1);
        if (facing == class_2350.field_11043)
            forwardY = new Vector2f(0, 1);
        if (facing == class_2350.field_11039)
            forwardY = new Vector2f(1, 0);
        if (facing == class_2350.field_11034)
            forwardY = new Vector2f(-1, 0);
        var angleY = -offsetY.angle(forwardY);
        
        // to create a 2d vector in a plane based on normal angleY
        var lengthY = offsetY.length();
        var heightDiff = offset.method_10215();
        
        var offsetX = new Vector2f(lengthY, (float) heightDiff);
        var forwardX = new Vector2f(0, 1);
        var detX = determinant(offsetX, forwardX);
        var dotX = offsetX.dot(forwardX);
        var angleX = Math.atan2(detX, dotX);
        
        angleX -= 47.5 * Geometry.DEG_TO_RAD; //to offset for parent bone rotations
        
        var data = getById(instanceId);
        
        if (data.boneX != null) {
            var newRotY = lerp(data.angleY, angleY, 0.06f);
            var newRotX = lerp(data.angleX, (float) angleX, 0.06f);
            data.boneY.setRotY(newRotY);
            data.boneX.setRotX(newRotX);
            
            data.angleY = newRotY;
            data.angleX = newRotX;
        }
        
    }
    
    private class_243 getIdleTarget(T entity) {
        
        var offsetA = new class_243(0, Math.pow(Math.sin(entity.method_10997().method_8510() / 40f), 3), 0);
        var offsetB = new class_243(Math.pow(Math.sin(entity.method_10997().method_8510() / 40f + 1.3f), 3), 0, 0);
        
        if (entity.method_10997().method_8409().method_43057() > 0.9f) {
             lastActivePlayerPos = class_310.method_1551().field_1724.method_33571();
        }
        
        if (lastActivePlayerPos.equals(class_243.field_1353))
            return class_243.field_1353;
        
        // return lastActivePlayerPos;
        
        return lastActivePlayerPos.method_1019(offsetA).method_1019(offsetB);
    }
    
    public static float lerp(float a, float b, float f) {
        if (Math.abs(b-a) > 350 * Geometry.DEG_TO_RAD) return b;
        return a + f * (b - a);
    }
    
    public static float determinant(Vector2f a, Vector2f b) {
        return a.x * b.y - a.y * b.x;
    }
    
    private static class ModelRenderData {
        protected float angleY;
        protected float angleX;
        protected GeoBone boneX;
        protected GeoBone boneY;
        
        public ModelRenderData(float angleX, float angleY, GeoBone boneX, GeoBone boneY) {
            this.angleY = angleY;
            this.angleX = angleX;
            this.boneX = boneX;
            this.boneY = boneY;
        }
    }
}
