package rearth.oritech.client.init;

import io.wispforest.owo.particles.ClientParticles;
import io.wispforest.owo.particles.systems.ParticleSystem;
import io.wispforest.owo.particles.systems.ParticleSystemController;
import io.wispforest.owo.util.VectorRandomUtils;
import rearth.oritech.Oritech;

import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;

public class ParticleContent {
    
    public static final ParticleSystemController PARTICLE_CONTROLLER = new ParticleSystemController(Oritech.id("particles"));
    
    public static final ParticleSystem<Void> HIGHLIGHT_BLOCK = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> {
        spawnCubeOutline(class_2398.field_29644, pos, 1, 120, 6);
        ClientParticles.reset();
    });
    
    public static final ParticleSystem<LineData> WEED_KILLER = PARTICLE_CONTROLLER.register(LineData.class, (world, pos, data) -> {
        var dist = (int) data.end.method_1022(data.start);
        ClientParticles.setParticleCount(dist * 4 + world.field_9229.method_43048(3));
        ClientParticles.spawnLine(class_2398.field_11216, world, data.start, data.end, 0.2f);
    });
    
    public static final ParticleSystem<Void> DEBUG_BLOCK = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> {
        spawnCubeOutline(class_2398.field_29644, pos, 1, 120, 2);
        ClientParticles.reset();
    });
    
    public static final ParticleSystem<SoulParticleData> WANDERING_SOUL = PARTICLE_CONTROLLER.register(SoulParticleData.class, (world, pos, data) -> {
        ClientParticles.setVelocity(data.offset.method_1021((1f / data.duration) * 1.5f));
        ClientParticles.spawnWithMaxAge(class_2398.field_38002, pos, data.duration);
    });
    
    public static final ParticleSystem<class_243> LASER_BOOM = PARTICLE_CONTROLLER.register(class_243.class, (world, pos, data) -> {
        var count = (int) (pos.method_1022(data) * 0.6f + 1);
        count = Math.min(count, 12);
        spawnLineInnerStaggered(class_2398.field_38908, world, pos, data, count, 20);
    });
    
    public static final ParticleSystem<LineData> CATALYST_CONNECTION = PARTICLE_CONTROLLER.register(LineData.class, (world, pos, data) -> {
        ClientParticles.spawnEnchantParticles(world, data.start, data.end, 0.7f);
    });
    
    public static final ParticleSystem<class_243> BLACK_HOLE_EMISSION = PARTICLE_CONTROLLER.register(class_243.class, (world, pos, data) -> {
        var dist = (int) data.method_1022(pos);
        ClientParticles.setParticleCount(dist + world.field_9229.method_43048(3));
        ClientParticles.spawnLine(class_2398.field_38004, world, pos, data, 0.2f);
    });
    
    public static final ParticleSystem<Integer> FERTILIZER_EFFECT = PARTICLE_CONTROLLER.register(Integer.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(data);
        ClientParticles.spawnWithinBlock(class_2398.field_11211, world, new class_2338((int) pos.field_1352, (int) pos.field_1351, (int) pos.field_1350));
    }));
    
    public static final ParticleSystem<Integer> BLOCK_DESTROY_EFFECT = PARTICLE_CONTROLLER.register(Integer.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(data);
        ClientParticles.spawnCenteredOnBlock(class_2398.field_22246, world, new class_2338((int) pos.field_1352, (int) pos.field_1351, (int) pos.field_1350), 0.6);
    }));
    
    public static final ParticleSystem<Integer> QUARRY_DESTROY_EFFECT = PARTICLE_CONTROLLER.register(Integer.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(data);
        ClientParticles.spawn(class_2398.field_22246, world, pos, 0.4);
    }));
    
    public static final ParticleSystem<Integer> UNSTABLE_CONTAINER_GROWING = PARTICLE_CONTROLLER.register(Integer.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(data);
        ClientParticles.spawn(class_2398.field_47493, world, pos, 4);
    }));
    
    public static final ParticleSystem<Integer> WATERING_EFFECT = PARTICLE_CONTROLLER.register(Integer.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(data);
        ClientParticles.spawnCenteredOnBlock(class_2398.field_18306, world, new class_2338((int) pos.field_1352, (int) pos.field_1351, (int) pos.field_1350), 0.6);
    }));
    
    public static final ParticleSystem<Integer> FURNACE_BURNING = PARTICLE_CONTROLLER.register(Integer.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(data);
        ClientParticles.spawnCenteredOnBlock(class_2398.field_11239, world, new class_2338((int) pos.field_1352, (int) pos.field_1351, (int) pos.field_1350), 0.6);
    }));
    
    public static final ParticleSystem<Integer> PULVERIZER_WORKING = PARTICLE_CONTROLLER.register(Integer.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(data);
        ClientParticles.spawnCenteredOnBlock(class_2398.field_46763, world, new class_2338((int) pos.field_1352, (int) pos.field_1351, (int) pos.field_1350), 0.6);
    }));
    
    public static final ParticleSystem<Integer> SOUL_USED = PARTICLE_CONTROLLER.register(Integer.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(data);
        ClientParticles.spawn(class_2398.field_11211, world, pos, 1.2);
    }));
    
    public static final ParticleSystem<Integer> MELTDOWN_IMMINENT = PARTICLE_CONTROLLER.register(Integer.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(data);
        ClientParticles.spawn(class_2398.field_11239, world, pos, 1);
    }));
    
    public static final ParticleSystem<Integer> GRINDER_WORKING = PARTICLE_CONTROLLER.register(Integer.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(data);
        ClientParticles.spawn(class_2398.field_46763, world, pos, 0.8);
    }));
    
    public static final ParticleSystem<Integer> ASSEMBLER_WORKING = PARTICLE_CONTROLLER.register(Integer.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(data);
        ClientParticles.spawn(class_2398.field_11208, world, pos, 0.6);
    }));
    
    public static final ParticleSystem<Integer> COOLER_WORKING = PARTICLE_CONTROLLER.register(Integer.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(data);
        ClientParticles.spawn(class_2398.field_28013, world, pos, 1.2);
    }));
    
    public static final ParticleSystem<Integer> STEAM_ENGINE_WORKING = PARTICLE_CONTROLLER.register(Integer.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(data);
        ClientParticles.spawn(class_2398.field_11204, world, pos, 0.6);
    }));
    
    public static final ParticleSystem<Integer> CHARGING = PARTICLE_CONTROLLER.register(Integer.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(data);
        ClientParticles.spawnCenteredOnBlock(class_2398.field_38908, world, new class_2338((int) pos.field_1352, (int) pos.field_1351, (int) pos.field_1350), 0.6);
    }));
    
    public static final ParticleSystem<Void> BIG_HIT = PARTICLE_CONTROLLER.register(Void.class, ((world, pos, data) -> {
        ClientParticles.spawn(class_2398.field_38908, world, pos, 0.3);
    }));
    
    public static final ParticleSystem<Void> PARTICLE_COLLIDE = PARTICLE_CONTROLLER.register(Void.class, ((world, pos, data) -> {
        ClientParticles.spawn(class_2398.field_47494, world, pos, 0);
    }));
    
    public static final ParticleSystem<class_243> JETPACK_EXHAUST = PARTICLE_CONTROLLER.register(class_243.class, ((world, pos, data) -> {
        ClientParticles.setVelocity(data);
        ClientParticles.spawn(class_2398.field_11251, world, pos, 0.1);
    }));
    
    public static final ParticleSystem<Void> ACCELERATING = PARTICLE_CONTROLLER.register(Void.class, (world, pos, data) -> {
        spawnCubeOutline(class_2398.field_38004, pos, 1, 5, 3);
        ClientParticles.reset();
    });
    
    public static final ParticleSystem<Void> LASER_BEAM_EFFECT = PARTICLE_CONTROLLER.register(Void.class, ((world, pos, data) -> {
        ClientParticles.setParticleCount(1);
        ClientParticles.spawnPrecise(class_2398.field_27783, world, pos, 0.4, 0.3, 0.4);
    }));
    
    public static final ParticleSystem<Void> PARTICLE_MOVING = PARTICLE_CONTROLLER.register(Void.class, ((world, pos, data) -> {
        ClientParticles.spawnPrecise(class_2398.field_23190, world, pos, 0.2, 0.3, 0.2);
    }));
    
    private static void spawnCubeOutline(class_2394 particle, class_243 origin, float size, int duration, int segments) {
        
        spawnLineInner(particle, origin, origin.method_1031(size, 0, 0), segments, duration);
        spawnLineInner(particle, origin.method_1031(size, 0, 0), origin.method_1031(size, 0, size), segments, duration);
        
        spawnLineInner(particle, origin, origin.method_1031(0, 0, size), segments, duration);
        spawnLineInner(particle, origin.method_1031(0, 0, size), origin.method_1031(size, 0, size), segments, duration);
        
        origin = origin.method_1031(0, size, 0);
        
        spawnLineInner(particle, origin, origin.method_1031(size, 0, 0), segments, duration);
        spawnLineInner(particle, origin.method_1031(size, 0, 0), origin.method_1031(size, 0, size), segments, duration);
        spawnLineInner(particle, origin, origin.method_1031(0, 0, size), segments, duration);
        spawnLineInner(particle, origin.method_1031(0, 0, size), origin.method_1031(size, 0, size), segments, duration);
        
        spawnLineInner(particle, origin, origin.method_1031(0, -size, 0), segments, duration);
        spawnLineInner(particle, origin.method_1031(size, 0, 0), origin.method_1031(size, -size, 0), segments, duration);
        spawnLineInner(particle, origin.method_1031(0, 0, size), origin.method_1031(0, -size, size), segments, duration);
        spawnLineInner(particle, origin.method_1031(size, 0, size), origin.method_1031(size, -size, size), segments, duration);
    }
    
    private static void spawnLineInner(class_2394 particle, class_243 start, class_243 end, float particleCount, int duration) {
        class_243 increment = end.method_1020(start).method_1021(1f / particleCount);
        
        for (int i = 0; i < particleCount; i++) {
            ClientParticles.spawnWithMaxAge(particle, start, duration);
            start = start.method_1019(increment);
        }
    }
    
    private static void spawnLineInnerStaggered(class_2394 particle, class_1937 world, class_243 start, class_243 end, float particleCount, long pauseMillis) {
        var increment = end.method_1020(start).method_1021(1f / particleCount);
        
        CompletableFuture.runAsync(() -> {
            for (int i = 0; i < particleCount; i++) {
                var pos =  start.method_1019(increment.method_1021(i));
                world.method_8406(particle, pos.method_10216(), pos.method_10214(), pos.method_10215(), 0, 0, 0);
                try {
                    Thread.sleep(pauseMillis);
                } catch (InterruptedException e) {
                    break;
                }
            }
        });
    }
    
    public static void registerParticles() {
        Oritech.LOGGER.debug("Registering Oritech particles");
    }
    
    public record LineData(class_243 start, class_243 end) {}
    
    public record SoulParticleData(class_243 offset, int duration) {}
    
}
