package rearth.oritech.api.energy.containers;

import rearth.oritech.api.energy.EnergyApi;

import java.util.function.Consumer;
import net.minecraft.class_1799;

public class SimpleEnergyItemStorage extends SimpleEnergyStorage {
    
    private final class_1799 stack;
    public Consumer<class_1799> contextCallback;
    
    public SimpleEnergyItemStorage(long maxInsert, long maxExtract, long capacity, class_1799 stack) {
        super(maxInsert, maxExtract, capacity);
        this.stack = stack;
        this.setAmount(stack.method_57825(EnergyApi.ITEM.getEnergyComponent(), 0L));
    }
    
    @Override
    public void update() {
        super.update();
        stack.method_57379(EnergyApi.ITEM.getEnergyComponent(), getAmount());
        
        if (contextCallback != null) contextCallback.accept(stack);
    }
    
    public SimpleEnergyItemStorage withCallback(Consumer<class_1799> contextCallback) {
        this.contextCallback = contextCallback;
        return this;
    }
}
