package rearth.oritech.item.tools;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.Protection;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_756;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import net.minecraft.class_8710;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.world.phys.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.renderers.PortableLaserRenderer;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.item.tools.util.OritechEnergyItem;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.TooltipHelper;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

import static rearth.oritech.block.entity.interaction.LaserArmBlockEntity.BLOCK_BREAK_ENERGY;
import static rearth.oritech.item.tools.harvesting.DrillItem.BAR_STEP_COUNT;


public class PortableLaserItem extends class_1792 implements OritechEnergyItem, GeoItem {
    
    public static final int ACTION_COOLDOWN = 24;
    
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation SHOOTING = RawAnimation.begin().thenPlay("shooting");
    private static final RawAnimation SINGLE_SHOT = RawAnimation.begin().thenPlay("singleshot");
    
    // client only
    public static long lastSingleShot = 0;
    
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache(this);
    
    private static final Map<class_1657, class_3545<class_2338, Integer>> blockBreakStats = new HashMap<>();
    
    public PortableLaserItem(class_1793 settings) {
        super(settings);
        SingletonGeoAnimatable.registerSyncedAnimatable(this);
    }
    
    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        
        var stack = player.method_5998(hand);
        var energyUsed = Oritech.CONFIG.portableLaserConfig.energyPerBoom();
        
        if (world.field_9236) {
            if (getStoredEnergy(stack) > energyUsed && !player.method_5715() && !isMiningEnabled(stack))
                lastSingleShot = world.method_8510();
            
            return class_1271.method_22428(stack);
        }
        
        if (!(stack.method_7909() instanceof PortableLaserItem laserItem)) return class_1271.method_22428(stack);
        
        if (player.method_5715()) {
            
            var lastMode = isMiningEnabled(stack);
            setMiningEnabled(stack, !lastMode);
            
            player.method_43496(class_2561.method_43471("tooltip.oritech.portable_laser.status.begin").method_10852(class_2561.method_43470(String.valueOf(!lastMode))));
            
            return class_1271.method_22428(stack);
        }
        
        if (isMiningEnabled(stack)) {
            player.method_43496(class_2561.method_43471("tooltip.oritech.portable_laser.status.shot_mining_error"));
            return class_1271.method_22430(stack);
        }
        
        if (!laserItem.tryUseEnergy(stack, energyUsed, player)) {
            return class_1271.method_22430(stack);
        }
        
        if (player.method_7357().method_7904(this)) return class_1271.method_22431(stack);
        player.method_7357().method_7906(this, ACTION_COOLDOWN);
        
        class_243 endPos;
        
        var hit = getPlayerTargetRay(player);
        
        if (hit != null) {
            var canInteract = true;
            if (Platform.isModLoaded("ftbchunks")) {
                canInteract = !FTBChunksAPI.api().getManager().shouldPreventInteraction(player, hand, class_2338.method_49638(hit.method_17784()), Protection.EDIT_AND_INTERACT_BLOCK, null);
            }
            
            if (canInteract)
                world.method_46407(null, new class_1282(world.method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42336), player),
                  null, hit.method_17784(), Oritech.CONFIG.portableLaserConfig.explosionStrength(), false, class_1937.class_7867.field_40890);
            
            endPos = hit.method_17784();
        } else {
            var startPos = player.method_33571();
            var lookVec = player.method_5828(0F);
            endPos = startPos.method_1019(lookVec.method_1021(128));
        }
        
        if (hit instanceof class_3966 entityHitResult && entityHitResult.method_17782() instanceof class_1309 livingEntity) {
            var canInteract = true;
            if (Platform.isModLoaded("ftbchunks")) {
                canInteract = !FTBChunksAPI.api().getManager().shouldPreventInteraction(player, hand, class_2338.method_49638(hit.method_17784()), Protection.INTERACT_ENTITY, livingEntity);
            }
            
            if (canInteract)
                processEntityTarget(player, livingEntity, 20, stack, world);
        }
        
        triggerAnim(player, GeoItem.getId(stack), "laser", "singleshot");
        
        world.method_8396(null, player.method_24515(), class_3417.field_38830, class_3419.field_15248, 0.8f, 1f);
        
        // Calculate the "right" direction based on the player's yaw
        float yawRadians = (player.method_36454() + 90) * (float) Math.PI / 180;
        double rightX = -class_3532.method_15374(yawRadians);
        double rightZ = class_3532.method_15362(yawRadians);
        class_243 rightDir = new class_243(rightX, 0, rightZ).method_1029();
        
        var startPos = player.method_33571().method_1019(endPos.method_1020(player.method_33571()).method_1021(0.4f)).method_1031(0, -0.5f, 0).method_1019(rightDir.method_1021(0.3f));
        ParticleContent.LASER_BOOM.spawn(world, startPos, endPos);
        ParticleContent.MELTDOWN_IMMINENT.spawn(world, endPos, 6);
        
        return class_1271.method_22428(stack);
    }
    
    public static void onUseTick(class_1657 player) {
        var world = player.method_37908();
        var stack = player.method_5998(class_1268.field_5808);
        
        if (!(stack.method_7909() instanceof PortableLaserItem laserItem) || world == null) return;
        
        var rfUsage = Oritech.CONFIG.portableLaserConfig.energyPerTick();
        
        if (!laserItem.tryUseEnergy(stack, rfUsage, player)) {
            return;
        }
        
        var finalHit = getPlayerTargetRay(player);
        
        laserItem.triggerAnim(player, GeoItem.getId(stack), "laser", "shooting");
        
        if (finalHit instanceof class_3965 blockHitResult && laserItem.isMiningEnabled(stack)) {
            var blockPos = blockHitResult.method_17777();
            var blockState = world.method_8320(blockPos);
            if (blockState.method_26215() || blockState.method_26164(TagContent.LASER_PASSTHROUGH)) return;
            
            var canInteract = true;
            if (Platform.isModLoaded("ftbchunks")) {
                canInteract = !FTBChunksAPI.api().getManager().shouldPreventInteraction(player, class_1268.field_5808, class_2338.method_49638(finalHit.method_17784()), Protection.EDIT_AND_INTERACT_BLOCK, null);
            }
            
            if (canInteract)
                processBlockBreaking(blockPos, blockState, world, player, stack, rfUsage);
        } else if (finalHit instanceof class_3966 entityHitResult) {
            var target = entityHitResult.method_17782();
            if (!(target instanceof class_1309 livingEntity)) return;
            var canInteract = true;
            if (Platform.isModLoaded("ftbchunks")) {
                canInteract = !FTBChunksAPI.api().getManager().shouldPreventInteraction(player, class_1268.field_5808, class_2338.method_49638(finalHit.method_17784()), Protection.EDIT_AND_INTERACT_BLOCK, target);
            }
            
            if (canInteract)
                processEntityTarget(player, livingEntity, Oritech.CONFIG.portableLaserConfig.damageBase(), stack, world);
        }
        
        if (finalHit != null && finalHit.method_17783() != class_239.class_240.field_1333 && laserItem.isMiningEnabled(stack)) {
            ParticleContent.LASER_BEAM_EFFECT.spawn(world, finalHit.method_17784());
        }
        
    }
    
    public static @Nullable class_239 getPlayerTargetRay(class_1657 player) {
        
        // block raycast
        var blockHit = player.method_5745(128, 0, true);
        
        // entity raycast
        // possible idea for future optimization: do a custom raycast here with slightly inflated bounding boxes to make aiming easier
        var startPos = player.method_33571();
        var lookVec = player.method_5828(0F);
        var endPos = startPos.method_1019(lookVec.method_1021(128));
        var entityHit = class_1675.method_18075(
          player,
          startPos,
          endPos,
          new class_238(startPos, endPos),
          entity -> !entity.method_7325() && entity.method_5732() && entity.method_5805() && entity != player,
          128 * 128
        );
        
        // Determine the closest hit
        class_239 finalHit = null;
        var blockDistance = blockHit.method_17783() == class_239.class_240.field_1332 ? startPos.method_1025(blockHit.method_17784()) : Double.MAX_VALUE;
        var entityDistance = entityHit != null ? startPos.method_1025(entityHit.method_17784()) : Double.MAX_VALUE;
        
        if (blockDistance < entityDistance) {
            finalHit = blockHit;
        } else if (entityHit != null) {
            finalHit = entityHit;
        }
        return finalHit;
    }
    
    private static void processBlockBreaking(class_2338 blockPos, class_2680 blockState, class_1937 world, class_1657 player, class_1799 tool, int energyUsed) {
        
        // skip unbreakable blocks
        if (blockState.method_26214(world, blockPos) < 0) return;
        
        var stats = blockBreakStats.getOrDefault(player, new class_3545<>(class_2338.field_10980, 0));
        if (!blockPos.equals(stats.method_15442())) {
            stats = new class_3545<>(blockPos, energyUsed);
        } else {
            stats = new class_3545<>(blockPos, stats.method_15441() + energyUsed);
        }
        
        if (blockState.method_26164(TagContent.LASER_ACCELERATED)) {
            blockState.method_26199((class_3218) world, blockPos, world.field_9229);
            ParticleContent.ACCELERATING.spawn(world, class_243.method_24954(blockPos));
            stats = new class_3545<>(blockPos, -1);
        }
        
        var blockEntity = world.method_8321(blockPos);
        if (blockEntity instanceof MachineCoreEntity coreBlock && coreBlock.isEnabled()) {
            blockEntity = (class_2586) coreBlock.getCachedController();
        }
        if (blockEntity != null) {
            var storageCandidate = EnergyApi.BLOCK.find(world, blockPos, blockState, null, null);
            if (storageCandidate == null && blockEntity instanceof EnergyApi.BlockProvider provider) {
                storageCandidate = provider.getEnergyStorage(null);
            }
            
            if (storageCandidate instanceof DynamicEnergyStorage dynamicStorage) {
                var inserted = dynamicStorage.insertIgnoringLimit(energyUsed, false);
                if (inserted > 0)
                    dynamicStorage.update();
                
                return;
            } else if (storageCandidate != null) {
                var inserted = storageCandidate.insert(energyUsed, false);
                if (inserted > 0)
                    storageCandidate.update();
                
                return;
            }
        }
        
        var currentInvestedEnergy = stats.method_15441();
        var requiredBreakingEnergy = (int) (Math.sqrt(blockState.method_26214(world, blockPos)) * BLOCK_BREAK_ENERGY / Oritech.CONFIG.portableLaserConfig.blockBreakSpeed());
        var efficiencyLevel = getEnchantmentLevel(tool, class_1893.field_9131);
        if (efficiencyLevel > 0) requiredBreakingEnergy = requiredBreakingEnergy / (efficiencyLevel + 1);
        
        var currentProgress = currentInvestedEnergy / (float) requiredBreakingEnergy;
        if (world instanceof class_3218 serverLevel)
            serverLevel.method_8517(0, blockPos, (int) (currentProgress * 10));
        
        if (currentInvestedEnergy > requiredBreakingEnergy) {
            stats = new class_3545<>(blockPos, 0);
            finishBlockBreaking(blockPos, blockState, world, player, tool);
        }
        
        blockBreakStats.put(player, stats);
    }
    
    private static void finishBlockBreaking(class_2338 targetPos, class_2680 targetBlockState, class_1937 world, class_1657 player, class_1799 tool) {
        
        var targetEntity = world.method_8321(targetPos);
        List<class_1799> dropped;
        dropped = class_2248.method_9609(targetBlockState, (class_3218) world, targetPos, targetEntity, player, tool);
        
        var blockRecipe = LaserArmBlockEntity.tryGetRecipeOfBlock(targetBlockState, world);
        if (blockRecipe != null) {
            var recipe = blockRecipe.comp_1933();
            var farmedCount = 1;
            dropped = List.of(new class_1799(recipe.getResults().get(0).method_7909(), farmedCount));
            ParticleContent.CHARGING.spawn(world, class_243.method_24954(targetPos), 1);
        }
        
        // add stack to player inv, or spawn at block pos
        for (var stack : dropped) {
            if (!player.method_31548().method_7394(stack))
                world.method_8649(new class_1542(world, targetPos.method_46558().field_1352, targetPos.method_46558().field_1351, targetPos.method_46558().field_1350, stack));
        }
        
        try {
            targetBlockState.method_26204().method_9576(world, targetPos, targetBlockState, player);
        } catch (Exception exception) {
            Oritech.LOGGER.warn("Laser arm block break event failure when breaking " + targetBlockState + " at " + targetPos + ": " + exception.getLocalizedMessage());
        }
        world.method_31595(targetPos, world.method_8320(targetPos));
        world.method_8396(null, targetPos, targetBlockState.method_26231().method_10595(), class_3419.field_15245, 1f, 1f);
        world.method_22352(targetPos, false);
    }
    
    private static void processEntityTarget(class_1657 player, class_1309 target, int damage, class_1799 tool, class_1937 world) {
        
        // make creepers charged
        if (target.method_5864().equals(class_1299.field_6046) && !target.method_5841().method_12789(class_1548.field_7224)) {
            target.method_5841().method_12778(class_1548.field_7224, true);
            return;
        }
        
        var sharpnessLevel = getEnchantmentLevel(tool, class_1893.field_9118);
        damage = (int) (damage * Math.sqrt(sharpnessLevel + 1));
        
        target.method_5643(
          new class_1282(world.method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42336), player),
          damage);
        
    }
    
    // A hack to do this without context of the DRM
    public static int getEnchantmentLevel(class_1799 stack, class_5321<class_1887> enchantment) {
        var enchantments = stack.method_57825(class_9334.field_49633, class_9304.field_49385);
        for (var entry : enchantments.method_57534()) {
            if (entry.method_40230().isPresent() && entry.method_40230().get().equals(enchantment)) {
                return enchantments.method_57536(entry);
            }
        }
        return 0;
    }
    
    // this overrides the fabric specific extensions
    public boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }
    
    public boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        return true;
    }
    
    // this overrides the neoforge specific extensions
    public boolean shouldCauseReequipAnimation(@NotNull class_1799 oldStack, @NotNull class_1799 newStack, boolean slotChanged) {
        return false;
    }
    
    public boolean shouldCauseBlockBreakReset(@NotNull class_1799 oldStack, @NotNull class_1799 newStack) {
        return false;
    }
    
    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        var storedEnergy = TooltipHelper.getEnergyText(this.getStoredEnergy(stack));
        var capacity = TooltipHelper.getEnergyText(this.getEnergyCapacity(stack));
        var text = class_2561.method_43469("tooltip.oritech.energy_indicator", storedEnergy, capacity);
        tooltip.add(text.method_27692(class_124.field_1065));
        
        var miningText = class_2561.method_43471("tooltip.oritech.portable_laser.status.begin").method_27692(class_124.field_1080)
                           .method_10852(class_2561.method_43470(String.valueOf(isMiningEnabled(stack))).method_27692(class_124.field_1065))
                           .method_10852(class_2561.method_43471("tooltip.oritech.portable_laser.status.hint").method_27695(class_124.field_1080, class_124.field_1056));
        tooltip.add(miningText);
        
        var showExtra = class_437.method_25441();
        
        if (showExtra) {
            for (int i = 1; i <= 5; i++) {
                tooltip.add(class_2561.method_43471("tooltip.oritech.portable_laser." + i).method_27692(class_124.field_1080));
            }
        } else {
            tooltip.add(class_2561.method_43471("tooltip.oritech.item_extra_info").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        }
    }
    
    @Override
    public boolean method_7870(class_1799 stack) {
        return true;
    }
    
    @Override
    public int method_7837() {
        return 10;
    }
    
    public boolean isMiningEnabled(class_1799 stack) {
        return stack.method_57825(ComponentContent.IS_AOE_ACTIVE.get(), false);
    }
    
    public void setMiningEnabled(class_1799 stack, boolean status) {
        stack.method_57379(ComponentContent.IS_AOE_ACTIVE.get(), status);
    }
    
    @Override
    public int method_31569(class_1799 stack) {
        return Math.round((getStoredEnergy(stack) * 100f / this.getEnergyCapacity(stack)) * BAR_STEP_COUNT) / 100;
    }
    
    @Override
    public boolean method_31567(class_1799 stack) {
        return true;
    }
    
    @Override
    public int method_31571(class_1799 stack) {
        return 0xff7007;
    }
    
    @Override
    public long getEnergyCapacity(class_1799 stack) {
        return Oritech.CONFIG.portableLaserConfig.energyCapacity();
    }
    
    @Override
    public long getEnergyMaxInput(class_1799 stack) {
        return Oritech.CONFIG.portableLaserConfig.energyCapacity() / 80;
    }
    
    @Override
    public long getEnergyMaxOutput(class_1799 stack) {
        return Oritech.CONFIG.portableLaserConfig.energyCapacity() / 80;
    }
    
    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<>(
          this,
          "laser",
          0,
          state -> {
              if (state.getController().getAnimationState().equals(AnimationController.State.STOPPED))
                  return state.setAndContinue(IDLE);
              return PlayState.CONTINUE;
          })
                          .triggerableAnim("idle", IDLE)
                          .triggerableAnim("singleshot", SINGLE_SHOT)
                          .triggerableAnim("shooting", SHOOTING).setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler<>()));
    }
    
    @Override
    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider() {
            private PortableLaserRenderer renderer;
            
            @Override
            public @NotNull class_756 getGeoItemRenderer() {
                if (this.renderer == null)
                    this.renderer = new PortableLaserRenderer("portable_laser");
                return renderer;
            }
        });
    }
    
    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return cache;
    }
    
    public static void receiveUsePacket(LaserPlayerUsePacket packet, class_1657 player, class_5455 dynamicRegistryManager) {
        PortableLaserItem.onUseTick(player);
    }
    
    public record LaserPlayerUsePacket() implements class_8710 {
        
        public static final class_8710.class_9154<LaserPlayerUsePacket> PACKET_ID = new class_8710.class_9154<>(Oritech.id("laser_use"));
        
        @Override
        public class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}
