package rearth.oritech.init.compat.rei;

import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1935;
import rearth.oritech.block.entity.generators.BioGeneratorEntity;
import rearth.oritech.block.entity.generators.FuelGeneratorEntity;
import rearth.oritech.block.entity.generators.LavaGeneratorEntity;
import rearth.oritech.block.entity.generators.SteamEngineEntity;
import rearth.oritech.block.entity.processing.*;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.compat.rei.Screens.OritechReiDisplay;
import rearth.oritech.init.compat.rei.Screens.OritechReiLaserDisplay;
import rearth.oritech.init.compat.rei.Screens.OritechReiParticleCollisionDisplay;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;

import java.util.List;
import java.util.function.BiFunction;

public class OritechREIPlugin implements REIClientPlugin {
    
    @Override
    public void registerCategories(CategoryRegistry registry) {
        
        // recipe types
        registerOritechCategory(registry, RecipeContent.PULVERIZER, BlockContent.PULVERIZER_BLOCK, (recipeType, icon) -> new OritechReiDisplay(recipeType, PulverizerBlockEntity.class, icon));
        registerOritechCategory(registry, RecipeContent.GRINDER, BlockContent.FRAGMENT_FORGE_BLOCK, (recipeType, icon) -> new OritechReiDisplay(recipeType, FragmentForgeBlockEntity.class, icon));
        registerOritechCategory(registry, RecipeContent.ASSEMBLER, BlockContent.ASSEMBLER_BLOCK, (recipeType, icon) -> new OritechReiDisplay(recipeType, AssemblerBlockEntity.class, icon));
        registerOritechCategory(registry, RecipeContent.FOUNDRY, BlockContent.FOUNDRY_BLOCK, (recipeType, icon) -> new OritechReiDisplay(recipeType, FoundryBlockEntity.class, icon));
        registerOritechCategory(registry, RecipeContent.REFINERY, BlockContent.REFINERY_BLOCK, (recipeType, icon) -> new OritechReiDisplay(recipeType, RefineryBlockEntity.class, icon));
        registerOritechCategory(registry, RecipeContent.COOLER, BlockContent.COOLER_BLOCK, (recipeType, icon) -> new OritechReiDisplay(recipeType, CoolerBlockEntity.class, icon));
        registerOritechCategory(registry, RecipeContent.CENTRIFUGE, BlockContent.CENTRIFUGE_BLOCK, (recipeType, icon) -> new OritechReiDisplay(recipeType, CentrifugeBlockEntity.class, icon));
        registerOritechCategory(registry, RecipeContent.CENTRIFUGE_FLUID, BlockContent.CENTRIFUGE_BLOCK, (recipeType, icon) -> new OritechReiDisplay(recipeType, CentrifugeBlockEntity.class, icon));
        registerOritechCategory(registry, RecipeContent.ATOMIC_FORGE, BlockContent.ATOMIC_FORGE_BLOCK, (recipeType, icon) -> new OritechReiDisplay(recipeType, AtomicForgeBlockEntity.class, icon));
        
        // generators
        registerOritechCategory(registry, RecipeContent.BIO_GENERATOR, BlockContent.BIO_GENERATOR_BLOCK, (recipeType, icon) -> new OritechReiDisplay(recipeType, BioGeneratorEntity.class, icon));
        registerOritechCategory(registry, RecipeContent.FUEL_GENERATOR, BlockContent.FUEL_GENERATOR_BLOCK, (recipeType, icon) -> new OritechReiDisplay(recipeType, FuelGeneratorEntity.class, icon));
        registerOritechCategory(registry, RecipeContent.LAVA_GENERATOR, BlockContent.LAVA_GENERATOR_BLOCK, (recipeType, icon) -> new OritechReiDisplay(recipeType, LavaGeneratorEntity.class, icon));
        registerOritechCategory(registry, RecipeContent.STEAM_ENGINE, BlockContent.STEAM_ENGINE_BLOCK, (recipeType, icon) -> new OritechReiDisplay(recipeType, SteamEngineEntity.class, icon));
        
        // other
        registerOritechCategory(registry, RecipeContent.PARTICLE_COLLISION, BlockContent.ACCELERATOR_CONTROLLER, OritechReiParticleCollisionDisplay::new);
        registerOritechCategory(registry, RecipeContent.LASER, BlockContent.LASER_ARM_BLOCK, OritechReiLaserDisplay::new);
        registerOritechCategory(registry, RecipeContent.REACTOR, BlockContent.REACTOR_CONTROLLER, (recipeType, icon) -> new OritechReiDisplay(recipeType, icon, false, List.of(new ScreenProvider.GuiSlot(0, 55, 35)), new InventorySlotAssignment(0, 1, 1, 0)));
        
        // workstations
        registerOriWorkstation(registry, RecipeContent.PULVERIZER, BlockContent.PULVERIZER_BLOCK);
        registerOriWorkstation(registry, RecipeContent.GRINDER, BlockContent.FRAGMENT_FORGE_BLOCK);
        registerOriWorkstation(registry, RecipeContent.ASSEMBLER, BlockContent.ASSEMBLER_BLOCK);
        registerOriWorkstation(registry, RecipeContent.FOUNDRY, BlockContent.FOUNDRY_BLOCK);
        registerOriWorkstation(registry, RecipeContent.REFINERY, BlockContent.REFINERY_BLOCK);
        registerOriWorkstation(registry, RecipeContent.COOLER, BlockContent.COOLER_BLOCK);
        registerOriWorkstation(registry, RecipeContent.CENTRIFUGE, BlockContent.CENTRIFUGE_BLOCK);
        registerOriWorkstation(registry, RecipeContent.CENTRIFUGE_FLUID, BlockContent.CENTRIFUGE_BLOCK);
        registerOriWorkstation(registry, RecipeContent.ATOMIC_FORGE, BlockContent.ATOMIC_FORGE_BLOCK);
        registerOriWorkstation(registry, RecipeContent.BIO_GENERATOR, BlockContent.BIO_GENERATOR_BLOCK);
        registerOriWorkstation(registry, RecipeContent.LAVA_GENERATOR, BlockContent.LAVA_GENERATOR_BLOCK);
        registerOriWorkstation(registry, RecipeContent.FUEL_GENERATOR, BlockContent.FUEL_GENERATOR_BLOCK);
        registerOriWorkstation(registry, RecipeContent.PARTICLE_COLLISION, BlockContent.ACCELERATOR_CONTROLLER);
        registerOriWorkstation(registry, RecipeContent.LASER, BlockContent.LASER_ARM_BLOCK);
        registerOriWorkstation(registry, RecipeContent.REACTOR, BlockContent.REACTOR_CONTROLLER);
        
        registry.addWorkstations(CategoryIdentifier.of("minecraft", "plugins/smelting"), EntryStacks.of(BlockContent.POWERED_FURNACE_BLOCK));
    }
    
    // creates a screen instance that displays all recipes of that recipe type
    @Override
    public void registerDisplays(DisplayRegistry registry) {
        
        // recipes again for some reason
        registerMachineRecipeType(registry, RecipeContent.PULVERIZER);
        registerMachineRecipeType(registry, RecipeContent.ASSEMBLER);
        registerMachineRecipeType(registry, RecipeContent.GRINDER);
        registerMachineRecipeType(registry, RecipeContent.FOUNDRY);
        registerMachineRecipeType(registry, RecipeContent.REFINERY);
        registerMachineRecipeType(registry, RecipeContent.COOLER);
        registerMachineRecipeType(registry, RecipeContent.CENTRIFUGE);
        registerMachineRecipeType(registry, RecipeContent.CENTRIFUGE_FLUID);
        registerMachineRecipeType(registry, RecipeContent.ATOMIC_FORGE);
        registerMachineRecipeType(registry, RecipeContent.BIO_GENERATOR);
        registerMachineRecipeType(registry, RecipeContent.LAVA_GENERATOR);
        registerMachineRecipeType(registry, RecipeContent.STEAM_ENGINE);
        registerMachineRecipeType(registry, RecipeContent.FUEL_GENERATOR);
        registerMachineRecipeType(registry, RecipeContent.PARTICLE_COLLISION);
        registerMachineRecipeType(registry, RecipeContent.LASER);
        registerMachineRecipeType(registry, RecipeContent.REACTOR);
    }

    @Override
    public void registerScreens(ScreenRegistry registry) {
        registry.registerDraggableStackVisitor(new ReiItemFilterDraggableStackVisitor());
    }

    private void registerOritechCategory(CategoryRegistry registry, OritechRecipeType recipeType, class_1935 machineIcon, BiFunction<OritechRecipeType, class_1935, ? extends DisplayCategory<Display>> screenType) {
        var oriCategory = screenType.apply(recipeType, machineIcon);
        registry.add(oriCategory);
    }
    
    private void registerOriWorkstation(CategoryRegistry registry, OritechRecipeType recipeType, class_1935 machine) {
        registry.addWorkstations(CategoryIdentifier.of(recipeType.getIdentifier()), EntryStacks.of(machine));
    }
    
    private void registerMachineRecipeType(DisplayRegistry registry, OritechRecipeType recipeType) {
        registry.registerRecipeFiller(OritechRecipe.class, recipeType, OritechDisplay::new);
    }
}
