package rearth.oritech.client.ui;

import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.*;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.addons.InventoryProxyAddonBlockEntity;
import rearth.oritech.util.ScreenProvider.GuiSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1661;
import net.minecraft.class_2561;

import static rearth.oritech.client.ui.BasicMachineScreen.*;

public class InventoryProxyScreen extends BaseOwoHandledScreen<FlowLayout, InventoryProxyScreenHandler> {
    
    private final List<ButtonComponent> buttons = new ArrayList<>();
    
    public InventoryProxyScreen(InventoryProxyScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }
    
    @Override
    protected @NotNull OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create(this, Containers::verticalFlow);
    }
    
    @Override
    protected void build(FlowLayout rootComponent) {
        rootComponent
          .surface(Surface.VANILLA_TRANSLUCENT)
          .horizontalAlignment(HorizontalAlignment.CENTER)
          .verticalAlignment(VerticalAlignment.CENTER);
        
        var overlay = Containers.horizontalFlow(Sizing.fixed(176), Sizing.fixed(100));
        var spacer = Containers.horizontalFlow(Sizing.fixed(176), Sizing.fixed(166 - 100 + 5));
        
        rootComponent.child(overlay.surface(ORITECH_PANEL));
        rootComponent.child(spacer);
        
        for (var slot : Objects.requireNonNull(field_2797.controllerScreen).getGuiSlots()) {
            var button = Components.button(class_2561.method_43470(" "), elem -> {
                setActiveSlot(slot.index());
            });
            button.renderer(ORITECH_BUTTON);
            buttons.add(button);
            overlay.child(getItemFrame(slot.x(), slot.y()));
            overlay.child(button.sizing(Sizing.fixed(10)).positioning(Positioning.absolute(slot.x() + 3, slot.y() + 3)));
        }
        
        for (int i = 0; i < buttons.size(); i++) {
            var button = buttons.get(i);
            button.field_22763 = i != field_2797.selectedSlot;
        }
        
        addTitle(overlay);
        
        var hint = Components.label(class_2561.method_43471("tooltip.oritech.addon_proxy_select"));
        hint.horizontalTextAlignment(HorizontalAlignment.CENTER);
        hint.color(new Color(64 / 255f, 64 / 255f, 64 / 255f));
        hint.sizing(Sizing.fixed(176), Sizing.content(2));
        overlay.child(hint.positioning(Positioning.relative(50, 90)));
    }
    
    private void addTitle(FlowLayout overlay) {
        var blockTitle = field_2797.addonEntity.method_11010().method_26204().method_9518();
        var label = Components.label(blockTitle);
        label.color(new Color(64 / 255f, 64 / 255f, 64 / 255f));
        label.sizing(Sizing.fixed(176), Sizing.content(2));
        label.horizontalTextAlignment(HorizontalAlignment.CENTER);
        label.zIndex(1);
        overlay.child(label.positioning(Positioning.relative(50, 2)));
    }
    
    private void setActiveSlot(int slot) {
        
        field_2797.selectedSlot = slot;
        
        for (int i = 0; i < buttons.size(); i++) {
            var button = buttons.get(i);
            button.field_22763 = i != slot;
        }
        
        // sync to client entity
        field_2797.addonEntity.setTargetSlot(slot);
        
        // sync to server entity
        NetworkManager.sendToServer(new InventoryProxyAddonBlockEntity.InventoryProxySlotSelectorPacket(field_2797.blockPos, slot));
    }
}
