package rearth.oritech.client.ui;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import rearth.oritech.Oritech;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity.LastEventPacket;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;

public class AcceleratorScreen extends BasicMachineScreen<AcceleratorScreenHandler> {
    
    public static final class_2960 PARTICLE_OVERLAY = Oritech.id("textures/gui/modular/particle_background_arrow.png");
    
    private LabelComponent titleLabel;
    private LabelComponent speedLabel;
    private LabelComponent statusLabel;
    private ItemComponent activeParticleRenderer;
    
    public AcceleratorScreen(AcceleratorScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }
    
    @Override
    public boolean showExtensionPanel() {
        return false;
    }
    
    @Override
    public void fillOverlay(FlowLayout overlay) {
        super.fillOverlay(overlay);
        
        var shownItem = class_1799.field_8037;
        if (field_2797.accelerator.lastEvent.activeParticle() != class_1799.field_8037)
            shownItem = field_2797.accelerator.lastEvent.activeParticle();
        
        activeParticleRenderer = Components.item(shownItem);
        overlay.child(activeParticleRenderer.positioning(Positioning.absolute(7, 34)));
        
        var particleOverlay = Components.texture(PARTICLE_OVERLAY, 0, 0, 24, 30, 24, 30).sizing(Sizing.fixed(24), Sizing.fixed(30));
        particleOverlay.zIndex(-1);
        overlay.child(particleOverlay.positioning(Positioning.absolute(3, 27)));
        
        titleLabel = Components.label(class_2561.method_43470("Waiting...").method_27695(class_124.field_1074, class_124.field_1067));
        titleLabel.horizontalTextAlignment(HorizontalAlignment.CENTER).horizontalSizing(Sizing.fill()).verticalSizing(Sizing.fixed(10)).margins(Insets.of(1));
        
        speedLabel = Components.label(class_2561.method_43470("Speed: 0 blocks/s").method_27692(class_124.field_1074));
        speedLabel.margins(Insets.of(2));
        
        statusLabel = Components.label(class_2561.method_43470("Insert item to accelerate\nAnd some more details").method_27692(class_124.field_1074));
        statusLabel.horizontalTextAlignment(HorizontalAlignment.RIGHT).margins(Insets.of(2));
        
        var labelContainer = Containers.verticalFlow(Sizing.fixed(130), Sizing.fixed(100));
        labelContainer.child(titleLabel).child(speedLabel).child(statusLabel);
        labelContainer.horizontalAlignment(HorizontalAlignment.RIGHT);
        labelContainer.positioning(Positioning.relative(82, 30));
        
        overlay.child(labelContainer);
        
    }
    
    private void updateItemParticle() {
        var shownItem = class_1799.field_8037;
        if (field_2797.accelerator.lastEvent.lastEvent().equals(AcceleratorControllerBlockEntity.ParticleEvent.ACCELERATING) && field_2797.accelerator.lastEvent.activeParticle() != class_1799.field_8037)
            shownItem = field_2797.accelerator.lastEvent.activeParticle();
        
        activeParticleRenderer.stack(shownItem);
    }
    
    @Override
    protected void method_37432() {
        var event = field_2797.accelerator.lastEvent;
        titleLabel.horizontalTextAlignment(HorizontalAlignment.RIGHT);
        
        switch (event.lastEvent()) {
            case IDLE -> {
                var text = class_2561.method_43471("text.oritech.accelerator.ui.waiting.0");
                var time = field_2797.blockEntity.method_10997().method_8510();
                if ((time / 20) % 3 == 1) text = class_2561.method_43471("text.oritech.accelerator.ui.waiting.1");
                if ((time / 20) % 3 == 2) text = class_2561.method_43471("text.oritech.accelerator.ui.waiting.2");
                text = text.method_27695(class_124.field_1067, class_124.field_1074);
                titleLabel.horizontalTextAlignment(HorizontalAlignment.LEFT).text(text);
                speedLabel.text(class_2561.method_43471("text.oritech.accelerator.ui.waiting").method_27692(class_124.field_1074));
                statusLabel.text(class_2561.method_43470(" "));
            }
            case ERROR -> {
                titleLabel.text(class_2561.method_43471("text.oritech.accelerator.ui.error").method_27695(class_124.field_1074, class_124.field_1067));
                speedLabel.text(class_2561.method_43471("text.oritech.accelerator.ui.nogate").method_27692(class_124.field_1074));
                statusLabel.text(class_2561.method_43471("text.oritech.accelerator.ui.nogate.more").method_27692(class_124.field_1063));
            }
            case ACCELERATING -> {
                var speed = event.lastEventSpeed();
                var gateDist = format(AcceleratorParticleLogic.getMaxGateDist(speed), 1);
                var curveDist = format(AcceleratorParticleLogic.getRequiredBendDist(speed), 1);
                titleLabel.text(class_2561.method_43471("text.oritech.accelerator.ui.accelerating").method_27695(class_124.field_1074, class_124.field_1067));
                speedLabel.text(class_2561.method_43469("text.oritech.accelerator.ui.accelerating.speed", format(event.lastEventSpeed(), 0)).method_27692(class_124.field_1074));
                statusLabel.text(class_2561.method_43469("text.oritech.accelerator.ui.accelerating.stats", gateDist, curveDist).method_27692(class_124.field_1063));
            }
            case COLLIDED -> {
                titleLabel.text(class_2561.method_43471("text.oritech.accelerator.ui.collision").method_27695(class_124.field_1074, class_124.field_1067));
                speedLabel.text(class_2561.method_43469("text.oritech.accelerator.ui.collision.stats", format(event.lastEventSpeed(), 0)).method_27692(class_124.field_1074));
                statusLabel.text(class_2561.method_43469("text.oritech.accelerator.ui.collision.position", event.lastEventPosition().method_23854()).method_27692(class_124.field_1063));
            }
            case EXITED_FAST -> {
                var speed = event.lastEventSpeed();
                var curveDist = format(AcceleratorParticleLogic.getRequiredBendDist(speed), 1);
                titleLabel.text(class_2561.method_43471("text.oritech.accelerator.ui.exited").method_27695(class_124.field_1074, class_124.field_1067));
                speedLabel.text(class_2561.method_43469("text.oritech.accelerator.ui.accelerating.speed", format(event.lastEventSpeed(), 0)).method_27692(class_124.field_1074));
                statusLabel.text(class_2561.method_43469("text.oritech.accelerator.ui.exited.stats", event.lastEventPosition().method_23854(), curveDist, format(event.minBendDist(), 1)).method_27692(class_124.field_1063));
            }
            case EXITED_NO_GATE -> {
                var speed = event.lastEventSpeed();
                var gateDist = format(AcceleratorParticleLogic.getMaxGateDist(speed), 1);
                titleLabel.text(class_2561.method_43471("text.oritech.accelerator.ui.exited").method_27695(class_124.field_1074, class_124.field_1067));
                speedLabel.text(class_2561.method_43469("text.oritech.accelerator.ui.accelerating.speed", format(event.lastEventSpeed(), 0)).method_27692(class_124.field_1074));
                statusLabel.text(class_2561.method_43469("text.oritech.accelerator.ui.exited.nogate", event.lastEventPosition().method_23854(), gateDist).method_27692(class_124.field_1063));
            }
        }
        
        updateItemParticle();
        
        super.method_37432();
    }
    
    private static String format(float number, int decimal) {
        if (decimal <= 0) return String.valueOf((int) number);
        var format = "%." + decimal + "f";
        return String.format(format, number);
    }
}
