package rearth.oritech.client.renderers;

import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import rearth.oritech.block.entity.accelerator.BlackHoleBlockEntity;
import rearth.oritech.init.BlockContent;

public class BlackHoleRenderer implements class_827<BlackHoleBlockEntity> {
    
    @Override
    public void render(BlackHoleBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        
        var time = entity.method_10997().method_8510();
        // render block getting sucked in
        if (entity.currentlyPullingFrom != null && entity.currentlyPulling != null && entity.pullingStartedAt + entity.pullTime > time && !entity.currentlyPulling.method_26215()) {
            
            var progress = (float) Math.pow((time + tickDelta - entity.pullingStartedAt) / (float) entity.pullTime, 1.3f);
            var startPos = class_243.method_24954(entity.currentlyPullingFrom);
            var endPos = entity.method_11016().method_46558();
            var renderedBlock = entity.currentlyPulling;
            var offset = endPos.method_1020(startPos).method_1021(1 - progress);
            var rotationY = progress * entity.pullTime * 3;
            
            matrices.method_22903();
            matrices.method_22904(0.5, 0.5, 0.5);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(rotationY));
            matrices.method_22904(-offset.field_1352, -offset.field_1351, -offset.field_1350);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(rotationY));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(rotationY));
            matrices.method_22905(1 - progress, 1 - progress, 1 - progress);
            
            class_310.method_1551().method_1541().method_3355(
              renderedBlock,
              entity.method_11016(),
              entity.method_10997(),
              matrices,
              vertexConsumers.getBuffer(class_4696.method_23679(renderedBlock)),
              true,
              entity.method_10997().field_9229
            );
            
            matrices.method_22909();
            
        }
        
        renderBlackHole(entity, tickDelta, matrices, vertexConsumers);
    }
    
    private static void renderBlackHole(BlackHoleBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers) {
        var time = entity.method_10997().method_8510() + tickDelta;
        var rotationY = (time * 1.2f) % 360;
        var rotationX = Math.sin(time * 0.02) * 5;
        
        matrices.method_22903();
        
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rotationY));
        matrices.method_22907(class_7833.field_40714.rotationDegrees((float) rotationX));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        
        class_310.method_1551().method_1541().method_3355(
          BlockContent.BLACK_HOLE_INNER.method_9564(),
          entity.method_11016(),
          entity.method_10997(),
          matrices,
          vertexConsumers.getBuffer(class_1921.method_34571()),
          true,
          entity.method_10997().field_9229
        );
        
        class_310.method_1551().method_1541().method_3355(
          BlockContent.BLACK_HOLE_MIDDLE.method_9564(),
          entity.method_11016(),
          entity.method_10997(),
          matrices,
          vertexConsumers.getBuffer(class_4696.method_23679(BlockContent.BLACK_HOLE_MIDDLE.method_9564())),
          true,
          entity.method_10997().field_9229
        );
        
        matrices.method_22909();
        matrices.method_22903();
        
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        rotationY = (time * 1.1f) % 360;
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rotationY));
        matrices.method_22907(class_7833.field_40714.rotationDegrees((float) rotationX));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        
        class_310.method_1551().method_1541().method_3355(
          BlockContent.BLACK_HOLE_OUTER.method_9564(),
          entity.method_11016(),
          entity.method_10997(),
          matrices,
          vertexConsumers.getBuffer(class_4696.method_23679(BlockContent.BLACK_HOLE_OUTER.method_9564())),
          true,
          entity.method_10997().field_9229
        );
        
        matrices.method_22909();
    }
}
