package rearth.oritech.block.entity.storage;

import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.blocks.storage.SmallFluidTank;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.*;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3612;
import net.minecraft.class_3917;
import net.minecraft.class_7225;

public class SmallTankEntity extends NetworkedBlockEntity implements FluidApi.BlockProvider, ItemApi.BlockProvider, ComparatorOutputProvider,
                                                                       ScreenProvider, ExtendedMenuProvider {
    
    private int lastComparatorOutput = 0;
    public final boolean isCreative;
    
    private ApiLookupCache<FluidApi.FluidStorage> downLookupCache;
    
    public final InOutInventoryStorage inventory = new InOutInventoryStorage(3, this::method_5431, new InventorySlotAssignment(0, 2, 2, 1));
    
    @SyncField({SyncType.TICK, SyncType.INITIAL})
    public final SimpleFluidStorage fluidStorage = new SimpleFluidStorage(Oritech.CONFIG.portableTankCapacityBuckets() * FluidStackHooks.bucketAmount(), this::method_5431);
    
    public SmallTankEntity(class_2338 pos, class_2680 state, boolean isCreative) {
        super(isCreative ? BlockEntitiesContent.CREATIVE_TANK_ENTITY : BlockEntitiesContent.SMALL_TANK_ENTITY, pos, state);
        this.isCreative = isCreative;
    }
    
    @Override
    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        fluidStorage.writeNbt(nbt, "");
        class_1262.method_5427(nbt, inventory.heldStacks, false, registryLookup);
    }
    
    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        fluidStorage.readNbt(nbt, "");
        class_1262.method_5429(nbt, inventory.heldStacks, registryLookup);
        method_5431();
    }
    
    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        // fills/drains buckets
        
        // in creative, set tank fill level
        if (isCreative) {
            if (fluidStorage.getFluid() != class_3612.field_15906) {
                fluidStorage.setAmount(fluidStorage.getCapacity() - FluidStackHooks.bucketAmount() * 8);  //leave space to insert a bit
            } else {
                fluidStorage.setAmount(0);
            }
        }
        
        processInput();
        processOutput();
        
        if (fluidStorage.getAmount() > 0)
            outputToBelow();
        
        updateComparators(world, pos, state);
    }
    
    private void outputToBelow() {
        if (isCreative) return;
        
        if (downLookupCache == null) {
            downLookupCache = ApiLookupCache.create(
              field_11867.method_10074(),
              class_2350.field_11036, Objects.requireNonNull(field_11863),
              ((world1, targetPos, targetState, targetEntity, direction) -> FluidApi.BLOCK.find(world1, targetPos, targetState, targetEntity, direction)));
            
        }
        
        var tankCandidate = downLookupCache.lookup();
        
        if (!(tankCandidate instanceof SimpleFluidStorage belowTank)) return;
        var ownTank = this.fluidStorage;
        
        SimpleFluidStorage.transfer(ownTank, belowTank, ownTank.getCapacity(), false);
    }
    
    private void updateComparators(class_1937 world, class_2338 pos, class_2680 state) {
        var previous = lastComparatorOutput;
        lastComparatorOutput = getComparatorOutput();
        
        if (previous != lastComparatorOutput) {
            world.method_8455(pos, state.method_26204());
        }
    }
    
    // from block entity to item
    private void processInput() {
        var inStack = inventory.method_5438(0);
        var canFill = this.fluidStorage.getAmount() > 0;
        
        if (!canFill || inStack.method_7960() || inStack.method_7947() > 1) return;
        
        var stackRef = new StackContext(inStack, updated -> inventory.method_5447(0, updated));
        var candidate = FluidApi.ITEM.find(stackRef);
        if (candidate == null || !candidate.supportsInsertion()) return;
        
        var moved = FluidApi.transferFirst(fluidStorage, candidate, FluidStackHooks.bucketAmount() * 64, false);
        
        if (moved == 0) {
            // move stack to out slot
            var outStack = inventory.method_5438(2);
            if (outStack.method_7960()) {
                inventory.method_5447(2, stackRef.getValue());
                inventory.method_5447(0, class_1799.field_8037);
            } else if (outStack.method_7909().equals(stackRef.getValue().method_7909()) && outStack.method_7947() < outStack.method_7914()) {
                outStack.method_7933(1);
                inventory.method_5447(0, class_1799.field_8037);
            }
        }
    }
    
    // from item to fluid storage
    private void processOutput() {
        var inStack = inventory.method_5438(1);
        var canFill = this.fluidStorage.getAmount() < this.fluidStorage.getCapacity();
        
        if (!canFill || inStack.method_7960() || inStack.method_7947() > 1) return;
        
        var stackRef = new StackContext(inStack, updated -> inventory.method_5447(1, updated));
        var candidate = FluidApi.ITEM.find(stackRef);
        if (candidate == null || !candidate.supportsExtraction()) return;
        
        var moved = FluidApi.transferFirst(candidate, fluidStorage, FluidStackHooks.bucketAmount() * 64, false);
        
        if (moved == 0) {
            // move stack
            var outStack = inventory.method_5438(2);
            if (outStack.method_7960()) {
                inventory.method_5447(2, stackRef.getValue());
                inventory.method_5447(1, class_1799.field_8037);
            } else if (outStack.method_7909().equals(stackRef.getValue().method_7909()) && outStack.method_7947() < outStack.method_7914()) {
                outStack.method_7933(1);
                inventory.method_5447(1, class_1799.field_8037);
            }
        }
    }
    
    @Override
    public int getComparatorOutput() {
        if (fluidStorage.getFluid().equals(class_3612.field_15906)) return 0;
        
        var fillPercentage = fluidStorage.getAmount() / (float) fluidStorage.getCapacity();
        return (int) (1 + fillPercentage * 14);
    }
    
    @Override
    public void method_5431() {
        super.method_5431();
        if (field_11863 != null && !this.method_11015() && method_11010().method_11654(SmallFluidTank.LIT) != isGlowingFluid()) {
            field_11863.method_8501(method_11016(), method_11010().method_11657(SmallFluidTank.LIT, isGlowingFluid()));
        }
    }
    
    
    @Override
    public void saveExtraData(class_2540 buf) {
        sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(field_11867);
    }
    
    @Override
    public class_2561 method_5476() {
        return class_2561.method_30163("");
    }
    
    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return inventory;
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(new GuiSlot(0, 50, 19), new GuiSlot(1, 50, 61), new GuiSlot(2, 130, 42, true));
    }
    
    @Override
    public BarConfiguration getFluidConfiguration() {
        return new BarConfiguration(70, 18, 21, 60);
    }
    
    @Override
    public float getDisplayedEnergyUsage() {
        return 0;
    }
    
    @Override
    public float getProgress() {
        return 0;
    }
    
    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }
    
    @Override
    public class_1263 getDisplayedInventory() {
        return inventory;
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.TANK_SCREEN;
    }
    
    public boolean isGlowingFluid() {
        return fluidStorage.getAmount() > 0 && FluidStackHooks.getLuminosity(fluidStorage.getFluid(), null, null) > 0;
    }
    
    @Override
    public boolean showEnergy() {
        return false;
    }
    
    @Override
    public ArrowConfiguration getIndicatorConfiguration() {
        return new ArrowConfiguration(
          Oritech.id("textures/gui/modular/arrow_empty.png"),
          Oritech.id("textures/gui/modular/arrow_full.png"),
          95, 40, 29, 16, true);
    }
    
    @Override
    public boolean showExpansionPanel() {
        return false;
    }
    
    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }
    
    @Override
    public FluidApi.SingleSlotStorage getFluidStorage(@Nullable class_2350 direction) {
        return fluidStorage;
    }
}
