package rearth.oritech.block.entity.storage;

import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.ComparatorOutputProvider;

import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;

public class CreativeStorageBlockEntity extends ExpandableEnergyStorageBlockEntity implements ComparatorOutputProvider {

    public CreativeStorageBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.CREATIVE_STORAGE_ENTITY, pos, state);
    }

    @Override
    public List<class_2382> getAddonSlots() {
        return List.of();
    }

    @Override
    public long getDefaultCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getDefaultInsertRate() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getDefaultExtractionRate() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getComparatorOutput() {
        if (energyStorage.amount == 0) return 0;
        return (int) (1 + ((energyStorage.amount / (float) energyStorage.capacity) * 14));
    }

    @Override
    public float getCoreQuality() {
        return 0;
    }

    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        energyStorage.amount = (long) (Integer.MAX_VALUE * 0.9f);
        super.serverTick(world, pos, state, blockEntity);
    }
}
