package rearth.oritech.block.entity.reactor;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import io.netty.buffer.Unpooled;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.InOutInventoryStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.BasicMachineScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.ScreenProvider;
import rearth.oritech.util.SimpleCraftingInventory;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;

public class ReactorFuelPortEntity extends class_2586 implements ExtendedMenuProvider, ScreenProvider, ItemApi.BlockProvider {
    
    private final InOutInventoryStorage inventory = new InOutInventoryStorage(2, this::method_5431, new InventorySlotAssignment(0, 1, 1, 0)) {
        @Override
        public int insertToSlot(class_1799 addedStack, int slot, boolean simulate) {
            
            var craftingInv = new SimpleCraftingInventory(addedStack);
            var recipeCandidate = field_11863.method_8433().method_8132(RecipeContent.REACTOR, craftingInv, field_11863);
            if (recipeCandidate.isEmpty()) return 0;
            
            return super.insertToSlot(addedStack, slot, simulate);
            
        }
    };
    
    @SyncField(SyncType.GUI_TICK)
    public int availableFuel;
    @SyncField(SyncType.GUI_TICK)
    public int currentFuelOriginalCapacity;
    
    public ReactorFuelPortEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.REACTOR_FUEL_PORT_BLOCK_ENTITY, pos, state);
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        
        nbt.method_10569("available", availableFuel);
        nbt.method_10569("capacity", currentFuelOriginalCapacity);
        
        class_1262.method_5427(nbt, inventory.heldStacks, false, registryLookup);
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        
        availableFuel = nbt.method_10550("available");
        currentFuelOriginalCapacity = nbt.method_10550("capacity");
        
        class_1262.method_5429(nbt, inventory.heldStacks, registryLookup);
    }
    
    // consumes remaining internal fuel when disabled, but will not consume new input items
    public boolean tryConsumeFuel(int amount, boolean disabled) {
        if (availableFuel >= amount) {
            availableFuel -= amount;
            return true;
        }
        
        if (disabled) return false;
        
        // try consume input
        var inputStack = inventory.method_5438(0);
        if (inputStack.method_7960()) return false;
        
        var craftingInv = new SimpleCraftingInventory(inputStack);
        var recipeCandidate = field_11863.method_8433().method_8132(RecipeContent.REACTOR, craftingInv, field_11863);
        
        if (recipeCandidate.isEmpty()) return false;
        
        var capacity = recipeCandidate.get().comp_1933().getTime();
        currentFuelOriginalCapacity = capacity;
        availableFuel = capacity - amount;
        inputStack.method_7934(1);
        playLoadingSound();
        return true;
        
    }
    
    private void playLoadingSound() {
        var variation = field_11863.field_9229.method_43057() * 0.6f - 0.2f;
        field_11863.method_8396(null, field_11867, SoundContent.REACTOR_LOADING, class_3419.field_15245, 0.5f, 0.8f + variation);
    }
    
    public void updateNetwork() {
        var usedBuf = new class_9129(Unpooled.buffer(), field_11863.method_30349());
        var fieldCount = NetworkManager.encodeFields(this, SyncType.GUI_TICK, usedBuf, field_11863);
        if (fieldCount == 0) return;
        NetworkManager.sendBlockHandle(this, new NetworkManager.MessagePayload(field_11867, class_7923.field_41181.method_10221(method_11017()), SyncType.GUI_TICK, usedBuf.array()));
    }
    
    @Override
    public void saveExtraData(class_2540 buf) {
        buf.method_10807(field_11867);
    }
    
    @Override
    public class_2561 method_5476() {
        return class_2561.method_30163("");
    }
    
    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new BasicMachineScreenHandler(syncId, playerInventory, this);
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(new GuiSlot(0, 55, 35));
    }
    
    @Override
    public boolean showEnergy() {
        return false;
    }
    
    @Override
    public float getDisplayedEnergyUsage() {
        return 0;
    }
    
    @Override
    public float getProgress() {
        return 0;
    }
    
    @Override
    public boolean showProgress() {
        return false;
    }
    
    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }
    
    @Override
    public class_1263 getDisplayedInventory() {
        return inventory;
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.FUEL_PORT_SCREEN;
    }
    
    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }
    
    @Override
    public boolean showExpansionPanel() {
        return false;
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return inventory;
    }
}
