package rearth.oritech.block.entity.processing;

import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.InventorySlotAssignment;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3917;
import net.minecraft.class_8786;

public class AtomicForgeBlockEntity extends MultiblockMachineEntity {
    
    public AtomicForgeBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ATOMIC_FORGE_ENTITY, pos, state, Oritech.CONFIG.processingMachines.atomicForgeData.energyPerTick());
    }
    
    @Override
    protected boolean canProceed(OritechRecipe value) {     // recipe times are 1 tick, but energy storage needs to be full (sized according to recipe)
        return hasEnoughEnergy() && super.canProceed(value);
    }
    
    @Override
    protected boolean hasEnoughEnergy() {
        return energyStorage.getCapacity() > 10 && energyStorage.getAmount() >= energyStorage.getCapacity();
    }
    
    @Override
    protected boolean checkCraftingFinished(OritechRecipe activeRecipe) {
        return progress > 0;
    }
    
    @Override
    protected void useEnergy() {
        energyStorage.amount = 0;
    }
    
    @Override
    protected Optional<class_8786<OritechRecipe>> getRecipe() {
        var result = super.getRecipe();
        
        // also adjust energy storage when getting recipe
        if (result.isPresent()) {
            energyStorage.setCapacity((long) Oritech.CONFIG.processingMachines.atomicForgeData.energyPerTick() * result.get().comp_1933().getTime());
        } else {
            energyStorage.setCapacity(1);
            energyStorage.setAmount(1);
        }
        
        return result;
        
    }
    
    @Override
    public void updateEnergyContainer() { } // energy storage is updated by this class (based on the recipe amount), not the usual methods
    
    @Override
    public boolean canEnergyStorageChangeWhileGUIOpen() {
        return true;
    }
    
    @Override
    public BarConfiguration getEnergyConfiguration() {
        return new BarConfiguration(7, 7, 18, 71);
    }
    
    @Override
    public float getProgress() {
        return (float) energyStorage.getAmount() / energyStorage.getCapacity();
    }
    
    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.atomicForgeData.energyCapacity();
    }
    
    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.atomicForgeData.maxEnergyInsertion();
    }
    
    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.ATOMIC_FORGE;
    }
    
    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 3, 3, 1);
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(
          new GuiSlot(0, 56, 38),
          new GuiSlot(1, 83, 21),
          new GuiSlot(2, 83, 54),
          new GuiSlot(3, 117, 36, true));
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.ATOMIC_FORGE_SCREEN;
    }
    
    @Override
    public int getInventorySize() {
        return 4;
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return null;
    }
    
    @Override
    public List<class_2382> getCorePositions() {
        return List.of(
          new class_2382(1, 0, 1),
          new class_2382(1, 0, 0),
          new class_2382(1, 0, -1),
          new class_2382(0, 0, 1),
          new class_2382(0, 0, -1),
          new class_2382(-1, 0, 1),
          new class_2382(-1, 0, 0),
          new class_2382(-1, 0, -1)
        );
    }
    
    @Override
    public List<class_2382> getAddonSlots() {
        return new ArrayList<>();
    }
    
    @Override
    public void saveExtraData(class_2540 buf) {
        buf.method_10807(field_11867);
    }
}
