package rearth.oritech.block.entity.processing;

import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.InventorySlotAssignment;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3917;

public class AssemblerBlockEntity extends MultiblockMachineEntity {
    
    public AssemblerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ASSEMBLER_ENTITY, pos, state, Oritech.CONFIG.processingMachines.assemblerData.energyPerTick());
    }
    
    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.assemblerData.energyCapacity();
    }
    
    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.assemblerData.maxEnergyInsertion();
    }
    
    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.ASSEMBLER;
    }
    
    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 4, 4, 1);
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(
          new GuiSlot(0, 38, 26),
          new GuiSlot(1, 56, 26),
          new GuiSlot(2, 38, 44),
          new GuiSlot(3, 56, 44),
          new GuiSlot(4, 117, 36, true));
    }
    
    @Override
    protected void useEnergy() {
        super.useEnergy();
        
        if (field_11863.field_9229.method_43057() > 0.4) return;
        // emit particles
        var facing = getFacing();
        var offsetLocal = Geometry.rotatePosition(new class_243(0, 0.6, 0.5), facing);
        var emitPosition = class_243.method_24953(field_11867).method_1019(offsetLocal);
        
        ParticleContent.ASSEMBLER_WORKING.spawn(field_11863, emitPosition, 1);
        
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.ASSEMBLER_SCREEN;
    }
    
    @Override
    public int getInventorySize() {
        return 5;
    }
    
    @Override
    public List<class_2382> getCorePositions() {
        return List.of(
          new class_2382(0, 0,1),
          new class_2382(0, 1,0),
          new class_2382(0, 1,1)
        );
    }
    
    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(
          new class_2382(0, 0,-1),
          new class_2382(0, 0,2),
          new class_2382(1, 0,0)
        );
    }
}
