package rearth.oritech.block.entity.pipes;

import dev.architectury.platform.Platform;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.blocks.pipes.item.ItemFilterBlock;
import rearth.oritech.client.ui.ItemFilterScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9334;

public class ItemFilterBlockEntity extends NetworkedBlockEntity implements ItemApi.BlockProvider, ExtendedMenuProvider {
    
    public final FilterBlockInventory inventory = new FilterBlockInventory(1, this::method_5431);
    
    @SyncField(SyncType.GUI_OPEN)
    protected FilterData filterSettings = new FilterData(false, true, false, new HashMap<>());
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427(nbt, inventory.heldStacks, false, registryLookup);
        nbt.method_10556("whitelist", filterSettings.useWhitelist);
        nbt.method_10556("useNbt", filterSettings.useNbt);
        nbt.method_10556("useComponents", filterSettings.useComponents);
        
        var filterItems = filterSettings.items.values();
        var itemsNbtList = new class_2499();
        
        for (var item : filterItems) {
            var data = item.method_57358(registryLookup);
            itemsNbtList.add(data);
        }
        
        nbt.method_10566("filterItems", itemsNbtList);
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429(nbt, inventory.heldStacks, registryLookup);
        
        var whiteList = nbt.method_10577("whitelist");
        var useNbt = nbt.method_10577("useNbt");
        var useComponents = nbt.method_10577("useComponents");
        
        var list = nbt.method_10554("filterItems", class_2520.field_33260);
        var itemsList = new HashMap<Integer, class_1799>();
        for (int i = 0; i < list.size(); i++) {
            var data = list.method_10534(i);
            var stack = class_1799.method_57360(registryLookup, data).orElse(class_1799.field_8037);
            
            itemsList.put(i, stack);
        }
        
        var data = new FilterData(useNbt, whiteList, useComponents, itemsList);
        this.setFilterSettings(data);
        
    }
    
    public ItemFilterBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ITEM_FILTER_ENTITY, pos, state);
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return inventory;
    }
    
    @Override
    public void saveExtraData(class_2540 buf) {
        sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(field_11867);
    }
    
    @Override
    public class_2561 method_5476() {
        return class_2561.method_30163("");
    }
    
    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new ItemFilterScreenHandler(syncId, playerInventory, this);
    }
    
    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        
        // if non-empty and inventory in target, move it
        if (inventory.method_5442()) return;
        
        var targetDirection = method_11010().method_11654(ItemFilterBlock.TARGET_DIR);
        var targetPos = pos.method_10081(targetDirection.method_10163());
        
        // todo caching
        var targetInv = ItemApi.BLOCK.find(world, targetPos, targetDirection);
        if (targetInv == null) return;
        
        var firstItem = inventory.heldStacks.getFirst();
        var inserted = targetInv.insert(firstItem.method_7972(), false);
        firstItem.method_7934(inserted);
        
    }
    
    public FilterData getFilterSettings() {
        return filterSettings;
    }
    
    public void setFilterSettings(FilterData filterSettings) {
        this.filterSettings = filterSettings;
        this.method_5431();
    }
    
    @Override
    public void method_5431() {
        if (this.field_11863 != null)
            field_11863.method_8524(field_11867);
    }
    
    public static void handleClientUpdate(ItemFilterPayload message, class_1657 player, class_5455 registryAccess) {
        var blockEntity = player.method_37908().method_35230(message.pos(), BlockEntitiesContent.ITEM_FILTER_ENTITY);
        if (blockEntity.isPresent()) {
            blockEntity.get().setFilterSettings(message.data);
        }
    
    }
    
    // items is a map of position index (in the filter GUI) to filtered item stack
    public record FilterData(boolean useNbt, boolean useWhitelist, boolean useComponents, Map<Integer, class_1799> items) {
        
        public static class_9139<class_9129, FilterData> PACKET_CODEC = class_9139.method_56905(
          class_9135.field_48547, FilterData::useNbt,
          class_9135.field_48547, FilterData::useWhitelist,
          class_9135.field_48547, FilterData::useComponents,
          class_9135.method_56377(HashMap::new, class_9135.field_49675, class_1799.field_48349), FilterData::items,
          FilterData::new
        );
        
    }
    
    // used to send data to server
    public record ItemFilterPayload(class_2338 pos, FilterData data) implements class_8710 {
        @Override
        public class_9154<? extends class_8710> method_56479() {
            return FILTER_PACKET_ID;
        }
        
        public static final class_8710.class_9154<ItemFilterPayload> FILTER_PACKET_ID = new class_8710.class_9154<>(Oritech.id("filter"));
        
        public static final class_9139<class_9129, ItemFilterPayload> PACKET_CODEC = class_9139.method_56435(
          class_2338.field_48404, ItemFilterPayload::pos,
          FilterData.PACKET_CODEC, ItemFilterPayload::data,
          ItemFilterPayload::new
        );
    }
    
    public class FilterBlockInventory extends SimpleInventoryStorage {
        
        public FilterBlockInventory(int size, Runnable onUpdate) {
            super(size, onUpdate);
        }
        
        public boolean canInsert(class_1799 stack) {
            
            // check filter settings
            var checkNbt = filterSettings.useNbt;
            var checkComponents = filterSettings.useComponents;
            var matchesFilterItems = false; // true if at least 1 item matches
            
            for (var filterItem : filterSettings.items.values()) {
                
                if (Platform.isModLoaded("ftbfiltersystem")) {
                    var filterApi = dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI.api();
                    if (filterApi.isFilterItem(filterItem)) {
                        if (filterApi.doesFilterMatch(filterItem, stack)) {
                            matchesFilterItems = true;
                            break;
                        }
                    }
                }
                
                var matchesType = stack.method_7909().equals(filterItem.method_7909());
                if (!matchesType) continue;
                
                if (checkComponents) {
                    var componentsMatch = stack.method_57380().equals(filterItem.method_57380());
                    if (!componentsMatch) {
                        break;
                    }
                }
                
                if (checkNbt) {
                    // check if both have nbt, if so compare them
                    // if not both check if neither has nbt, and type matches
                    if (stack.method_57826(class_9334.field_49628) && filterItem.method_57826(class_9334.field_49628)) {
                        var match = stack.method_57824(class_9334.field_49628).equals(filterItem.method_57824(class_9334.field_49628));
                        if (match) {
                            matchesFilterItems = true;
                            break;
                        }
                    } else if (!stack.method_57826(class_9334.field_49628) && !filterItem.method_57826(class_9334.field_49628)) {
                        matchesFilterItems = true;
                        break;
                    }
                } else {
                    matchesFilterItems = true;
                    break;
                }
                
            }
            
            // matchesFilterItems is true when at least 1 item matches
            if (filterSettings.useWhitelist) {
                return matchesFilterItems;
            } else {
                // blacklist list, if we have a match we return false
                return !matchesFilterItems;
            }
        }
        
        @Override
        public int insertToSlot(class_1799 addedStack, int slot, boolean simulate) {
            
            if (!canInsert(addedStack))
                return 0;
            
            return super.insertToSlot(addedStack, slot, simulate);
        }
    }
}
