package rearth.oritech.block.entity.addons;

import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.block.base.entity.UpgradableGeneratorBlockEntity;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.MachineAddonController;

import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class SteamBoilerAddonBlockEntity extends AddonBlockEntity implements FluidApi.BlockProvider {
    
    private UpgradableGeneratorBlockEntity cachedController;
    
    public SteamBoilerAddonBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.STEAM_BOILER_ADDON_ENTITY, pos, state);
    }
    
    private boolean isConnected() {
        var isUsed = this.method_11010().method_11654(MachineAddonBlock.ADDON_USED);
        return isUsed && getCachedController() != null;
    }
    
    private MachineAddonController getCachedController() {
        
        if (cachedController != null)
            return cachedController;
        
        var candidate = Objects.requireNonNull(field_11863).method_8321(getControllerPos());
        if (candidate instanceof UpgradableGeneratorBlockEntity generator) {
            cachedController = generator;
        }
        return cachedController;
    }
    
    @Override
    public FluidApi.FluidStorage getFluidStorage(class_2350 direction) {
        if (!isConnected()) return null;
        return cachedController.boilerStorage;
    }
}
