package rearth.oritech.block.entity.accelerator;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5558;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.ComparatorOutputProvider;

public class AcceleratorSensorBlockEntity extends class_2586 implements class_5558<AcceleratorSensorBlockEntity>, ComparatorOutputProvider {
    
    private float measuredSpeed;
    private long measuredTime;
    
    private boolean dirty = false;
    
    public AcceleratorSensorBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ACCELERATOR_SENSOR_BLOCK_ENTITY, pos, state);
    }
    
    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, AcceleratorSensorBlockEntity blockEntity) {
        if (world.field_9236) return;
        
        if (measuredSpeed != 0) {
            var age = world.method_8510() - measuredTime;
            
            if (age > 8) {
                measuredSpeed = 0;
                dirty = true;
            }
        }
        
        if (dirty) {
            dirty = false;
            world.method_8455(pos, method_11010().method_26204());
        }
    }
    
    public void measureParticle(AcceleratorParticleLogic.ActiveParticle particle) {
        this.measuredSpeed = particle.velocity;
        this.measuredTime = field_11863.method_8510();
        dirty = true;
    }

    @Override
    public int getComparatorOutput() {
        if (measuredSpeed <= 0) {
            return 0;
        } else if (measuredSpeed <= 10) {
            return 1;
        } else if (measuredSpeed <= 50) {
            return 2;
        } else if (measuredSpeed <= 75) {
            return 3;
        } else if (measuredSpeed <= 100) {
            return 4;
        } else if (measuredSpeed <= 150) {
            return 5;
        } else if (measuredSpeed <= 250) {
            return 6;
        } else if (measuredSpeed <= 500) {
            return 7;
        } else if (measuredSpeed <= 750) {
            return 8;
        } else if (measuredSpeed <= 1000) {
            return 9;
        } else if (measuredSpeed <= 2500) {
            return 10;
        } else if (measuredSpeed <= 5000) {
            return 11;
        } else if (measuredSpeed <= 7500) {
            return 12;
        } else if (measuredSpeed <= 10000) {
            return 13;
        } else if (measuredSpeed <= 15000) {
            return 14;
        }
        
        return 15;
    }
}
