package rearth.oritech.block.blocks.addons;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.addons.RedstoneAddonBlockEntity;
import rearth.oritech.util.ComparatorOutputProvider;

public class RedstoneAddonBlock extends MachineAddonBlock {
    
    public RedstoneAddonBlock(class_2251 settings, AddonSettings addonSettings) {
        super(settings, addonSettings);
        this.method_9590(method_9564().method_11657(class_2741.field_12484, false));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(class_2741.field_12484);
    }
    
    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }
    
    @Override
    protected boolean method_9498(class_2680 state) {
        return true;
    }
    
    @Override
    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return ((ComparatorOutputProvider) world.method_8321(pos)).getComparatorOutput();
    }
    
    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        
        if (world.field_9236) return;
        
        var isPowered = world.method_49803(pos);
        
        var addonEntity = (RedstoneAddonBlockEntity) world.method_8321(pos);
        addonEntity.setRedstonePowered(isPowered);
        
    }
    
    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        
        var isPowered = world.method_49803(pos);
        var poweredState = state.method_11657(class_2741.field_12484, isPowered);
        
        return super.method_9559(poweredState, direction, neighborState, world, pos, neighborPos);
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236) {
            var handler = (ExtendedMenuProvider) world.method_8321(pos);
                MenuRegistry.openExtendedMenu((class_3222) player, handler);
            
        }
        
        return class_1269.field_5812;
    }
    
    @Override
    public @NotNull Class<? extends class_2586> getBlockEntityType() {
        return RedstoneAddonBlockEntity.class;
    }
    
    @SuppressWarnings({"rawtypes", "unchecked"})
    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558 ticker)
                ticker.tick(world1, pos, state1, blockEntity);
        };
    }
    
}
