/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.augmenter;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1863;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_8710;
import rearth.oritech.Oritech;
import rearth.oritech.api.attachment.AttachmentApi;
import rearth.oritech.block.entity.augmenter.AugmentApplicationEntity;
import rearth.oritech.block.entity.augmenter.api.Augment;
import rearth.oritech.init.recipes.AugmentDataRecipe;
import rearth.oritech.init.recipes.RecipeContent;

public class PlayerAugments {
    public static final Map<class_2960, Augment> allAugments = new HashMap<class_2960, Augment>();

    public static void loadAllAugments(class_1863 manager) {
        allAugments.clear();
        manager.method_30027((class_3956)RecipeContent.AUGMENT_DATA).forEach(recipe -> allAugments.put(recipe.comp_1932(), ((AugmentDataRecipe)recipe.comp_1933()).createAugment(recipe.comp_1932())));
    }

    public static void serverTickAugments(class_3222 player) {
        for (Augment augment : allAugments.values()) {
            Map<class_2960, Augment.AugmentState> data;
            if (!augment.isEnabled(data = AttachmentApi.getAttachmentValue((class_1309)player, Augment.ACTIVE_AUGMENTS_DATA)) || player.method_51469().method_8510() % (long)augment.refreshInterval() != 0L) continue;
            augment.refreshServer((class_1657)player);
        }
    }

    public static void receiveInstallTrigger(AugmentInstallTriggerPacket packet, class_1657 player, class_5455 dynamicRegistryManager) {
        class_2586 entity = player.method_37908().method_8321(packet.position);
        if (entity instanceof AugmentApplicationEntity) {
            AugmentApplicationEntity modifierEntity = (AugmentApplicationEntity)entity;
            AugmentApplicatorOperation operation = AugmentApplicatorOperation.values()[packet.operationId];
            switch (operation.ordinal()) {
                case 0: {
                    modifierEntity.researchAugment(packet.id, player.method_7337(), player);
                    break;
                }
                case 1: {
                    modifierEntity.installAugmentToPlayer(packet.id, player);
                    break;
                }
                case 2: {
                    modifierEntity.removeAugmentFromPlayer(packet.id, player);
                }
            }
        }
    }

    public static void receivePlayerLoadMachine(LoadPlayerAugmentsToMachinePacket packet, class_1657 player, class_5455 dynamicRegistryManager) {
        class_2586 entity = player.method_37908().method_8321(packet.position);
        if (entity instanceof AugmentApplicationEntity) {
            AugmentApplicationEntity modifierEntity = (AugmentApplicationEntity)entity;
            modifierEntity.loadResearchesFromPlayer(player);
        }
    }

    public static void receiveOpenAugmentScreen(OpenAugmentScreenPacket packet, class_1657 player, class_5455 dynamicRegistryManager) {
        class_2586 entity = player.method_37908().method_8321(packet.position);
        if (entity instanceof AugmentApplicationEntity) {
            AugmentApplicationEntity modifierEntity = (AugmentApplicationEntity)entity;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                modifierEntity.screenInvOverride = true;
                MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (ExtendedMenuProvider)modifierEntity);
            }
        }
    }

    public static void receiveToggleAugment(AugmentPlayerTogglePacket packet, class_1657 player, class_5455 dynamicRegistryManager) {
        AugmentApplicationEntity.toggleAugmentForPlayer(packet.id, player);
    }

    public record AugmentInstallTriggerPacket(class_2338 position, class_2960 id, int operationId) implements class_8710
    {
        public static final class_8710.class_9154<AugmentInstallTriggerPacket> PACKET_ID = new class_8710.class_9154(Oritech.id("aug_install"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }

    public static enum AugmentApplicatorOperation {
        RESEARCH,
        ADD,
        REMOVE,
        NONE,
        NEEDS_INIT;

    }

    public record LoadPlayerAugmentsToMachinePacket(class_2338 position) implements class_8710
    {
        public static final class_8710.class_9154<LoadPlayerAugmentsToMachinePacket> PACKET_ID = new class_8710.class_9154(Oritech.id("aug_loadtomachine"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }

    public record OpenAugmentScreenPacket(class_2338 position) implements class_8710
    {
        public static final class_8710.class_9154<OpenAugmentScreenPacket> PACKET_ID = new class_8710.class_9154(Oritech.id("aug_openscreen"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }

    public record AugmentPlayerTogglePacket(class_2960 id) implements class_8710
    {
        public static final class_8710.class_9154<AugmentPlayerTogglePacket> PACKET_ID = new class_8710.class_9154(Oritech.id("aug_toggle"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}

