/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.arcane;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.arcane.BaseSoulCollectionEntity;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.util.ComparatorOutputProvider;

public class SpawnerControllerBlockEntity
extends BaseSoulCollectionEntity
implements class_5558<SpawnerControllerBlockEntity>,
ComparatorOutputProvider {
    public int maxSouls = 100000;
    public int collectedSouls = 0;
    public class_1299<?> spawnedMob;
    public class_1297 renderedEntity;
    private boolean networkDirty;
    public boolean hasCage;
    private int lastComparatorOutput;
    private boolean redstonePowered;
    private class_2960 loadedMob;
    public float lastProgress = 0.0f;

    public SpawnerControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.SPAWNER_CONTROLLER_BLOCK_ENTITY, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, SpawnerControllerBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
        if (this.loadedMob != null && this.spawnedMob == null) {
            this.loadEntityFromIdentifier(this.loadedMob);
            this.loadedMob = null;
            this.method_5431();
        }
        if (this.spawnedMob == null || !this.hasCage || this.redstonePowered) {
            return;
        }
        if (this.collectedSouls >= this.maxSouls && world.method_8510() % 4L == 0L) {
            this.spawnMob();
            this.updateComparator();
        }
        if (this.networkDirty) {
            this.updateNetwork();
            BaseSoulCollectionEntity.DeathListener.resetEvents();
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("souls", this.collectedSouls);
        nbt.method_10569("maxSouls", this.maxSouls);
        nbt.method_10556("cage", this.hasCage);
        nbt.method_10556("redstone", this.redstonePowered);
        if (this.spawnedMob != null) {
            nbt.method_10582("spawnedMob", class_7923.field_41177.method_10221(this.spawnedMob).toString());
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.hasCage = nbt.method_10577("cage");
        this.maxSouls = nbt.method_10550("maxSouls");
        this.collectedSouls = nbt.method_10550("souls");
        this.redstonePowered = nbt.method_10577("redstone");
        if (nbt.method_10545("spawnedMob")) {
            this.loadedMob = class_2960.method_60654((String)nbt.method_10558("spawnedMob"));
        }
    }

    private void spawnMob() {
        int spawnRange = 4;
        int requiredHeight = Math.round(this.spawnedMob.method_17686() + 0.5f);
        class_2338 targetPosition = this.findSpawnPosition(spawnRange, requiredHeight);
        if (targetPosition == null) {
            return;
        }
        this.networkDirty = true;
        this.spawnedMob.method_47821((class_3218)this.field_11863, targetPosition, class_3730.field_16469);
        this.collectedSouls -= this.maxSouls;
        ParticleContent.SOUL_USED.spawn(this.field_11863, targetPosition.method_46558(), (Object)this.maxSouls);
    }

    private class_2338 findSpawnPosition(int spawnRange, int requiredHeight) {
        for (int i = 0; i < 10; ++i) {
            class_2338 candidate = this.field_11867.method_10069(this.field_11863.field_9229.method_39332(-spawnRange, spawnRange), 3, this.field_11863.field_9229.method_39332(-spawnRange, spawnRange));
            int foundFree = 0;
            for (int j = 0; j < 9; ++j) {
                class_2680 state = this.field_11863.method_8320(candidate.method_10087(j));
                if (state.method_26215()) {
                    ++foundFree;
                    continue;
                }
                if (foundFree > requiredHeight) {
                    return candidate.method_10087(j - 1);
                }
                foundFree = 0;
            }
        }
        return null;
    }

    private void updateNetwork() {
        this.networkDirty = false;
        if (this.spawnedMob != null) {
            NetworkManager.sendBlockHandle(this, new SpawnerSyncPacket(this.field_11867, class_7923.field_41177.method_10221(this.spawnedMob), this.hasCage, this.collectedSouls, this.maxSouls));
        }
    }

    public static void receiveUpdatePacket(SpawnerSyncPacket message, class_1937 world, class_5455 dynamicRegistryManager) {
        class_2586 class_25862 = world.method_8321(message.position);
        if (class_25862 instanceof SpawnerControllerBlockEntity) {
            SpawnerControllerBlockEntity spawnerEntity = (SpawnerControllerBlockEntity)class_25862;
            spawnerEntity.loadEntityFromIdentifier(message.spawnedMob);
            spawnerEntity.hasCage = message.hasCage;
            spawnerEntity.collectedSouls = message.collectedSouls;
            spawnerEntity.maxSouls = message.maxSouls;
        }
    }

    public void method_5431() {
        super.method_5431();
        this.networkDirty = true;
    }

    public void loadEntityFromIdentifier(class_2960 identifier) {
        class_1299 newMob = (class_1299)class_7923.field_41177.method_10223(identifier);
        if (newMob != this.spawnedMob) {
            this.spawnedMob = newMob;
            this.renderedEntity = this.spawnedMob.method_5883(this.field_11863);
        }
    }

    @Override
    public boolean canAcceptSoul() {
        return this.collectedSouls < this.maxSouls;
    }

    private void updateComparator() {
        int progress = this.getComparatorOutput();
        if (this.lastComparatorOutput != progress) {
            this.lastComparatorOutput = progress;
            this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
        }
    }

    @Override
    public int getComparatorOutput() {
        if (this.spawnedMob == null || this.maxSouls == 0) {
            return 0;
        }
        return (int)((float)this.collectedSouls / (float)this.maxSouls * 15.0f);
    }

    public void setRedstonePowered(boolean active) {
        this.redstonePowered = active;
    }

    @Override
    public void onSoulIncoming(class_243 source) {
        float distance = (float)source.method_1022(this.field_11867.method_46558());
        ++this.collectedSouls;
        class_243 soulPath = this.field_11867.method_46558().method_1020(source);
        ParticleContent.SoulParticleData animData = new ParticleContent.SoulParticleData(soulPath, (int)SpawnerControllerBlockEntity.getSoulTravelDuration(distance));
        ParticleContent.WANDERING_SOUL.spawn(this.field_11863, source.method_1031(0.0, (double)0.7f, 0.0), (Object)animData);
        this.networkDirty = true;
        this.updateComparator();
    }

    private int getSoulCost(int maxHp) {
        return (int)(Math.sqrt(maxHp) + 0.5) * Oritech.CONFIG.spawnerCostMultiplier();
    }

    public void onEntitySteppedOn(class_1297 entity) {
        if (this.spawnedMob != null) {
            return;
        }
        if (entity instanceof class_1308) {
            class_1308 mobEntity = (class_1308)entity;
            if (mobEntity.method_5864().arch$holder().method_40220(TagContent.SPAWNER_BLACKLIST)) {
                Oritech.LOGGER.debug("Ignored blacklisted entity for spawner: " + String.valueOf(mobEntity.method_5864().arch$registryName()));
                return;
            }
            this.spawnedMob = mobEntity.method_5864();
            this.networkDirty = true;
            this.maxSouls = this.getSoulCost((int)mobEntity.method_6063());
            mobEntity.method_5650(class_1297.class_5529.field_26999);
            this.reloadCage(null);
            this.method_5431();
        }
    }

    public void onBlockInteracted(class_1657 player) {
        if (this.spawnedMob == null) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.oritech.spawner.no_mob"));
            return;
        }
        this.networkDirty = true;
        this.reloadCage(player);
        if (this.hasCage) {
            player.method_43496((class_2561)class_2561.method_43469((String)"tooltip.oritech.spawner.collected_souls", (Object[])new Object[]{this.collectedSouls, this.maxSouls}));
        }
    }

    private void reloadCage(@Nullable class_1657 player) {
        class_2382 cageSize = new class_2382(Math.round(this.spawnedMob.method_17685() * 2.0f + 0.5f), Math.round(this.spawnedMob.method_17686() + 0.5f), Math.round(this.spawnedMob.method_17685() * 2.0f + 0.5f));
        int offset = cageSize.method_10263() / 2;
        this.hasCage = true;
        for (int x = 0; x < cageSize.method_10263(); ++x) {
            for (int y = 0; y < cageSize.method_10264(); ++y) {
                for (int z = 0; z < cageSize.method_10260(); ++z) {
                    class_2338 candidate = this.field_11867.method_10069(-offset + x, -y - 1, -offset + z);
                    if (this.field_11863.method_8320(candidate).method_26204().equals(BlockContent.SPAWNER_CAGE_BLOCK)) continue;
                    this.hasCage = false;
                    ParticleContent.DEBUG_BLOCK.spawn(this.field_11863, class_243.method_24954((class_2382)candidate));
                }
            }
        }
        if (!this.hasCage && player != null) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.oritech.spawner.no_cage"));
        }
        this.method_5431();
    }

    public record SpawnerSyncPacket(class_2338 position, class_2960 spawnedMob, boolean hasCage, int collectedSouls, int maxSouls) implements class_8710
    {
        public static final class_8710.class_9154<SpawnerSyncPacket> PACKET_ID = new class_8710.class_9154(Oritech.id("spawner"));

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}

