package rearth.oritech.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

// this is very much inspired by TR: https://github.com/TechReborn/TechReborn/blob/1.21/RebornCore/src/main/java/reborncore/common/crafting/SizedIngredient.java#L50
public record SizedIngredient(int count, class_1856 ingredient) implements Predicate<class_1799> {
    
    public static MapCodec<SizedIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
      Codec.INT.optionalFieldOf("count", 1).forGetter(SizedIngredient::count),
      class_1856.field_46096.fieldOf("ingredient").forGetter(SizedIngredient::ingredient)
    ).apply(instance, SizedIngredient::new));
    
    public static class_9139<class_9129, SizedIngredient> PACKET_CODEC = class_9139.method_56435(
      class_9135.field_49675, SizedIngredient::count,
      class_1856.field_48355, SizedIngredient::ingredient,
      SizedIngredient::new
    );
    
    @Override
    public boolean test(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            // Never match empty stacks.
            return false;
        }
        
        if (itemStack.method_7947() < count) {
            return false;
        }
        
        return ingredient.method_8093(itemStack);
    }
}
