package rearth.oritech.util;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.block.entity.addons.CombiAddonEntity;
import rearth.oritech.block.entity.storage.SmallStorageBlockEntity;
import rearth.oritech.block.entity.storage.SmallTankEntity;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.init.LootContent;

import java.util.List;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;

public class NbtBlockLootFunction extends class_120 {
    public static final String NAME = "nbt_block_loot";
    
    public NbtBlockLootFunction(List<class_5341> conditions) {
        super(conditions);
    }
    
    @Override
    public @NotNull class_1799 method_522(@NotNull class_1799 stack, class_47 context) {
        var blockEntity = context.method_296(class_181.field_1228);
        
        if (blockEntity instanceof SmallTankEntity tankEntity && tankEntity.fluidStorage.getAmount() > 0) {
            stack.method_57379(FluidApi.ITEM.getFluidComponent(), tankEntity.fluidStorage.getStack());
        } else if (blockEntity instanceof SmallStorageBlockEntity storageEntity && storageEntity.energyStorage.amount > 0) {
            stack.method_57379(EnergyApi.ITEM.getEnergyComponent(), storageEntity.energyStorage.amount);
        } else if (blockEntity instanceof CombiAddonEntity combiAddon && combiAddon.storedData != null) {
            stack.method_57379(ComponentContent.ADDON_DATA.get(), combiAddon.storedData);
        }
        
        return stack;
    }
    
    @Override
    public class_5339<NbtBlockLootFunction> method_29321() {
        return LootContent.NBT_BLOCK_LOOT_FUNCTION;
    }
    
    public static net.minecraft.class_120.class_121<?> builder() {
        return class_120.method_520(NbtBlockLootFunction::new);
    }
    
    public static final MapCodec<NbtBlockLootFunction> CODEC = RecordCodecBuilder.mapCodec(
      instance -> class_120.method_53344(instance).apply(instance, NbtBlockLootFunction::new));
}
