package rearth.oritech.item.tools.armor;

import rearth.oritech.Oritech;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public class JetpackExoArmorItem extends BackstorageExoArmorItem implements BaseJetpackItem {
    public JetpackExoArmorItem(class_6880<class_1741> material, class_8051 type, class_1792.class_1793 settings) {
        super(material, type, settings);
    }
    
    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        
        if (world.field_9236) {
            tickJetpack(stack, entity, world);
        } else {
            super.method_7888(stack, world, entity, slot, selected);
        }
    }
    
    @Override
    public class_2960 getModel() {
        return Oritech.id("armor/exo_armor_jetpack");
    }
    
    @Override
    public int method_31571(class_1799 stack) {
        return getJetpackBarColor(stack);
    }
    
    @Override
    public int method_31569(class_1799 stack) {
        return getJetpackBarStep(stack);
    }
    
    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        var hint = class_2561.method_43471("tooltip.oritech.jetpack_usage").method_27695(class_124.field_1080, class_124.field_1056);
        tooltip.add(hint);
        hint = class_2561.method_43471("tooltip.oritech.jetpack_usage2").method_27695(class_124.field_1080, class_124.field_1056);
        tooltip.add(hint);
        
        super.method_7851(stack, context, tooltip, type);
        addJetpackTooltip(stack, tooltip, false);
    }
    
    @Override
    public boolean requireUpward() {
        return false;
    }
    
    @Override
    public float getSpeed() {
        return Oritech.CONFIG.exoJetpack.speed();
    }
    
    @Override
    public int getRfUsage() {
        return Oritech.CONFIG.exoJetpack.energyUsage();
    }
    
    @Override
    public int getFuelUsage() {
        return Oritech.CONFIG.exoJetpack.fuelUsage();
    }
    
    @Override
    public long getFuelCapacity() {
        return Oritech.CONFIG.exoJetpack.fuelCapacity();
    }
    
    @Override
    public long getEnergyCapacity(class_1799 stack) {
        return Oritech.CONFIG.exoJetpack.energyCapacity();
    }
    
    @Override
    public long getEnergyMaxInput(class_1799 stack) {
        return Oritech.CONFIG.exoJetpack.chargeSpeed();
    }
}
