package rearth.oritech.client.ui;

import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.block.entity.processing.CentrifugeBlockEntity;

import java.util.Objects;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_2586;

public class CentrifugeScreenHandler extends UpgradableMachineScreenHandler {
    
    public final FluidApi.SingleSlotStorage inputTank;
    
    public CentrifugeScreenHandler(int syncId, class_1661 inventory, class_2540 buf) {
        this(syncId, inventory, Objects.requireNonNull(inventory.field_7546.method_37908().method_8321(buf.method_10811())));
    }
    
    public CentrifugeScreenHandler(int syncId, class_1661 playerInventory, class_2586 blockEntity) {
        super(syncId, playerInventory, blockEntity);
        
        if (!(blockEntity instanceof CentrifugeBlockEntity centrifugeEntity)) {
            inputTank = null;
            Oritech.LOGGER.error("Opened centrifuge screen on non-centrifuge block, this should never happen");
            return;
        }
        
        if (centrifugeEntity.hasFluidAddon) {
            inputTank = centrifugeEntity.fluidContainer.getInputContainer();
            this.mainFluidContainer = centrifugeEntity.fluidContainer.getOutputContainer();
        } else {
            inputTank = null;
        }
    }
}
