package rearth.oritech.client.renderers;

import net.minecraft.class_2246;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.entity.storage.UnstableContainerBlockEntity;
import software.bernie.geckolib.cache.object.BakedGeoModel;

public class UnstableContainerRenderer extends MachineRenderer<UnstableContainerBlockEntity> {
    
    public UnstableContainerRenderer(String modelPath) {
        super(modelPath);
    }
    
    @Override
    public void postRender(class_4587 poseStack, UnstableContainerBlockEntity animatable, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        super.postRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        
        var time = animatable.method_10997().method_8510();
        var totalTime = time + partialTick;
        
        var rotationY = (totalTime * 10) % 360;
        
        if (animatable.capturedBlock == null) return;
        
        poseStack.method_22903();
        poseStack.method_22905(0.6f, 0.6f, 0.6f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(rotationY));
        poseStack.method_22904(-0.5, 0, -0.5);
        
        
        var renderManager = class_310.method_1551().method_1541();
        var renderedModel = renderManager.method_3349(animatable.capturedBlock);
        
        renderManager.method_3350().method_3374(
          animatable.method_10997(),
          renderedModel,
          class_2246.field_10171.method_9564(),
          animatable.method_11016(),
          poseStack,
          bufferSource.getBuffer(class_4696.method_23679(animatable.capturedBlock)),
          true,
          animatable.method_10997().field_9229,
          animatable.capturedBlock.method_26190(animatable.method_11016()),
          class_765.field_32767
        );
        
        poseStack.method_22909();
    }
}
