package rearth.oritech.block.entity.processing;

import dev.architectury.hooks.fluid.FluidStackHooks;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleFluidStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.TagContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.FluidIngredient;
import rearth.oritech.util.InventorySlotAssignment;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_8786;

public class CoolerBlockEntity extends MultiblockMachineEntity implements FluidApi.BlockProvider {
    
    private boolean inColdArea;
    private boolean initialized = false;
    
    @SyncField(SyncType.GUI_TICK)
    public final SimpleFluidStorage fluidStorage = new SimpleFluidStorage(4 * FluidStackHooks.bucketAmount(), this::method_5431);
    
    public CoolerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.COOLER_ENTITY, pos, state, Oritech.CONFIG.processingMachines.coolerData.energyPerTick());
    }
    
    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        super.serverTick(world, pos, state, blockEntity);
        
        if (!initialized) {
            initialized = true;
            var biome = world.method_23753(pos);
            inColdArea = biome.method_40220(TagContent.CONVENTIONAL_COLD);
        }
        
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        fluidStorage.writeNbt(nbt, "");
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        fluidStorage.readNbt(nbt, "");
    }
    
    @Override
    protected void useEnergy() {
        super.useEnergy();
        
        var progress = getProgress();
        if (progress < 0.35 || progress > 0.65) return;
        
        if (field_11863.field_9229.method_43057() > 0.4) return;
        // emit particles
        var emitPosition = class_243.method_24953(field_11867);
        
        ParticleContent.COOLER_WORKING.spawn(field_11863, emitPosition, 2);
        
    }
    
    @Override
    protected Optional<class_8786<OritechRecipe>> getRecipe() {
        
        // get recipes matching input items
        var candidates = Objects.requireNonNull(field_11863).method_8433().method_17877(getOwnRecipeType(), getInputInventory(), field_11863);
        // filter out recipes based on input tank
        var fluidRecipe = candidates.stream().filter(candidate -> CentrifugeBlockEntity.recipeInputMatchesTank(fluidStorage.getStack(), candidate.comp_1933())).findAny();
        if (fluidRecipe.isPresent()) {
            return fluidRecipe;
        }
        
        return super.getRecipe();
    }
    
    @Override
    protected void craftItem(OritechRecipe activeRecipe, List<class_1799> outputInventory, List<class_1799> inputInventory) {
        
        if (!processCraftInstance(activeRecipe)) return;
        
        if (supportExtraChambersAuto()) {
            var chamberCount = getBaseAddonData().extraChambers();
            
            // remove extra fluid if more chambers are active
            for (int i = 0; i < chamberCount; i++) {
                if (!processCraftInstance(activeRecipe)) break;
            }
        }
        
    }
    
    // returns true if crafting has been successful
    @SuppressWarnings("BooleanMethodIsAlwaysInverted")
    private boolean processCraftInstance(OritechRecipe activeRecipe) {
        
        var results = getCraftingResults(activeRecipe);
        if (results.isEmpty()) return false;
        var result = results.getFirst();
        
        // try removing input fluid if output item would fit
        if (inventory.heldStacks.getFirst().method_7947() + result.method_7947() > 64) return false;
        
        var input = activeRecipe.getFluidInput();
        var extracted = fluidStorage.extract(fluidStorage.getStack().copyWithAmount(input.amount()), true);
        if (extracted == activeRecipe.getFluidInput().amount()) {
            // fluid is available, and item fits.
            fluidStorage.extract(fluidStorage.getStack().copyWithAmount(input.amount()), false);
            if (inventory.heldStacks.getFirst().method_7960()) {
                inventory.heldStacks.set(0, result.method_7972());
            } else {
                inventory.heldStacks.getFirst().method_7933(result.method_7947());
            }
            
            return true;
        }
        
        return false;
    }
    
    @Override
    public float getSpeedMultiplier() {
        var biomeBonus = inColdArea ? 0.5f : 1f;
        return super.getSpeedMultiplier() * biomeBonus;
    }
    
    @Override
    public float getEfficiencyMultiplier() {
        var biomeBonus = inColdArea ? 0.5f : 1f;
        return super.getEfficiencyMultiplier() * biomeBonus;
    }
    
    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.coolerData.energyCapacity();
    }
    
    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.coolerData.maxEnergyInsertion();
    }
    
    @Override
    protected OritechRecipeType getOwnRecipeType() {
        return RecipeContent.COOLER;
    }
    
    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 0, 0, 1);
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(
          new GuiSlot(0, 117, 36, true));
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.COOLER_SCREEN;
    }
    
    @Override
    public int getInventorySize() {
        return 1;
    }
    
    @Override
    public List<class_2382> getCorePositions() {
        return List.of(
          new class_2382(0, 0, -1)
        );
    }
    
    @Override
    public List<class_2382> getAddonSlots() {
        
        return List.of(
          new class_2382(0, 0, -2)
        );
    }
    
    @Override
    public FluidApi.FluidStorage getFluidStorage(@Nullable class_2350 direction) {
        return fluidStorage;
    }
}
