package rearth.oritech.block.base.entity;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DelegatingEnergyStorage;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.energy.containers.DynamicStatisticEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.blocks.storage.SmallStorageBlock;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.ItemContent;
import rearth.oritech.util.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_7225;

public abstract class ExpandableEnergyStorageBlockEntity extends NetworkedBlockEntity implements EnergyApi.BlockProvider, ItemApi.BlockProvider, MachineAddonController,
                                                                                          ScreenProvider, ExtendedMenuProvider {
    
    @SyncField(SyncType.GUI_OPEN)
    private final List<class_2338> connectedAddons = new ArrayList<>();
    @SyncField(SyncType.GUI_OPEN)
    private final List<class_2338> openSlots = new ArrayList<>();
    @SyncField(SyncType.GUI_OPEN)
    private BaseAddonData addonData = BaseAddonData.DEFAULT_ADDON_DATA;
    
    @SyncField(SyncType.GUI_TICK)
    private boolean redstonePowered;
    
    @SyncField(SyncType.GUI_TICK)
    public DynamicStatisticEnergyStorage.EnergyStatistics currentStats;
    
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(1, this::method_5431);
    
    //own storage
    @SyncField(SyncType.GUI_TICK)
    public final DynamicStatisticEnergyStorage energyStorage = new DynamicStatisticEnergyStorage(getDefaultCapacity(), getDefaultInsertRate(), getDefaultExtractionRate(), this::method_5431);
    
    private final EnergyApi.EnergyStorage outputStorage = new DelegatingEnergyStorage(energyStorage, null) {
        @Override
        public boolean supportsInsertion() {
            return false;
        }
        
        @Override
        public long insert(long amount, boolean simulate) {
            return 0L;
        }
    };
    
    private final EnergyApi.EnergyStorage inputStorage = new DelegatingEnergyStorage(energyStorage, null) {
        @Override
        public boolean supportsExtraction() {
            return false;
        }
        
        @Override
        public long extract(long amount, boolean simulate) {
            return 0L;
        }
    };
    
    public ExpandableEnergyStorageBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }
    
    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
        if (world.field_9236) return;
        
        energyStorage.tick((int) world.method_8510());
        
        if (!redstonePowered)
            outputEnergy();
        
        inputFromCrystal();
    }
    
    private void inputFromCrystal() {
        if (energyStorage.amount >= energyStorage.capacity || inventory.method_5442()) return;
        
        if (!inventory.method_5438(0).method_7909().equals(ItemContent.OVERCHARGED_CRYSTAL)) return;
        
        energyStorage.amount = Math.min(energyStorage.capacity, energyStorage.amount + Oritech.CONFIG.overchargedCrystalChargeRate());
    }
    
    private void outputEnergy() {
        if (energyStorage.amount <= 0) return;
        
        chargeItems();
        
        // todo caching for targets? Used to be BlockApiCache.create()
        var target = getOutputPosition(field_11867, getFacing());
        var candidate = EnergyApi.BLOCK.find(field_11863, target.method_15441(), target.method_15442().method_10153());
        if (candidate != null && candidate.supportsInsertion()) {
            EnergyApi.transfer(energyStorage, candidate, Long.MAX_VALUE, false);
        }
    }
    
    private void chargeItems() {
        
        var heldStack = inventory.heldStacks.get(0);
        if (heldStack.method_7960() || heldStack.method_7947() > 1) return;
        
        var stackRef = new StackContext(heldStack, updated -> inventory.heldStacks.set(0, updated));
        var slotEnergyContainer = EnergyApi.ITEM.find(stackRef);
        if (slotEnergyContainer != null) {
            EnergyApi.transfer(energyStorage, slotEnergyContainer, Long.MAX_VALUE, false);
        }
    }
    
    public static class_3545<class_2350, class_2338> getOutputPosition(class_2338 pos, class_2350 facing) {
        var blockInFront = (class_2338) Geometry.offsetToWorldPosition(facing, new class_2382(-1, 0, 0), pos);
        var worldOffset = blockInFront.method_10059(pos);
        var direction = class_2350.method_50026(worldOffset.method_10263(), worldOffset.method_10264(), worldOffset.method_10260());
        
        return new class_3545<>(direction, blockInFront);
    }
    
    @Override
    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        writeAddonToNbt(nbt);
        nbt.method_10544("energy_stored", energyStorage.amount);
        class_1262.method_5427(nbt, inventory.heldStacks, false, registryLookup);
        nbt.method_10556("redstone", redstonePowered);
    }
    
    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        loadAddonNbtData(nbt);
        updateEnergyContainer();
        energyStorage.amount = nbt.method_10537("energy_stored");
        class_1262.method_5429(nbt, inventory.heldStacks, registryLookup);
        redstonePowered = nbt.method_10577("redstone");
    }
    
    @Override
    public void preNetworkUpdate(SyncType type) {
        super.preNetworkUpdate(type);
        currentStats = energyStorage.getCurrentStatistics(field_11863.method_8510());
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return inventory;
    }
    
    public class_2350 getFacing() {
        return method_11010().method_11654(SmallStorageBlock.TARGET_DIR);
    }
    
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        
        if (direction == null)
            return energyStorage;
        
        if (direction.equals(getFacing())) {
            return outputStorage;
        } else {
            return inputStorage;
        }
    }
    
    @Override
    public List<class_2338> getConnectedAddons() {
        return connectedAddons;
    }
    
    @Override
    public List<class_2338> getOpenAddonSlots() {
        return openSlots;
    }
    
    @Override
    public class_2350 getFacingForAddon() {
        var facing = Objects.requireNonNull(field_11863).method_8320(method_11016()).method_11654(SmallStorageBlock.TARGET_DIR);
        
        if (facing.equals(class_2350.field_11036) || facing.equals(class_2350.field_11033))
            return class_2350.field_11043;
        
        return facing;
    }
    
    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return energyStorage;
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryForAddon() {
        return inventory;
    }
    
    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }
    
    @Override
    public BaseAddonData getBaseAddonData() {
        return addonData;
    }
    
    @Override
    public void setBaseAddonData(BaseAddonData data) {
        this.addonData = data;
    }
    
    @Override
    public void updateEnergyContainer() {
        MachineAddonController.super.updateEnergyContainer();
        energyStorage.maxExtract = getDefaultExtractionRate() + addonData.energyBonusTransfer();
        
    }
    
    @Override
    public float getDisplayedEnergyTransfer() {
        return energyStorage.maxInsert;
    }
    
    public abstract long getDefaultExtractionRate();
    
    @Override
    public void saveExtraData(class_2540 buf) {
        sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(field_11867);
    }
    
    @Override
    public class_2561 method_5476() {
        return class_2561.method_43470("");
    }
    
    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new UpgradableMachineScreenHandler(syncId, playerInventory, this);
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(new GuiSlot(0, 30, 42));
    }
    
    @Override
    public float getDisplayedEnergyUsage() {
        return 0;
    }
    
    @Override
    public float getProgress() {
        return 0;
    }
    
    
    @Override
    public class_2338 getPosForAddon() {
        return method_11016();
    }
    
    @Override
    public class_1937 getWorldForAddon() {
        return method_10997();
    }
    
    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }
    
    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }
    
    @Override
    public class_1263 getDisplayedInventory() {
        return inventory;
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.STORAGE_SCREEN;
    }
    
    @Override
    public boolean showProgress() {
        return false;
    }
    
    @Override
    public class_2769<class_2350> getBlockFacingProperty() {
        return SmallStorageBlock.TARGET_DIR;
    }
    
    public void setRedstonePowered(boolean isPowered) {
        this.redstonePowered = isPowered;
    }
    
    @Override
    public boolean hasRedstoneControlAvailable() {
        return true;
    }
    
    @Override
    public int receivedRedstoneSignal() {
        if (redstonePowered) return 15;
        return field_11863.method_49804(field_11867);
    }
    
    @Override
    public String currentRedstoneEffect() {
        if (receivedRedstoneSignal() > 0) return "tooltip.oritech.redstone_disabled_storage";
        return "tooltip.oritech.redstone_enabled_direct";
    }
}
