package rearth.oritech.item.tools;

import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.block.entity.interaction.DronePortEntity;
import rearth.oritech.block.entity.interaction.LaserArmBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.ComponentContent;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_2246;
import net.minecraft.class_2561;

public class LaserTargetDesignator extends class_1792 {
    public LaserTargetDesignator(class_1793 settings) {
        super(settings);
    }
    
    @Override
    public class_1269 method_7884(class_1838 context) {
        if (context.method_8045().method_8608()) {
            return class_1269.field_5812;
        }
        
        var targetPos = context.method_8037();
        
        var targetBlockState = context.method_8045().method_8320(context.method_8037());
        if (targetBlockState.method_26204() instanceof MachineCoreBlock && targetBlockState.method_11654(MachineCoreBlock.USED)) {
            // target the base instead (on laser arms)
            var machineEntity = MachineCoreBlock.getControllerEntity(context.method_8045(), context.method_8037());
            if (machineEntity instanceof LaserArmBlockEntity) {
                targetPos = context.method_8037().method_10074();
                targetBlockState = context.method_8045().method_8320(targetPos);
            }
        }
        
        if (targetBlockState.method_26204().equals(BlockContent.LASER_ARM_BLOCK)
              && context.method_8045().method_8321(targetPos) instanceof LaserArmBlockEntity laserEntity) {
            
            if (laserEntity.hunterAddons > 0) {
                laserEntity.cycleHunterTargetMode();
                context.method_8036().method_43496(class_2561.method_43469("message.oritech.target_designator.hunter_target", class_2561.method_43471(laserEntity.hunterTargetMode.message)));
                return class_1269.field_5812;
            } else if (context.method_8041().method_57826(ComponentContent.TARGET_POSITION.get())) {
                var target = context.method_8041().method_57824(ComponentContent.TARGET_POSITION.get());

                var success = laserEntity.setTargetFromDesignator(target);
                if (success)
                    context.method_8036().method_43496(class_2561.method_43471("message.oritech.target_designator.position_saved"));
                return success ? class_1269.field_5812 : class_1269.field_5814;
            }
        }
        
        if (targetBlockState.method_26204().equals(BlockContent.DRONE_PORT_BLOCK)
              && context.method_8045().method_8321(context.method_8037()) instanceof DronePortEntity dronePortEntity
              && context.method_8041().method_57826(ComponentContent.TARGET_POSITION.get())) {
            var target = context.method_8041().method_57824(ComponentContent.TARGET_POSITION.get());
            
            var success = dronePortEntity.setTargetFromDesignator(target);
            if (success) {
                context.method_8036().method_43496(class_2561.method_43471("message.oritech.target_designator.position_saved"));
            } else {
                context.method_8036().method_43496(class_2561.method_43471("message.oritech.target_designator.position_invalid"));
            }
            return success ? class_1269.field_5812 : class_1269.field_5814;
        }
        
        if (!targetBlockState.method_26204().equals(class_2246.field_10124)) {
            Oritech.LOGGER.debug(targetBlockState.toString());
            
            context.method_8041().method_57379(ComponentContent.TARGET_POSITION.get(), context.method_8037());
            context.method_8036().method_43496(class_2561.method_43471("message.oritech.target_designator.position_stored"));
            
            return class_1269.field_5812;
        }
        
        return super.method_7884(context);
    }
    
    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        
        if (stack.method_57826(ComponentContent.TARGET_POSITION.get())) {
            var data = stack.method_57824(ComponentContent.TARGET_POSITION.get());
            tooltip.add(class_2561.method_43469("tooltip.oritech.target_designator.set_to", data.method_23854()));
        } else {
            tooltip.add(class_2561.method_43471("tooltip.oritech.target_designator.no_target"));
        }
    }
}
