package rearth.oritech.block.entity.arcane;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.SimpleEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.init.ParticleContent;
import rearth.oritech.client.init.ParticleContent.SoulParticleData;
import rearth.oritech.client.ui.CatalystScreenHandler;
import rearth.oritech.init.BlockEntitiesContent;

import rearth.oritech.init.TagContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.ScreenProvider;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.List;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3917;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9334;

public class EnchantmentCatalystBlockEntity extends BaseSoulCollectionEntity
  implements ItemApi.BlockProvider, EnergyApi.BlockProvider, ScreenProvider, ComparatorOutputProvider, GeoBlockEntity, class_5558<EnchantmentCatalystBlockEntity>, ExtendedMenuProvider {
    
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    public static final RawAnimation STABILIZED = RawAnimation.begin().thenLoop("stabilized");
    public static final RawAnimation UNSTABLE = RawAnimation.begin().thenLoop("unstable");
    public static final RawAnimation EMPTY = RawAnimation.begin().thenLoop("empty");
    
    public final int baseSoulCapacity = Oritech.CONFIG.catalystBaseSouls();
    public final int maxProgress = 20;
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache(this);
    
    // working data
    public int collectedSouls;
    public int maxSouls = Oritech.CONFIG.catalystBaseSouls();
    private int unstableTicks;
    private int progress;
    private boolean isHyperEnchanting;
    private boolean networkDirty;
    private String lastAnimation = "invalid";
    private int lastComparatorOutput;
    
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(2, this::method_5431) {
        @Override
        public int insertToSlot(class_1799 addedStack, int slot, boolean simulate) {
            if (slot == 0 && !addedStack.method_7960() && !addedStack.method_7909().equals(class_1802.field_8598)) return 0; // only allow enchanter books in slot 0
            return super.insertToSlot(addedStack, slot, simulate);
        }
    };
    
    public final SimpleEnergyStorage energyStorage = new SimpleEnergyStorage(10_000, 0, 50_000);
    
    public EnchantmentCatalystBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.ENCHANTMENT_CATALYST_BLOCK_ENTITY, pos, state);
    }
    
    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, EnchantmentCatalystBlockEntity blockEntity) {
        
        if (world.field_9236) return;
        
        // check if powered, and adjust soul capacity
        if (energyStorage.getAmount() > 0) {
            var gainedSoulCapacity = energyStorage.getAmount() / Oritech.CONFIG.catalystRFPerSoul();
            energyStorage.setAmount(0);
            var newMax = baseSoulCapacity + gainedSoulCapacity;
            adjustMaxSouls(newMax);
            this.method_5431();
        } else if (maxSouls > baseSoulCapacity) {
            adjustMaxSouls(baseSoulCapacity);
        }
        
        // explode if unstable
        if (collectedSouls > maxSouls) {
            unstableTicks++;
            
            ParticleContent.MELTDOWN_IMMINENT.spawn(world, pos.method_46558(), unstableTicks / 4);
            
            if (unstableTicks > 60)
                doExplosion();
            return;
        }
        
        unstableTicks = 0;
        
        // check if output is empty
        // check if a book is in slot 0
        // check if an item is in slot 1
        if (canProceed()) {
            networkDirty = true;
            progress++;
            
            ParticleContent.SOUL_USED.spawn(world, pos.method_46558().method_1031(0, 0.3, 0), isHyperEnchanting ? 15 : 3);
            
            if (progress >= maxProgress) {
                enchantInput();
                ParticleContent.ASSEMBLER_WORKING.spawn(world, pos.method_46558(), maxProgress + 10);
                
                progress = 0;
                isHyperEnchanting = false;
            }
        } else {
            progress = 0;
        }
        
        if (networkDirty) {
            networkDirty = false;
            updateNetwork();
            DeathListener.resetEvents();
            updateAnimation();
            
            var level = calculateComparatorLevel();
            if (level != lastComparatorOutput) {
                lastComparatorOutput = level;
                world.method_8455(pos, state.method_26204());
            }
            
        }
        
        // periodically re-trigger animation updates
        if (world.method_8510() % 60 == 0) {
            lastAnimation = "invalid";
            updateAnimation();
        }
        
    }
    
    private boolean isEmpty() {
        return collectedSouls <= 0;
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427(nbt, inventory.heldStacks, false, registryLookup);
        nbt.method_10569("souls", collectedSouls);
        nbt.method_10569("maxSouls", maxSouls);
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429(nbt, inventory.heldStacks, registryLookup);
        collectedSouls = nbt.method_10550("souls");
        maxSouls = nbt.method_10550("maxSouls");
    }
    
    private void doExplosion() {
        
        var center = field_11867.method_46558();
        var strength = Math.sqrt(collectedSouls - baseSoulCapacity);
        
        field_11863.method_8537(null, center.field_1352, center.field_1351, center.field_1350, (int) strength, true, class_1937.class_7867.field_40889);
        field_11863.method_8650(field_11867, false);
    }
    
    private void adjustMaxSouls(long target) {
        if (maxSouls > target) {
            maxSouls--;
        } else if (maxSouls < target) {
            maxSouls++;
        }
        
        this.networkDirty = true;
        this.method_5431();
    }
    
    private void enchantInput() {
        
        var bookCandidate = inventory.method_5438(0);
        if (!bookCandidate.method_7909().equals(class_1802.field_8598) || !bookCandidate.method_57826(class_9334.field_49643))
            return;
        
        var enchantment = bookCandidate.method_57824(class_9334.field_49643).method_57534().stream().findFirst().get();
        
        var inputStack = inventory.method_5438(1);
        var toolLevel = inputStack.method_58657().method_57536(enchantment);
        inputStack.method_7978(enchantment, toolLevel + 1);
        
        collectedSouls -= getEnchantmentCost(enchantment.comp_349(), toolLevel + 1, isHyperEnchanting);
        
        if (isHyperEnchanting)
            inventory.method_5447(0, class_1799.field_8037);
        
    }
    
    private boolean hasEnoughSouls(class_1887 enchantment, int targetLevel) {
        var resultingCost = getEnchantmentCost(enchantment, targetLevel, isHyperEnchanting);
        return collectedSouls >= resultingCost;
    }
    
    private int getEnchantmentCost(class_1887 enchantment, int targetLevel, boolean hyper) {
        var baseCost = enchantment.method_58446();
        var resultingCost = baseCost * targetLevel * Oritech.CONFIG.catalystCostMultiplier();
        if (hyper) resultingCost = (int) (Math.pow(resultingCost * Oritech.CONFIG.catalystHyperMultiplier(), Oritech.CONFIG.catalystHyperExpFactor()) + Oritech.CONFIG.catalystBaseSouls());
        return resultingCost;
    }
    
    // for UI
    public int getDisplayedCost() {
        if (inventory.method_5438(0).method_7960() || inventory.method_5438(1).method_7960()) return 0;
        var bookCandidate = inventory.method_5438(0);
        
        if (bookCandidate.method_7909().equals(class_1802.field_8598) && bookCandidate.method_57826(class_9334.field_49643)) {
            
            var enchantment = bookCandidate.method_57824(class_9334.field_49643).method_57534().stream().findFirst().get();
            var maxLevel = enchantment.comp_349().method_8183();
            var bookLevel = bookCandidate.method_57824(class_9334.field_49643).method_57536(enchantment);
            
            if (bookLevel != maxLevel) return 0;
            
            var inputStack = inventory.method_5438(1);
            var toolLevel = inputStack.method_58657().method_57536(enchantment);
            var isHyper = toolLevel >= maxLevel;
            
            return getEnchantmentCost(enchantment.comp_349(), toolLevel + 1, isHyper);
        }
        
        return 0;
    }
    
    private boolean canProceed() {
        
        if (inventory.method_5438(0).method_7960() || inventory.method_5438(1).method_7960()) return false;
        
        var bookCandidate = inventory.method_5438(0);
        if (bookCandidate.method_7909().equals(class_1802.field_8598) && bookCandidate.method_57826(class_9334.field_49643)) {
            
            var enchantment = bookCandidate.method_57824(class_9334.field_49643).method_57534().stream().findFirst().get();
            var maxLevel = enchantment.comp_349().method_8183();
            var level = bookCandidate.method_57824(class_9334.field_49643).method_57536(enchantment);
            
            if (enchantment.method_40220(TagContent.CATALYST_ENCHANTMENT_BLACKLIST)) return false;
            
            // yes this does not check if the item can be enchanted with this enchantment. This is intentional, allowing you to skip the normal limitations
            var inputStack = inventory.method_5438(1);
            var toolLevel = inputStack.method_58657().method_57536(enchantment);
            this.isHyperEnchanting = toolLevel >= maxLevel;
            
            return level == maxLevel && hasEnoughSouls(enchantment.comp_349(), toolLevel + 1);
        }
        
        return false;
    }
    
    @Override
    public void onSoulIncoming(class_243 source) {
        var distance = (float) source.method_1022(field_11867.method_46558());
        collectedSouls++;
        networkDirty = true;
        this.method_5431();
        
        var soulPath = field_11867.method_46558().method_1020(source);
        var animData = new ParticleContent.SoulParticleData(soulPath, (int) getSoulTravelDuration(distance));
        
        ParticleContent.WANDERING_SOUL.spawn(field_11863, source.method_1031(0, 0.7f, 0), animData);
    }
    
    @Override
    public boolean canAcceptSoul() {
        return collectedSouls < maxSouls;
    }

    @Override
    public int getComparatorOutput() {
        return calculateComparatorLevel();
    }
    
    private int calculateComparatorLevel() {
        return (int) ((float) collectedSouls / maxSouls * 16);
    }
    
    private void updateNetwork() {
        NetworkManager.sendBlockHandle(this, new CatalystSyncPacket(field_11867, collectedSouls, progress, isHyperEnchanting, maxSouls));
    }
    
    @Override
    public void saveExtraData(class_2540 buf) {
        buf.method_10807(field_11867);
    }
    
    @Override
    public class_2561 method_5476() {
        return class_2561.method_43470("");
    }
    
    @Override
    public boolean showProgress() {
        return false;
    }
    
    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        updateNetwork();
        return new CatalystScreenHandler(syncId, playerInventory, this);
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return inventory;
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return energyStorage;
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(
          new GuiSlot(0, 56, 35),
          new GuiSlot(1, 75, 35));
    }
    
    @Override
    public BarConfiguration getEnergyConfiguration() {
        return new BarConfiguration(7, 7, 18, 71);
    }
    
    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<>(this, "machine", 4, state -> {
            if (state.getController().getAnimationState().equals(AnimationController.State.STOPPED))
                return state.setAndContinue(EMPTY);
            return PlayState.CONTINUE;
        })
                          .triggerableAnim("stabilized", STABILIZED)
                          .triggerableAnim("idle", IDLE)
                          .triggerableAnim("unstable", UNSTABLE)
                          .triggerableAnim("empty", EMPTY)
                          .setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler<>()));
    }
    
    private void updateAnimation() {
        
        var targetAnim = isEmpty() ? "empty" : "idle";
        if (maxSouls > baseSoulCapacity)
            targetAnim = "stabilized";
        
        if (unstableTicks > 0)
            targetAnim = "unstable";
        
        if (!targetAnim.equals(lastAnimation)) {
            triggerAnim("machine", targetAnim);
            lastAnimation = targetAnim;
        }
        
    }
    
    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return animatableInstanceCache;
    }
    
    @Override
    public float getDisplayedEnergyUsage() {
        return 0;
    }
    
    @Override
    public float getProgress() {
        return progress / (float) maxProgress;
    }
    
    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }
    
    @Override
    public class_1263 getDisplayedInventory() {
        return inventory;
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.CATALYST_SCREEN;
    }
    
    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }
    
    // this is used as soul display instead
    @Override
    public boolean showEnergy() {
        return true;
    }
    
    public static void receiveUpdatePacket(CatalystSyncPacket packet, class_1937 world, class_5455 dynamicRegistryManager) {
        if (world.method_8321(packet.position) instanceof EnchantmentCatalystBlockEntity catalystBlock) {
            catalystBlock.isHyperEnchanting = packet.isHyperEnchanting();
            catalystBlock.progress = packet.progress();
            catalystBlock.collectedSouls = packet.storedSouls();
            catalystBlock.maxSouls = packet.maxSouls();
        }
    }
    
    public record CatalystSyncPacket(class_2338 position, int storedSouls, int progress, boolean isHyperEnchanting, int maxSouls) implements class_8710 {
        
        public static final class_8710.class_9154<CatalystSyncPacket> PACKET_ID = new class_8710.class_9154<>(Oritech.id("catalyst"));
        
        @Override
        public class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}
