package rearth.oritech.block.blocks.storage;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.block.entity.storage.SmallTankEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.StackContext;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import net.minecraft.class_9334;

public class SmallFluidTank extends class_2248 implements class_2343 {
    public static final class_2746 LIT = class_2741.field_12548;
    
    public SmallFluidTank(class_2251 settings) {
        super(settings);
        this.method_9590(this.method_9564().method_11657(LIT, false));
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(LIT);
    }
    
    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }
    
    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SmallTankEntity(pos, state, false);
    }
    
    @Override
    protected boolean method_9498(class_2680 state) {
        return true;
    }
    
    @Override
    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return ((ComparatorOutputProvider) world.method_8321(pos)).getComparatorOutput();
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        
        if (!world.field_9236) {
            var handler = (ExtendedMenuProvider) world.method_8321(pos);
            MenuRegistry.openExtendedMenu((class_3222) player, handler);
            
        }
        
        return class_1269.field_5812;
    }
    
    @Override
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        
        var blockEntity = world.method_8321(pos);
        if (blockEntity instanceof SmallTankEntity tankEntity) {
            var usedStack = stack;
            if (stack.method_7947() > 1) {
                usedStack = stack.method_46651(1);
            }
            var stackRef = new StackContext(usedStack, updated -> {
                if (stack.method_7947() > 1) {
                    stack.method_7934(1);
                    if (!player.method_31548().method_7394(updated)) {
                        player.method_7328(updated, true);
                    }
                } else {
                    player.method_6122(hand, updated);
                }
            });
            
            var candidate = FluidApi.ITEM.find(stackRef);
            if (candidate != null) {
                
                if (!world.field_9236) {
                    if (candidate.getContent().getFirst().isEmpty()) { // from tank to item
                        var moved = FluidApi.transferFirst(tankEntity.fluidStorage, candidate, tankEntity.fluidStorage.getCapacity(), false);
                        Oritech.LOGGER.debug("moved to item {} {}", moved, stackRef.getValue());
                    } else {    // from item to tank
                        var moved = FluidApi.transferFirst(candidate, tankEntity.fluidStorage, tankEntity.fluidStorage.getCapacity(), false);
                        Oritech.LOGGER.debug("moved from item {} {}", moved, stackRef.getValue());
                    }
                }
                
                world.method_45446(pos, class_3417.field_28292, class_3419.field_15248, 0.8f, 1.4f, true);
                
                return class_9062.method_55644(true);
            }
        }
        
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }
    
    @Override
    protected @NotNull List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        var droppedStacks = super.method_9560(state, builder);
        
        var blockEntity = builder.method_51876(class_181.field_1228);
        if (blockEntity instanceof SmallTankEntity tankEntity) {
            droppedStacks.addAll(tankEntity.inventory.getHeldStacks());
            tankEntity.inventory.method_5448();
        }
        
        return droppedStacks;
    }
    
    @Override
    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return getStackWithData(world, pos);
    }
    
    @NotNull
    private static class_1799 getStackWithData(class_4538 world, class_2338 pos) {
        var tankEntity = (SmallTankEntity) world.method_8321(pos);
        var stack = getBasePickStack(tankEntity.isCreative);
        
        if (tankEntity.fluidStorage.getAmount() > 0) {
            var fluidStack = tankEntity.fluidStorage.getStack().copy();
            stack.method_57379(FluidApi.ITEM.getFluidComponent(), fluidStack);
            stack.method_57379(class_9334.field_50071, 1);
        }
        
        return stack;
    }
    
    public static class_1799 getBasePickStack(boolean creative) {
        return new class_1799(creative ? BlockContent.CREATIVE_TANK_BLOCK.method_8389() : BlockContent.SMALL_TANK_BLOCK.method_8389());
    }
    
    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        
        if (itemStack.method_57826(FluidApi.ITEM.getFluidComponent())) {
            var tankEntity = (SmallTankEntity) world.method_8321(pos);
            tankEntity.fluidStorage.setStack(itemStack.method_57824(FluidApi.ITEM.getFluidComponent()).copy());
            tankEntity.method_5431();
        }
    }
    
    @SuppressWarnings({"rawtypes", "unchecked"})
    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof class_5558 ticker)
                ticker.tick(world1, pos, state1, blockEntity);
        };
    }
    
}
