package rearth.oritech.block.blocks.addons;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2746;
import net.minecraft.class_3726;
import net.minecraft.class_437;
import net.minecraft.class_4538;
import net.minecraft.world.level.block.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.base.entity.ItemEnergyFrameInteractionBlockEntity;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.block.entity.addons.EnergyAcceptorAddonBlockEntity;
import rearth.oritech.init.BlockContent;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.TooltipHelper;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;

public class MachineAddonBlock extends class_2341 implements class_2343 {
    
    public static final Boolean USE_ACCURATE_OUTLINES = Oritech.CONFIG.tightMachineAddonHitboxes();
    
    public static final class_2746 ADDON_USED = class_2746.method_11825("addon_used");
    
    protected final AddonSettings addonSettings;
    
    // Bounding shapes for each type of addon, with rotations for all of their facing/face combinations
    // This is intended to work for "needsSupport" addon blocks, which have the FACING and FACE state properties
    // If any block does not have a boundingShape set, this will default to a full cube
    public static class_265[][] MACHINE_ACCEPTOR_ADDON_SHAPE;
    public static class_265[][] MACHINE_CAPACITOR_ADDON_SHAPE;
    public static class_265[][] MACHINE_PROCESSING_ADDON_SHAPE;
    public static class_265[][] CROP_FILTER_ADDON_SHAPE;
    public static class_265[][] MACHINE_EFFICIENCY_ADDON_SHAPE;
    public static class_265[][] MACHINE_FLUID_ADDON_SHAPE;
    public static class_265[][] MACHINE_INVENTORY_PROXY_ADDON_SHAPE;
    public static class_265[][] QUARRY_ADDON_SHAPE;
    public static class_265[][] MACHINE_HUNTER_ADDON_SHAPE;
    public static class_265[][] MACHINE_REDSTONE_ADDON_SHAPE;
    public static class_265[][] MACHINE_SPEED_ADDON_SHAPE;
    public static class_265[][] MACHINE_ULTIMATE_ADDON_SHAPE;
    public static class_265[][] STEAM_BOILER_ADDON_SHAPE;
    public static class_265[][] MACHINE_YIELD_ADDON_SHAPE;
    public static class_265[][] MACHINE_SILK_TOUCH_ADDON_SHAPE;
    public static class_265[][] MACHINE_COMBI_ADDON_SHAPE;
    public static class_265[][] MACHINE_BURST_ADDON_SHAPE;
    
    // because this parameter is needed in appendProperties, but we can't initialize or pass it to that
    private static boolean constructorAssignmentSupportWorkaround = false;
    
    private static class_2251 doConstructorWorkaround(class_2251 settings, boolean needsSupport) {
        constructorAssignmentSupportWorkaround = needsSupport;
        return settings;
    }
    
    public MachineAddonBlock(class_2251 settings, AddonSettings addonSettings) {
        super(doConstructorWorkaround(settings, addonSettings.needsSupport()));
        
        this.addonSettings = addonSettings;
        
        if (addonSettings.needsSupport()) {
            this.method_9590(method_9564()
                                        .method_11657(ADDON_USED, false)
                                        .method_11657(field_11177, class_2350.field_11043)
                                        .method_11657(field_11007, class_2738.field_12475)
            );
        } else {
            this.method_9590(method_9564().method_11657(ADDON_USED, false));
        }
    }
    
    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        
        // search for addon extender or machine at neighbor
        // if addon extender, check if its connected to a machine, if so then init it
        // if machine then init it
        
        if (world.field_9236) return;
        
        for (var direction : class_2350.values()) {
            var checkPos = pos.method_10081(direction.method_10163());
            var checkEntity = world.method_8321(checkPos);
            if (checkEntity instanceof MachineAddonController machineEntity) {
                AddonBlockEntity.pendingInits.add(machineEntity);
                break;
            } else if (checkEntity instanceof ItemEnergyFrameInteractionBlockEntity machineEntity) {
                AddonBlockEntity.pendingInits.add(machineEntity);
                break;
            } else if (checkEntity instanceof MachineCoreEntity machineEntity) {
                if (machineEntity.isEnabled() && machineEntity.getCachedController() instanceof MachineAddonController addonController) {
                    AddonBlockEntity.pendingInits.add(addonController);
                }
                break;
            } else if (checkEntity instanceof AddonBlockEntity addonEntity) {
                var addonState = addonEntity.method_11010();
                var addonConnected = addonState.method_11654(ADDON_USED);
                if (!addonConnected) continue;
                var controllerPos = addonEntity.getControllerPos();
                if (world.method_8321(controllerPos) instanceof MachineAddonController controllerEntity) {
                    AddonBlockEntity.pendingInits.add(controllerEntity);
                    break;
                }
            }
        }
        
    }
    
    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(ADDON_USED);
        if (constructorAssignmentSupportWorkaround) {
            builder.method_11667(field_11177);
            builder.method_11667(field_11007);
        }
    }
    
    @Override
    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        if (!state.method_28498(field_11177)) return state;
        return super.method_9598(state, rotation);
    }
    
    @Override
    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        if (!state.method_28498(field_11177)) return state;
        return super.method_9569(state, mirror);
    }
    
    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        if (addonSettings.needsSupport)
            return super.method_9605(ctx);
        return method_9564();
    }
    
    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (addonSettings.needsSupport)
            return super.method_9558(state, world, pos);
        return true;
    }
    
    @Override
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        
        if (addonSettings.needsSupport) {
            return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
        } else {
            return state;
        }
    }
    
    @Override
    protected MapCodec<? extends class_2341> method_53969() {
        return null;
    }
    
    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }
    
    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (!USE_ACCURATE_OUTLINES || !addonSettings.needsSupport() || addonSettings.boundingShape() == null)
            return super.method_9530(state, world, pos, context);
        
        return addonSettings.boundingShape()[state.method_11654(field_11177).ordinal()][state.method_11654(field_11007).ordinal()];
    }
    
    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return method_9530(state, world, pos, context);
    }
    
    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        try {
            return getBlockEntityType().getDeclaredConstructor(class_2338.class, class_2680.class).newInstance(pos, state);
        } catch (InstantiationException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            Oritech.LOGGER.error("Unable to create blockEntity for " + getBlockEntityType().getSimpleName() + " at " + this);
            return new AddonBlockEntity(pos, state);
        }
    }
    
    @NotNull
    public Class<? extends class_2586> getBlockEntityType() {
        return addonSettings.acceptEnergy ? EnergyAcceptorAddonBlockEntity.class : AddonBlockEntity.class;
    }
    
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        
        if (!world.method_8608() && state.method_11654(ADDON_USED)) {
            
            var ownEntity = (AddonBlockEntity) world.method_8321(pos);
            
            var controllerEntity = world.method_8321(Objects.requireNonNull(ownEntity).getControllerPos());
            
            if (controllerEntity instanceof MachineAddonController machineEntity) {
                machineEntity.initAddons(pos);
            }
        }
        
        return super.method_9576(world, pos, state, player);
    }
    
    public AddonSettings getAddonSettings() {
        return addonSettings;
    }
    
    @Override
    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        
        var showExtra = class_437.method_25441();
        
        if (showExtra) {
            
            if (addonSettings.speedMultiplier() != 1) {
                var displayedNumber = Math.round((1 - addonSettings.speedMultiplier()) * 100);
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_speed_desc").method_27692(class_124.field_1063)
                              .method_10852(TooltipHelper.getFormattedValueChangeTooltip(displayedNumber)));
            }
            
            if (addonSettings.efficiencyMultiplier() != 1) {
                var displayedNumber = Math.round((1 - addonSettings.efficiencyMultiplier()) * 100);
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_efficiency_desc").method_27692(class_124.field_1063)
                              .method_10852(TooltipHelper.getFormattedValueChangeTooltip(displayedNumber)));
            }
            
            if (addonSettings.addedCapacity() != 0) {
                tooltip.add(
                  class_2561.method_43471("tooltip.oritech.addon_capacity_desc").method_27692(class_124.field_1063)
                    .method_10852(TooltipHelper.getFormattedEnergyChangeTooltip(addonSettings.addedCapacity(), " RF")));
            }
            
            if (addonSettings.addedInsert() != 0) {
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_transfer_desc").method_27692(class_124.field_1063)
                              .method_10852(TooltipHelper.getFormattedEnergyChangeTooltip(addonSettings.addedInsert(), " RF/t")));
            }
            
            var item = (class_1747) stack.method_7909();
            var blockType = item.method_7711();
            
            if (blockType == BlockContent.MACHINE_YIELD_ADDON)
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_yield_desc").method_27692(class_124.field_1080));
            if (blockType == BlockContent.MACHINE_FLUID_ADDON)
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_fluid_desc").method_27692(class_124.field_1080));
            if (blockType == BlockContent.MACHINE_ACCEPTOR_ADDON)
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_acceptor_desc").method_27692(class_124.field_1080));
            if (blockType == BlockContent.STEAM_BOILER_ADDON)
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_boiler_desc").method_27692(class_124.field_1080));
            if (blockType == BlockContent.CROP_FILTER_ADDON)
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_crop_desc").method_27692(class_124.field_1080));
            if (blockType == BlockContent.MACHINE_INVENTORY_PROXY_ADDON)
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_proxy_desc").method_27692(class_124.field_1080));
            if (blockType == BlockContent.QUARRY_ADDON)
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_quarry_desc").method_27692(class_124.field_1080));
            if (blockType == BlockContent.MACHINE_HUNTER_ADDON)
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_hunter_desc").method_27692(class_124.field_1080));
            if (blockType == BlockContent.MACHINE_REDSTONE_ADDON)
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_redstone_desc").method_27692(class_124.field_1080));
            if (blockType == BlockContent.MACHINE_PROCESSING_ADDON)
                tooltip.add(class_2561.method_43471("tooltip.oritech.processing_addon_desc").method_27692(class_124.field_1080));
            if (blockType == BlockContent.MACHINE_SILK_TOUCH_ADDON)
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_silk_touch_desc").method_27692(class_124.field_1080));
            if (blockType == BlockContent.MACHINE_BURST_ADDON)
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_burst_desc").method_27692(class_124.field_1080));
            
            if (addonSettings.extender()) {
                tooltip.add(class_2561.method_43471("tooltip.oritech.addon_extender_desc").method_27692(class_124.field_1080));
            }
            
        } else {
            tooltip.add(class_2561.method_43471("tooltip.oritech.item_extra_info").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        }
        
    }
    
    static {
        MACHINE_ACCEPTOR_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        MACHINE_CAPACITOR_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        MACHINE_PROCESSING_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        MACHINE_ULTIMATE_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        CROP_FILTER_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        MACHINE_EFFICIENCY_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        MACHINE_FLUID_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        MACHINE_INVENTORY_PROXY_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        QUARRY_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        MACHINE_HUNTER_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        MACHINE_REDSTONE_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        MACHINE_SPEED_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        STEAM_BOILER_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        MACHINE_YIELD_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        MACHINE_SILK_TOUCH_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        MACHINE_COMBI_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        MACHINE_BURST_ADDON_SHAPE = new class_265[class_2350.values().length][class_2738.values().length];
        for (var facing : class_2350.values()) {
            if (!facing.method_10166().method_10179()) continue;
            for (var face : class_2738.values()) {
                MACHINE_ACCEPTOR_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.25, 0.625, 0.25, 0.75, 0.75, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0.25, 0.125, 0.875, 0.375, 0.875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0.375, 0.125, 0.875, 0.5, 0.875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0.5, 0.125, 0.875, 0.625, 0.875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0, 0.75, 0, 1, 0.875, 1), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0, 0, 0, 1, 0.125, 1), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0.875, 0.125, 0.875, 1, 0.875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.1875, 0.625, 0.1875, 0.8125, 0.75, 0.8125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.1875, 0.125, 0.1875, 0.8125, 0.25, 0.8125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.3125, 0.0625, 0.0625, 0.6875, 0.8125, 0.1875), facing, face));
                MACHINE_CAPACITOR_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.0625, 0, 0.0625, 0.9375, 0.125, 0.9375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.1875, 0.1875, 0.3125, 0.25, 0.375, 0.6875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.25, 0.125, 0.25, 0.75, 0.4375, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.75, 0.125, 0.1875, 0.8125, 0.5, 0.8125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.5625, 0.4375, 0.25, 0.625, 0.5, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.6875, 0.4375, 0.25, 0.75, 0.5, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.3125, 0.4375, 0.25, 0.375, 0.5, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.4375, 0.25, 0.5, 0.5, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.5625, 0.125, 0.1875, 0.625, 0.5, 0.25), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.6875, 0.125, 0.1875, 0.75, 0.5, 0.25), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.3125, 0.125, 0.1875, 0.375, 0.5, 0.25), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.125, 0.1875, 0.5, 0.5, 0.25), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.25, 0.125, 0.75, 0.75, 0.5, 0.8125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.8125, 0.25, 0.5625, 0.875, 0.4375, 0.6875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.8125, 0.25, 0.3125, 0.875, 0.4375, 0.4375), facing, face));
                CROP_FILTER_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.0625, 0, 0.0625, 0.9375, 0.125, 0.9375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.125, 0.1875, 0.875, 0.25, 0.6875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.25, 0.1875, 0.875, 0.5625, 0.6875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.5625, 0.3125, 0.1875, 0.75, 0.4375, 0.8125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.5625, 0.125, 0.8125, 0.75, 0.4375, 0.9375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0.125, 0.125, 0.375, 0.25, 0.875), facing, face));
                MACHINE_EFFICIENCY_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.25, 0, 0.25, 0.75, 0.125, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.25, 0.125, 0.1875, 0.75, 0.4375, 0.8125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.75, 0.125, 0.125, 0.875, 0.5, 0.875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0.125, 0.125, 0.25, 0.5, 0.875), facing, face));
                MACHINE_PROCESSING_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_1084(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.0625, 0, 0.0625, 0.9375, 0.125, 0.9375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0.25, 0.25, 0.875, 0.75, 0.75), facing, face));
                MACHINE_ULTIMATE_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_1084(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.0625, 0, 0.0625, 0.9375, 0.125, 0.9375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.1875, 0.125, 0.1875, 0.875, 1, 0.75), facing, face));
                MACHINE_FLUID_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.3125, 0.000625, 0.25, 0.6875, 0.125625, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.25, 0.00125, 0.3125, 0.75, 0.12625, 0.6875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.0625, 0.3125, 0.1875, 0.375, 0.625, 0.5625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.5625, 0.3125, 0.1875, 0.9375, 0.625, 0.5625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.3125, 0.5, 0.625, 0.4375, 1, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.3125, 0.375, 0.625, 0.75, 0.5, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.625, 0.375, 0.5, 0.75, 0.5, 0.625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.34375, 0.125, 0.65625, 0.46875, 0.375, 0.71875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.671875, 0.125, 0.625, 0.734375, 0.375, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.1875, 0.125, 0.25, 0.375, 0.3125, 0.5), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.375, 0.375, 0.25, 0.625, 0.5625, 0.5), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.5625, 0.125, 0.25, 0.75, 0.3125, 0.5), facing, face));
                MACHINE_INVENTORY_PROXY_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.0625, 0, 0.0625, 0.9375, 0.125, 0.9375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0.125, 0.125, 0.875, 0.875, 0.875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.875, 0.375, 0.375, 1, 0.625, 0.625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0, 0.375, 0.375, 0.125, 0.625, 0.625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.375, 0.375, 0, 0.625, 0.625, 0.125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.375, 0.375, 0.875, 0.625, 0.625, 1), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.375, 0.8125, 0.375, 0.625, 1, 0.625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0, 0.00125, 0.3125, 1, 0.93875, 0.375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0, 0.00125, 0.625, 1, 0.93875, 0.6875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.3125, 0.000625, 0, 0.375, 0.938125, 1), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.625, 0.000625, 0, 0.6875, 0.938125, 1), facing, face));
                QUARRY_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.0625, 0, 0.0625, 0.9375, 0.125, 0.9375), facing, face), // base
                  Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0.125, 0.125, 0.375, 0.25, 0.875), facing, face), // status bar
                  Geometry.rotateVoxelShape(class_259.method_1081(0.625, 0.125, 0.3125, 0.6875, 0.1875, 0.8125), facing, face), // pickaxe handle
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.125, 0.25, 0.875, 0.1875, 0.4375), facing, face)); // pickaxe head
                MACHINE_HUNTER_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.0625, 0, 0.0625, 0.9375, 0.125, 0.9375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0.125, 0.125, 0.375, 0.25, 0.875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.5, 0.1875, 0.4375, 0.75, 0.25, 0.5625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.125, 0.375, 0.8125, 0.1875, 0.625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.5625, 0.1875, 0.375, 0.6875, 0.25, 0.4375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.5, 0.125, 0.3125, 0.75, 0.1875, 0.375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.5, 0.125, 0.625, 0.75, 0.1875, 0.6875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.5625, 0.1875, 0.5625, 0.6875, 0.25, 0.625), facing, face));
                MACHINE_REDSTONE_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.0625, 0, 0.0625, 0.9375, 0.125, 0.9375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.1875, 0.125, 0, 0.4375, 0.25, 0.8125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.1875, 0, 0.0015625, 0.6875, 0.1875, 0.0640625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.625, 0.125, 0.1875, 0.75, 0.25, 0.3125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.625, 0.125, 0.5, 0.75, 0.25, 0.625), facing, face));
                MACHINE_SPEED_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.25, 0, 0.25, 0.75, 0.125, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.375, 0.125, 0.625, 0.875, 0.25, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.25, 0.125, 0.125, 0.375, 0.25, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.1875, 0.125, 0.25, 0.25, 0.25, 0.375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.1875, 0.125, 0.5, 0.25, 0.25, 0.625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.625, 0.125, 0.75, 0.75, 0.25, 0.8125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.375, 0.125, 0.75, 0.5, 0.25, 0.8125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.375, 0.125, 0.1875, 0.8125, 0.1875, 0.625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.5, 0.1875, 0.3125, 0.6875, 0.625, 0.5), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.1875, 0.375, 0.75, 0.5625, 0.4375), facing, face));
                STEAM_BOILER_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0, 0.125, 0.875, 0.125, 0.875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0.125, 0.3125, 0.25, 0.25, 0.4375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.75, 0.125, 0.3125, 0.875, 0.25, 0.4375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.125, 0.5625, 0.5625, 0.25, 0.6875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.0000625, 0.25, 0.3125, 1.000125, 0.625, 0.6875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0, 0.1875, 0.375, 1, 0.6875, 0.625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.000125, 0.3125, 0.25, 1.00025, 0.5625, 0.75), facing, face));
                MACHINE_YIELD_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.0625, 0, 0.0625, 0.9375, 0.125, 0.9375), facing, face), // base
                  Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0.125, 0.125, 0.25, 0.375, 0.875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.75, 0.125, 0.125, 0.875, 0.375, 0.875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.25, 0.125, 0.125, 0.75, 0.375, 0.25), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.3125, 0.125, 0.3125, 0.6875, 0.25, 0.8125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.0625, 0.125, 0.5625, 0.3125, 0.4375, 0.6875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.6875, 0.125, 0.5625, 0.9375, 0.4375, 0.6875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.0625, 0.125, 0.3125, 0.3125, 0.4375, 0.4375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.6875, 0.125, 0.3125, 0.9375, 0.4375, 0.4375), facing, face));
                MACHINE_SILK_TOUCH_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.0625, 0, 0.0625, 0.9375, 0.125, 0.9375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.125, 0.125, 0.125, 0.375, 0.25, 0.875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.625, 0.1875, 0.3125, 0.6875, 0.25, 0.8125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.1875, 0.25, 0.875, 0.25, 0.4375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.125, 0.1875, 0.875, 0.1875, 0.875), facing, face)
                );
                MACHINE_COMBI_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.3125, -0.0015625, 0.25, 0.6875, 0.1234375, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.25, 0, 0.3125, 0.75, 0.125, 0.6875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.3125, 0.4375, 0.3125, 0.6875, 0.8125, 0.6875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.11875, 0.38125, 0.4375, 0.24375, 0.56875, 0.5625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.1875, 0.275, 0.438125, 0.3125, 0.4625, 0.563125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.25, 0.25, 0.4375, 0.75, 0.375, 0.5625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.2484375, 0.25, 0.5625, 0.3734375, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.3796875, 0.1171875, 0.5625, 0.5671875, 0.2421875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.438125, 0.2640625, 0.165625, 0.563125, 0.4515625, 0.290625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.438125, 0.2640625, 0.709375, 0.563125, 0.4515625, 0.834375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.3796875, 0.7578125, 0.5625, 0.5671875, 0.8828125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.759375, 0.38125, 0.4375, 0.884375, 0.56875, 0.5625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.6875, 0.275, 0.438125, 0.8125, 0.4625, 0.563125), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.125, 0.4375, 0.5625, 0.25, 0.5625), facing, face)
                );
                MACHINE_BURST_ADDON_SHAPE[facing.ordinal()][face.ordinal()] = class_259.method_17786(
                  Geometry.rotateVoxelShape(class_259.method_1081(0.25, 0, 0.3125, 0.75, 0.125, 0.6875), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.3125, -0.0015625, 0.25, 0.6875, 0.1234375, 0.75), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.315625, 0.4375, 0.315625, 0.6859375, 0.5, 0.684375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.315625, 0.21875, 0.315625, 0.6859375, 0.28125, 0.684375), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.375, 0.0625, 0.375, 0.625, 0.625, 0.625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.25, 0.125, 0.4375, 0.75, 0.5625, 0.5625), facing, face),
                  Geometry.rotateVoxelShape(class_259.method_1081(0.4375, 0.125, 0.25, 0.5625, 0.5625, 0.75), facing, face)
                );
            }
        }
    }
    
    // AddonSettings is an immutable configuration record for a machine addon, and should be constructed in BlockContent
    public record AddonSettings(boolean extender, float speedMultiplier, float efficiencyMultiplier, long addedCapacity,
                                long addedInsert, boolean acceptEnergy, boolean needsSupport, int chamberCount, int burstTicks,
                                class_265[][] boundingShape) {
        
        public static AddonSettings getDefaultSettings() {
            return new AddonSettings(false, 1.0f, 1.0f, 0, 0, false, true, 0, 0, null);
        }
        
        // extender and needsSupport aren't strictly exclusive, but are unlikely to be used together
        public AddonSettings withExtender(boolean newExtender) {
            return new AddonSettings(newExtender, speedMultiplier, efficiencyMultiplier, addedCapacity, addedInsert, acceptEnergy, needsSupport, chamberCount, burstTicks, boundingShape);
        }
        
        public AddonSettings withSpeedMultiplier(float newMultiplier) {
            return new AddonSettings(extender, newMultiplier, efficiencyMultiplier, addedCapacity, addedInsert, acceptEnergy, needsSupport, chamberCount, burstTicks, boundingShape);
        }
        
        public AddonSettings withEfficiencyMultiplier(float newMultiplier) {
            return new AddonSettings(extender, speedMultiplier, newMultiplier, addedCapacity, addedInsert, acceptEnergy, needsSupport, chamberCount, burstTicks, boundingShape);
        }
        
        public AddonSettings withAddedCapacity(long newCapacity) {
            return new AddonSettings(extender, speedMultiplier, efficiencyMultiplier, newCapacity, addedInsert, acceptEnergy, needsSupport, chamberCount, burstTicks, boundingShape);
        }
        
        public AddonSettings withAddedInsert(long newInsert) {
            return new AddonSettings(extender, speedMultiplier, efficiencyMultiplier, addedCapacity, newInsert, acceptEnergy, needsSupport, chamberCount, burstTicks, boundingShape);
        }
        
        public AddonSettings withAcceptEnergy(boolean newAccept) {
            return new AddonSettings(extender, speedMultiplier, efficiencyMultiplier, addedCapacity, addedInsert, newAccept, needsSupport, chamberCount, burstTicks, boundingShape);
        }
        
        public AddonSettings withNeedsSupport(boolean newSupport) {
            return new AddonSettings(extender, speedMultiplier, efficiencyMultiplier, addedCapacity, addedInsert, acceptEnergy, newSupport, chamberCount, burstTicks, boundingShape);
        }
        
        public AddonSettings withChambers(int chambers) {
            return new AddonSettings(extender, speedMultiplier, efficiencyMultiplier, addedCapacity, addedInsert, acceptEnergy, needsSupport, chambers, burstTicks, boundingShape);
        }
        
        public AddonSettings withBurstTicks(int newTicks) {
            return new AddonSettings(extender, speedMultiplier, efficiencyMultiplier, addedCapacity, addedInsert, acceptEnergy, needsSupport, chamberCount, newTicks, boundingShape);
        }
        
        // boundingShape should only be set if needsSupport is also set
        public AddonSettings withBoundingShape(class_265[][] newShape) {
            return new AddonSettings(extender, speedMultiplier, efficiencyMultiplier, addedCapacity, addedInsert, acceptEnergy, needsSupport, chamberCount, burstTicks, newShape);
        }
    }
}
