package rearth.oritech.api.recipe;

import com.google.common.base.Optional;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import rearth.oritech.Oritech;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.util.FluidIngredient;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_8790;

public abstract class OritechRecipeBuilder {

    protected final OritechRecipeType type;
    protected List<class_1856> inputs;
    protected List<class_1799> results;
    protected FluidIngredient fluidInput;
    protected List<FluidStack> fluidOutputs;
    protected int time = 200;
    protected float timeMultiplier = 1f;
    protected boolean addToGrinder;
    private final String resourcePath;

    protected OritechRecipeBuilder(OritechRecipeType type, String resourcePath) {
        this.type = type;
        this.resourcePath = resourcePath;
        this.fluidOutputs = new ArrayList<>();
    }

    public OritechRecipeBuilder input(List<class_1856> in) {
        if (inputs == null)
            inputs = new ArrayList<>();
        inputs.addAll(in);
        return this;
    }

    public OritechRecipeBuilder input(class_1856 in) {
        if (inputs == null)
            inputs = new ArrayList<>();
        inputs.add(in);
        return this;
    }

    public OritechRecipeBuilder input(class_1935 in) {
        return input(class_1856.method_8091(in));
    }

    public OritechRecipeBuilder input(class_6862<class_1792> in) {
        return input(class_1856.method_8106(in));
    }

    public OritechRecipeBuilder fluidInput(FluidIngredient in) {
        fluidInput = in;
        return this;
    }
    
    public OritechRecipeBuilder fluidInput(class_3611 in, float bucketAmount) {
        return fluidInput(new FluidIngredient().withContent(in).withAmount(bucketAmount));
    }
    
    public OritechRecipeBuilder specificFluidInput(class_3611 in, long amountMillis) {
        return fluidInput(new FluidIngredient().withContent(in).withSpecificAmount(amountMillis));
    }

    public OritechRecipeBuilder fluidInput(class_3611 in) {
        return fluidInput(in, 1.0f);
    }

    public OritechRecipeBuilder fluidInput(class_6862<class_3611> in) {
        return fluidInput(in, 1.0f);
    }

    public OritechRecipeBuilder fluidInput(class_6862<class_3611> in, float bucketAmount)  {
        return fluidInput(new FluidIngredient().withContent(in).withAmount(bucketAmount));
    }

    public OritechRecipeBuilder fluidOutput(FluidStack out) {
        fluidOutputs.add(out);
        return this;
    }

    public OritechRecipeBuilder fluidOutput(class_3611 out, float bucketAmount) {
        return fluidOutput(FluidStack.create(out, (long)(bucketAmount * FluidStackHooks.bucketAmount())));
    }

    public OritechRecipeBuilder fluidOutput(class_3611 out) {
        return fluidOutput(FluidStack.create(out, FluidStackHooks.bucketAmount()));
    }

    public OritechRecipeBuilder result(class_1799 out) {
        if (results == null)
            results = new ArrayList<>();
        results.add(out);
        return this;
    }

    public OritechRecipeBuilder result(List<class_1799> out) {
        if (results == null)
            results = new ArrayList<>();
        results.addAll(out);
        return this;
    }

    public OritechRecipeBuilder result(class_1792 out, int count) {

        return result(new class_1799(out, count));
    }

    public OritechRecipeBuilder result(class_1792 out) {
        return result(out, 1);
    }

    public OritechRecipeBuilder result(Optional<class_1792> out, int count) {
        if (out.isPresent())
            return result(out.get(), count);
        return this;
    }

    public OritechRecipeBuilder result(Optional<class_1792> out) {
        return result(out, 1);
    }

    public OritechRecipeBuilder time(int time) {
        this.time = time;
        return this;
    }

    public OritechRecipeBuilder timeInSeconds(int time) {
        return time(time * 20);
    }

    public OritechRecipeBuilder timeMultiplier(float timeMultiplier) {
        this.timeMultiplier = timeMultiplier;
        return this;
    }

    public OritechRecipeBuilder addToGrinder() {
        this.addToGrinder = true;
        return this;
    }

    public abstract void validate(class_2960 id) throws IllegalStateException;

    public void export(class_8790 exporter, String suffix, String namespace) {
        
        var id = class_2960.method_60655(namespace, resourcePath + "/" + suffix);
        validate(id);
        
        exporter.method_53819(
          id,
          new OritechRecipe(
            (int)(time * timeMultiplier),
            inputs != null ? inputs : List.of(),
            results != null ? results : List.of(),
            type,
            fluidInput != null ? fluidInput : FluidIngredient.EMPTY,
            fluidOutputs != null ? fluidOutputs : List.of()),
          null);
    }
    
    
    public void export(class_8790 exporter, String suffix) {
        export(exporter, suffix, Oritech.MOD_ID);
    }
}