package rearth.oritech.client.ui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ReactorBlockRenderComponent extends BaseComponent {
    
    private final class_310 client = class_310.method_1551();
    
    public class_2680 state;
    private final @Nullable class_2586 entity;
    public float zIndex;
    public class_2338 pos;
    
    public ReactorBlockRenderComponent(@Nullable class_2680 state, @Nullable class_2586 entity, float zIndex, class_2338 pos) {
        this.state = state;
        this.entity = entity;
        this.zIndex = zIndex;
        this.pos = pos;
    }
    
    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        
        var usedState = this.state == null ? client.field_1687.method_8320(pos) : state;
        
        context.method_51448().method_22903();
        
        context.method_51448().method_46416(x + this.width / 2f, y + this.height / 2f, zIndex * 25 + 1000);
        context.method_51448().method_22905(40 * this.width / 64f, -40 * this.height / 64f, 40);
        
        context.method_51448().method_22907(class_7833.field_40714.rotationDegrees(30));
        context.method_51448().method_22907(class_7833.field_40716.rotationDegrees(45 + 180));
        
        context.method_51448().method_22904(-.5, -.5, -.5);
        
        RenderSystem.runAsFancy(() -> {
            final var vertexConsumers = client.method_22940().method_23000();
            if (usedState.method_26217() != class_2464.field_11456) {
                this.client.method_1541().method_3353(
                  usedState, context.method_51448(), vertexConsumers,
                  class_765.field_32767, class_4608.field_21444
                );
            }
            
            if (this.entity != null) {
                var renderer = this.client.method_31975().method_3550(this.entity);
                if (renderer != null) {
                    renderer.method_3569(entity, partialTicks, context.method_51448(), vertexConsumers, class_765.field_32767, class_4608.field_21444);
                }
            }
            
            RenderSystem.setShaderLights(new Vector3f(-1.5f, -.5f, 0), new Vector3f(0, -1, 0));
            vertexConsumers.method_22993();
            class_308.method_24211();
        });
        
        context.method_51448().method_22909();
    }
}
