package rearth.oritech.block.entity.interaction;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.core.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.api.item.containers.SimpleInventoryStorage;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.api.networking.NetworkedBlockEntity;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MachineBlockEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.UpgradableMachineScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.util.*;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static rearth.oritech.block.base.block.MultiblockMachine.ASSEMBLED;
import static rearth.oritech.block.base.entity.MachineBlockEntity.*;

public class ShrinkerBlockEntity extends NetworkedBlockEntity implements ItemApi.BlockProvider, EnergyApi.BlockProvider, GeoBlockEntity, ExtendedMenuProvider,
                                                                           ScreenProvider, MultiblockMachineController, MachineAddonController {
    
    public static final RawAnimation SHRINK = RawAnimation.begin().thenPlay("work");
    
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache(this);
    
    @SyncField({SyncType.GUI_TICK, SyncType.GUI_OPEN})
    private final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(getDefaultCapacity(), getDefaultInsertRate(), 0, this::method_5431);
    
    public final SimpleInventoryStorage inventory = new SimpleInventoryStorage(1, this::method_5431);
    
    // multiblock
    private final ArrayList<class_2338> coreBlocksConnected = new ArrayList<>();
    
    @SyncField(SyncType.GUI_OPEN)
    private float coreQuality = 1f;
    
    // addon data
    @SyncField(SyncType.GUI_OPEN)
    private final List<class_2338> connectedAddons = new ArrayList<>();
    @SyncField(SyncType.GUI_OPEN)
    private final List<class_2338> openSlots = new ArrayList<>();
    @SyncField(SyncType.GUI_OPEN)
    private BaseAddonData addonData = BaseAddonData.DEFAULT_ADDON_DATA;
    
    @SyncField(SyncType.GUI_OPEN)
    public ShrunkAddonData currentCandidate = new ShrunkAddonData(BaseAddonData.DEFAULT_ADDON_DATA, false, 0, 0, false, false);
    
    private boolean wasRedstoneActive = false;
    
    public ShrinkerBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.SHRINKER_BLOCK_ENTITY, pos, state);
    }
    
    @Override
    public void serverTick(class_1937 world, class_2338 pos, class_2680 state, NetworkedBlockEntity blockEntity) {
    
        var currentRedstone = world.method_49803(pos);
        
        if (currentRedstone && !wasRedstoneActive) {
            // recently enabled redstone
            System.out.println("triggered redstone shrink");
            doShrink();
        }
        
        wasRedstoneActive = currentRedstone;
        
    }
    
    public void doShrink() {
        
        if (energyStorage.getAmount() < getDefaultCapacity()) return;
        
        initAddons();
        
        if (currentCandidate == null || connectedAddons.isEmpty() || !inventory.method_5442()) return;
        
        energyStorage.setAmount(energyStorage.getAmount() - getDefaultCapacity());
        energyStorage.update();
        
        var createdStack = new class_1799(BlockContent.MACHINE_COMBI_ADDON.method_8389());
        createdStack.method_57379(ComponentContent.ADDON_DATA.get(), currentCandidate);
        
        inventory.setStackInSlot(0, createdStack);
        
        for (var addonPos : connectedAddons.reversed()) {
            
            field_11863.method_8652(addonPos, class_2246.field_10124.method_9564(), class_2248.field_31028);
            
            if (field_11863 instanceof class_3218 serverWorld) {
                var spawnAt = addonPos.method_46558();
                serverWorld.method_14199(class_2398.field_47494, spawnAt.field_1352, spawnAt.field_1351, spawnAt.field_1350, 1, 0, 0.1f, 0, 0.5f);
                serverWorld.method_8396(null, field_11867, class_3417.field_26971, class_3419.field_15245, 2f, 0.5f);
            }
        }
        triggerAnim("machine", "work");
        
    }
    
    @Override
    public void gatherAddonStats(List<AddonBlock> addons) {
        MachineAddonController.super.gatherAddonStats(addons);
        
        if (addons.isEmpty()) {
            currentCandidate = new ShrunkAddonData(BaseAddonData.DEFAULT_ADDON_DATA, false, 0, 0, false, false);;
            return;
        }
        
        // collect all data
        var data = getBaseAddonData();
        var fluid = false;
        var quarryCount = 0;
        var yieldCount = 0;
        var cropFilter = false;
        var silk = false;
        
        for (var addon : addons) {
            if (addon.addonBlock().equals(BlockContent.MACHINE_FLUID_ADDON)) fluid = true;
            if (addon.addonBlock().equals(BlockContent.QUARRY_ADDON)) quarryCount++;
            if (addon.addonBlock().equals(BlockContent.MACHINE_YIELD_ADDON)) yieldCount++;
            if (addon.addonBlock().equals(BlockContent.CROP_FILTER_ADDON)) cropFilter = true;
            if (addon.addonBlock().equals(BlockContent.MACHINE_SILK_TOUCH_ADDON)) silk = true;
        }
        
        currentCandidate = new ShrunkAddonData(data, fluid, quarryCount, yieldCount, cropFilter, silk);
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_1262.method_5427(nbt, inventory.heldStacks, false, registryLookup);
        addMultiblockToNbt(nbt);
        writeAddonToNbt(nbt);
        nbt.method_10544("energy_stored", energyStorage.amount);
        nbt.method_10556("redstone", wasRedstoneActive);
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_1262.method_5429(nbt, inventory.heldStacks, registryLookup);
        loadMultiblockNbtData(nbt);
        loadAddonNbtData(nbt);
        
        energyStorage.amount = nbt.method_10537("energy_stored");
        wasRedstoneActive = nbt.method_10577("redstone");
        
        updateEnergyContainer();
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(class_2350 direction) {
        return energyStorage;
    }
    
    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<>(this, "machine", 0, state -> {
            if (state.isCurrentAnimation(SETUP)) {
                if (state.getController().hasAnimationFinished()) {
                    state.setAndContinue(IDLE);
                } else {
                    return state.setAndContinue(SETUP);
                }
            }
            
            if (isActive(method_11010())) {
                return state.setAndContinue(IDLE);
            } else {
                return state.setAndContinue(PACKAGED);
            }
        })
                          .triggerableAnim("work", SHRINK)
                          .triggerableAnim("deploy", MachineBlockEntity.SETUP)
                          .setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler<>()));
    }
    
    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return animatableInstanceCache;
    }
    
    private boolean isActive(class_2680 state) {
        return state.method_11654(ASSEMBLED);
    }
    
    @Override
    public void saveExtraData(class_2540 buf) {
        sendUpdate(SyncType.GUI_OPEN);
        buf.method_10807(field_11867);
    }
    
    @Override
    public class_2561 method_5476() {
        return class_2561.method_30163("");
    }
    
    @Override
    public @Nullable class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        return new UpgradableMachineScreenHandler(i, inventory, this);
    }
    
    @Override
    public List<class_2338> getConnectedAddons() {
        return connectedAddons;
    }
    
    @Override
    public List<class_2338> getOpenAddonSlots() {
        return openSlots;
    }
    
    @Override
    public class_2338 getPosForAddon() {
        return method_11016();
    }
    
    @Override
    public class_1937 getWorldForAddon() {
        return method_10997();
    }
    
    @Override
    public class_2350 getFacingForAddon() {
        return Objects.requireNonNull(field_11863).method_8320(method_11016()).method_11654(class_2741.field_12481);
    }
    
    @Override
    public DynamicEnergyStorage getStorageForAddon() {
        return energyStorage;
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryForAddon() {
        return inventory;
    }
    
    @Override
    public ScreenProvider getScreenProvider() {
        return this;
    }
    
    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(
          new class_2382(1, 0, 0)
        );
    }
    
    @Override
    public BaseAddonData getBaseAddonData() {
        return addonData;
    }
    
    @Override
    public void setBaseAddonData(BaseAddonData data) {
        this.addonData = data;
    }
    
    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.addonConfig.addonShrinkerRF();
    }
    
    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.addonConfig.addonShrinkerRF() / 60;
    }
    
    @Override
    public List<class_2382> getCorePositions() {
        return List.of(
          new class_2382(1, 0, -1),
          new class_2382(0, 0, -1),
          new class_2382(1, 0, 1),
          new class_2382(0, 0, 1)
        );
    }
    
    @Override
    public class_2350 getFacingForMultiblock() {
        return Objects.requireNonNull(field_11863).method_8320(method_11016()).method_11654(class_2741.field_12481);
    }
    
    @Override
    public class_2338 getPosForMultiblock() {
        return method_11016();
    }
    
    @Override
    public class_1937 getWorldForMultiblock() {
        return method_10997();
    }
    
    @Override
    public ArrayList<class_2338> getConnectedCores() {
        return coreBlocksConnected;
    }
    
    @Override
    public void setCoreQuality(float quality) {
        this.coreQuality = quality;
    }
    
    @Override
    public float getCoreQuality() {
        return coreQuality;
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryForMultiblock() {
        return inventory;
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorageForMultiblock(class_2350 direction) {
        return energyStorage;
    }
    
    @Override
    public void triggerSetupAnimation() {
        triggerAnim("machine", "deploy");
    }
    
    @Override
    public List<GuiSlot> getGuiSlots() {
        return List.of(new GuiSlot(0, 40, 40, true));
    }
    
    @Override
    public float getDisplayedEnergyUsage() {
        return getDefaultCapacity();
    }
    
    @Override
    public float getProgress() {
        return 0;
    }
    
    @Override
    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }
    
    @Override
    public class_1263 getDisplayedInventory() {
        return inventory;
    }
    
    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.SHRINKER_SCREEN;
    }
    
    @Override
    public boolean showProgress() {
        return false;
    }
    
    public static void onPlayerUse(ShrinkerPlayerUsePacket packet, class_1657 player, class_5455 registryAccess) {
        
        var world = player.method_37908();
        var candidate = world.method_35230(packet.pos(), BlockEntitiesContent.SHRINKER_BLOCK_ENTITY);
        candidate.ifPresent(ShrinkerBlockEntity::doShrink);
        
    }
    
    @Override
    public ItemApi.InventoryStorage getInventoryStorage(class_2350 direction) {
        return inventory;
    }
    
    @Override
    public boolean hasRedstoneControlAvailable() {
        return true;
    }
    
    public record ShrunkAddonData(BaseAddonData data, boolean fluid, int quarryCount, int yieldCount,
                                  boolean cropFilter, boolean silk) {
        
        public static final Codec<ShrunkAddonData> CODEC = RecordCodecBuilder.create(instance -> instance.group(
          BaseAddonData.CODEC.fieldOf("data").forGetter(ShrunkAddonData::data),
          Codec.BOOL.fieldOf("fluid").forGetter(ShrunkAddonData::fluid),
          Codec.INT.fieldOf("quarry_count").forGetter(ShrunkAddonData::quarryCount),
          Codec.INT.fieldOf("yield_count").forGetter(ShrunkAddonData::yieldCount),
          Codec.BOOL.fieldOf("crop_filter").forGetter(ShrunkAddonData::cropFilter),
          Codec.BOOL.fieldOf("silk").forGetter(ShrunkAddonData::silk)
        ).apply(instance, ShrunkAddonData::new));
        
        public static final class_9139<class_9129, ShrunkAddonData> STREAM_CODEC = NetworkManager.getAutoCodec(ShrunkAddonData.class);
        
        @Override
        public @NotNull String toString() {
            return "ShrunkAddonData{" +
                     "data=" + data +
                     ", fluid=" + fluid +
                     ", quarryCount=" + quarryCount +
                     ", yieldCount=" + yieldCount +
                     ", cropFilter=" + cropFilter +
                     '}';
        }
    }
    
    public record ShrinkerPlayerUsePacket(class_2338 pos) implements class_8710 {
        
        public static final class_8710.class_9154<ShrinkerPlayerUsePacket> PACKET_ID = new class_8710.class_9154<>(Oritech.id("shrink"));
        
        @Override
        public class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }
}
