package rearth.oritech.block.entity.interaction;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_5558;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.util.AutoPlayingSoundKeyframeHandler;
import rearth.oritech.util.Geometry;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PipeBoosterBlockEntity extends class_2586 implements class_5558<PipeBoosterBlockEntity>, GeoBlockEntity, EnergyApi.BlockProvider {
    
    protected final AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache(this);
    protected final DynamicEnergyStorage energyStorage = new DynamicEnergyStorage(50000, 4000, 0, this::method_5431);
    
    public static final RawAnimation EXPAND = RawAnimation.begin().thenPlayAndHold("expand");
    public static final RawAnimation RETRACT = RawAnimation.begin().thenPlayAndHold("retract");
    public static final RawAnimation EXTENDED = RawAnimation.begin().thenPlay("extended");
    public static final RawAnimation RETRACTED = RawAnimation.begin().thenPlay("retracted");
    public static final RawAnimation WORK = RawAnimation.begin().thenPlay("work");
    
    private static final int BOOST_ENERGY_COST = 32;
    
    private boolean setPipe;
    
    public PipeBoosterBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.PIPE_BOOSTER_BLOCK_ENTITY, pos, state);
    }
    
    @Override
    public void tick(class_1937 world, class_2338 pos, class_2680 state, PipeBoosterBlockEntity blockEntity) {
        if (world.field_9236) return;
        
        if (!setPipe && (world.method_8510() & 25) == 0) {
            // try find pipe entity behind
            var targetPos = pos.method_10081(Geometry.getBackward(state.method_11654(class_2741.field_12481)));
            var candidate = world.method_8321(targetPos);
            if (candidate instanceof GenericPipeInterfaceEntity pipe) {
                pipe.connectedBooster = pos;
                setPipe = true;
                triggerAnim("machine", "expand");
            }
        }
        
        // occasionally set the correct pipe anim state
        if (world.method_8510() % 42 == 0) {
            if (setPipe) {
                triggerAnim("machine", "extended");
            } else {
                triggerAnim("machine", "retracted");
            }
        }
        
    }
    
    public boolean canUseBoost() {
        return energyStorage.amount >= BOOST_ENERGY_COST;
    }
    
    public void useBoost() {
        if (!canUseBoost()) return;
        energyStorage.amount -= BOOST_ENERGY_COST;
        this.method_5431();
        
        triggerAnim("machine", "work");
    }
    
    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10544("energy_stored", energyStorage.amount);
    }
    
    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        energyStorage.amount = nbt.method_10537("energy_stored");
    }
    
    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController<>(this, "machine", 5, state -> PlayState.CONTINUE)
                          .triggerableAnim("work", WORK)
                          .triggerableAnim("extended", EXTENDED)
                          .triggerableAnim("retracted", RETRACTED)
                          .triggerableAnim("expand", EXPAND)
                          .triggerableAnim("retract", RETRACT)
                          .setSoundKeyframeHandler(new AutoPlayingSoundKeyframeHandler<>()));
    }
    
    @Override
    public EnergyApi.EnergyStorage getEnergyStorage(@Nullable class_2350 direction) {
        return energyStorage;
    }
    
    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return animatableInstanceCache;
    }
}
