package rearth.oritech.block.blocks.pipes;

import rearth.oritech.block.entity.pipes.ExtractablePipeInterfaceEntity;
import rearth.oritech.block.entity.pipes.GenericPipeInterfaceEntity.PipeNetworkData;
import rearth.oritech.init.ItemContent;
import rearth.oritech.init.SoundContent;
import java.util.HashSet;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;

public abstract class ExtractablePipeConnectionBlock extends GenericPipeConnectionBlock {
    
    public static final int EXTRACT = 2;
    
    // 0 = no connection, 1 = normal connection, 2 = extractable connection
    public static final class_2758 NORTH = class_2758.method_11867("north", 0, 2);
    public static final class_2758 EAST = class_2758.method_11867("east", 0, 2);
    public static final class_2758 SOUTH = class_2758.method_11867("south", 0, 2);
    public static final class_2758 WEST = class_2758.method_11867("west", 0, 2);
    public static final class_2758 UP = class_2758.method_11867("up", 0, 2);
    public static final class_2758 DOWN = class_2758.method_11867("down", 0, 2);
    
    public ExtractablePipeConnectionBlock(class_2251 settings) {
        super(settings);
    }
    
    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (player.method_24518(ItemContent.WRENCH)) return class_1269.field_5811;
        if (world.field_9236) return class_1269.field_5812;
        
        var interactDir = getInteractDirection(state, pos, player);
        if (!hasMachineInDirection(interactDir, world, pos, apiValidationFunction()))
            return class_1269.field_5811;
        
        var property = directionToProperty(interactDir);
        var connection = state.method_11654(property);
        world.method_30092(pos, state.method_11657(property, connection != EXTRACT ? EXTRACT : CONNECTION), class_2248.field_31031, 0);
        
        world.method_8396(null, pos, class_3417.field_40067, class_3419.field_15245, 0.9f, 1.2f);
        
        // Invalidate cache
        invalidateTargetCache(world, pos);
        
        return class_1269.field_5812;
    }
    
    public boolean hasExtractingSide(class_2680 state) {
        for (var direction : field_23157) {
            var property = directionToProperty(direction);
            if (state.method_11654(property) == EXTRACT) return true;
        }
        
        return false;
    }
    
    /**
     * Invalidates the target cache of the block entity at the given position
     *
     * @param world the world
     * @param pos   the position
     */
    protected void invalidateTargetCache(class_1937 world, class_2338 pos) {
        var data = getNetworkData(world);
        var network = data.pipeNetworkLinks.getOrDefault(pos, null);
        if (network != null) {
            var checked = new HashSet<class_2338>();
            
            // Invalidate all pipe connection nodes in the network
            for (var pipeInterface : data.pipeNetworkInterfaces.get(network)) {
                // Skip node if already checked (node has multiple interface connections)
                var pipePos = pipeInterface.method_15442().method_10093(pipeInterface.method_15441());
                if (checked.contains(pipePos)) continue;
                
                checked.add(pipePos);
                var pipeEntity = world.method_8321(pipePos);
                if (pipeEntity instanceof ExtractablePipeInterfaceEntity)
                    ((ExtractablePipeInterfaceEntity) pipeEntity).invalidateTargetCache();
            }
        }
    }
    
    @Override
    public class_2680 addConnectionStates(class_2680 state, class_1937 world, class_2338 pos, boolean createConnection) {
        for (var direction : class_2350.values()) {
            var property = directionToProperty(direction);
            var connection = shouldConnect(state, direction, pos, world, createConnection);
            
            if (connection && state.method_11654(property) == EXTRACT) continue; // don't override extractable connections
            state = state.method_11657(property, connection ? CONNECTION : NO_CONNECTION);
        }
        
        return addStraightState(state);
    }
    
    @Override
    public class_2680 addConnectionStates(class_2680 state, class_1937 world, class_2338 pos, class_2350 createDirection) {
        for (var direction : class_2350.values()) {
            var property = directionToProperty(direction);
            var connection = shouldConnect(state, direction, pos, world, direction.equals(createDirection));
            var newValue = connection ? isSideExtractable(state, direction) ? EXTRACT : CONNECTION : NO_CONNECTION;
            state = state.method_11657(property, newValue);
        }
        return addStraightState(state);
    }
    
    /**
     * Checks if the block state is extractable from any side
     *
     * @param state the block state
     * @return true if the block state is extractable from any side
     */
    public boolean isExtractable(class_2680 state) {
        for (class_2350 side : class_2350.values()) {
            if (isSideExtractable(state, side))
                return true;
        }
        
        return false;
    }
    
    /**
     * Checks if the block state is extractable from a specific side
     *
     * @param state the block state
     * @param side  the side to check
     * @return true if the block state is extractable from the side
     */
    public boolean isSideExtractable(class_2680 state, class_2350 side) {
        return directionToPropertyValue(state, side) == EXTRACT;
    }
    
    @Override
    public class_2758 getNorthProperty() {
        return NORTH;
    }
    
    @Override
    public class_2758 getEastProperty() {
        return EAST;
    }
    
    @Override
    public class_2758 getSouthProperty() {
        return SOUTH;
    }
    
    @Override
    public class_2758 getWestProperty() {
        return WEST;
    }
    
    @Override
    public class_2758 getUpProperty() {
        return UP;
    }
    
    @Override
    public class_2758 getDownProperty() {
        return DOWN;
    }
}
